
#include <STC12C5A.H>

//=============================================================
//Define LCD PIN IO
sbit CS=P1^0;		//chip select when low
sbit DC=P1^3;		//high :data  low:command    
sbit SCL=P1^1;		//SERIAL CLOCK INPUT    
sbit SDI=P1^2;	     //SERIAL DATA INPUT/OUTPUT   
sbit RES=P2^6;		//reset


//Define key io 
sbit KEY = P2^7;  //NEXT

#define DERECTION 0    //0 or 1 is a vertical screen     2 or 3 is a horizontal screen

 
void lcd_Initial(void);
void Write_Cmd_Data(unsigned char);
void Write_Cmd(unsigned char);
void Write_Data(unsigned char DH,unsigned char DL);
void delayms(unsigned int tt);
void Write_Data_U16(unsigned int y);
 void LCD_SetPos(unsigned int Xstart,unsigned int Ystart,unsigned int Xend,unsigned int Yend);
void ClearScreen(unsigned int bColor);
void Draw_Circle(unsigned int x0,unsigned int y0,unsigned char r,unsigned int color);
void LCD_DrawRectangle(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2,unsigned int color);
void LCD_DrawLine(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2,unsigned int color);
void LCD_DrawPoint(unsigned int x,unsigned int y,unsigned int color);
void showzifustr(unsigned int x,unsigned int y,unsigned char *str,unsigned int dcolor,unsigned int bgcolor);
void showzifu(unsigned int x,unsigned int y,unsigned char value,unsigned int dcolor,unsigned int bgcolor);
  
unsigned int code pic[];
unsigned char code String6_12[];

//===============================================================
//clear screen  
void ClearScreen(unsigned int bColor)
{
 unsigned int i,j;
 LCD_SetPos(0,0,141,427); 
 for (i=0;i<428;i++)
	{
	
	   for (j=0;j<142;j++)
	       Write_Data_U16(bColor);
	}
}



//===============================================================
//write parameter
void  Write_Cmd_Data (unsigned char CMDP)
{ unsigned char i;
 	 
    CS=0;
   	DC=1;
    for(i=0;i<8;i++)
     {  SCL=0;
        if(CMDP&0x80) SDI=1;
       	else SDI=0;
       	SCL=1;
        CMDP=CMDP<<1;
     }
   	CS=1;

}


//=============================================================
//write command

void Write_Cmd(unsigned char CMD)
{ unsigned char i;
 	 
    CS=0;
   	DC=0;
    for(i=0;i<8;i++)
     {  SCL=0;
        if(CMD&0x80) SDI=1;
       	else SDI=0;
       	SCL=1;
        CMD=CMD<<1;
     }
   	CS=1;


}


//==============================================================
//write  data word
void  Write_Data_U16(unsigned int y)
{
	unsigned char m,n;
	m=y>>8;
	n=y;
	Write_Data(m,n);

}


//===================================================================
//write data byte

void Write_Data(unsigned char DH,unsigned char DL)
{unsigned char i;
 	 
    CS=0;
   	DC=1;
    for(i=0;i<8;i++)
     {  SCL=0;
        if(DH&0x80) SDI=1;
       	else SDI=0;
       	SCL=1;
        DH=DH<<1;
     }

    for(i=0;i<8;i++)
     {  SCL=0;
        if(DL&0x80) SDI=1;
       	else SDI=0;
       	SCL=1;
        DL=DL<<1;
     }

   	CS=1;

}



//============================================================
//delay
void delayms(unsigned int count)
{
    int i,j;                                                                                
    for(i=0;i<count;i++)                                                                    
       {
	     for(j=0;j<1000;j++);
       }                                                                                     
}


//show one Character
void showzifu(unsigned int x,unsigned int y,unsigned char value,unsigned int dcolor,unsigned int bgcolor)	
{  
	unsigned char i,j;
	unsigned char *temp=String6_12;    
    LCD_SetPos(x,y,x+7,y+11);      
	temp+=(value-32)*12;
	for(j=0;j<12;j++)
	{
		for(i=0;i<8;i++)
		{ 		     
		 	if((*temp&(1<<(7-i)))!=0)
			{
				Write_Data(dcolor>>8,dcolor);
			} 
			else
			{
				Write_Data(bgcolor>>8,bgcolor);
			}   
		}
		temp++;
	 }
}

//show String
void showzifustr(unsigned int x,unsigned int y,unsigned char *str,unsigned int dcolor,unsigned int bgcolor)	  
{  
	unsigned int x1,y1;
	x1=x;
	y1=y;
	while(*str!='\0')
	{	
		showzifu(x1,y1,*str,dcolor,bgcolor);
		x1+=7;
		str++;
	}	
}




void LCD_DrawPoint(unsigned int x,unsigned int y,unsigned int color)
{
	LCD_SetPos(x,y,x,y);
	Write_Data_U16(color);
} 

void LCD_DrawLine(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2,unsigned int color)
{
	unsigned int t; 
	int xerr=0,yerr=0,delta_x,delta_y,distance;
	int incx,incy,uRow,uCol;
	delta_x=x2-x1; 
	delta_y=y2-y1;
	uRow=x1;
	uCol=y1;
	if(delta_x>0)incx=1; 
	else if (delta_x==0)incx=0;
	else {incx=-1;delta_x=-delta_x;}
	if(delta_y>0)incy=1;
	else if (delta_y==0)incy=0;
	else {incy=-1;delta_y=-delta_x;}
	if(delta_x>delta_y)distance=delta_x;  
	else distance=delta_y;
	for(t=0;t<distance+1;t++)
	{
		LCD_DrawPoint(uRow,uCol,color);
		xerr+=delta_x;
		yerr+=delta_y;
		if(xerr>distance)
		{
			xerr-=distance;
			uRow+=incx;
		}
		if(yerr>distance)
		{
			yerr-=distance;
			uCol+=incy;
		}
	}
}



void LCD_DrawRectangle(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2,unsigned int color)
{
	LCD_DrawLine(x1,y1,x2,y1,color);
	LCD_DrawLine(x1,y1,x1,y2,color);
	LCD_DrawLine(x1,y2,x2,y2,color);
	LCD_DrawLine(x2,y1,x2,y2,color);
}


void Draw_Circle(unsigned int x0,unsigned int y0,unsigned char r,unsigned int color)
{
	int a,b;
	a=0;b=r;	  
	while(a<=b)
	{
		LCD_DrawPoint(x0-b,y0-a,color);             //3           
		LCD_DrawPoint(x0+b,y0-a,color);             //0           
		LCD_DrawPoint(x0-a,y0+b,color);             //1                
		LCD_DrawPoint(x0-a,y0-b,color);             //2             
		LCD_DrawPoint(x0+b,y0+a,color);             //4               
		LCD_DrawPoint(x0+a,y0-b,color);             //5
		LCD_DrawPoint(x0+a,y0+b,color);             //6 
		LCD_DrawPoint(x0-b,y0+a,color);             //7
		a++;
		if((a*a+b*b)>(r*r))
		{
			b--;
		}
	}
}



//============================================================
//show gray

void DispRGBGray(void)
{  

	unsigned int  A,B,C;
    unsigned int  i,j,k,DH;

	LCD_SetPos(0,0,141,427); 



	for(k=0;k<100;k++)
	{   
    	A=0;
    	B=0;
    	C=0;
		for(i=0;i<16;i++)
		{    
    		for(j=0;j<8;j++)
    		{
     			DH=(A<<11)+(B<<5)+C;
     			Write_Data_U16(DH);
    		}
    		A=A+2;
   			B=B+4;
    		C=C+2;
  		}
    		for(j=0;j<14;j++)
    		{
     			Write_Data_U16(0x00);
    		}
	}



	for(k=0;k<100;k++)
	{   
    	A=0;
    	B=0;
    	C=0;
		for(i=0;i<16;i++)
		{    
    		for(j=0;j<8;j++)
    		{
     			DH=(A<<11)+B+C;
     			Write_Data_U16(DH);
    		}
    		A=A+2;

  		}
    		for(j=0;j<14;j++)
    		{
     			Write_Data_U16(0x00);
    		}
	}

	for(k=0;k<100;k++)
	{   
    	A=0;
    	B=0;
    	C=0;
		for(i=0;i<16;i++)
		{    
    		for(j=0;j<8;j++)
    		{
     			DH=A+(B<<5)+C;
     			Write_Data_U16(DH);
    		}
    		B=B+4;

  		}
    		for(j=0;j<14;j++)
    		{
     			Write_Data_U16(0x00);
    		}
	}

	for(k=0;k<128;k++)
	{   
    	A=0;
    	B=0;
    	C=0;
		for(i=0;i<16;i++)
		{    
    		for(j=0;j<8;j++)
    		{
     			DH=A+B+C;
     			Write_Data_U16(DH);
    		}
    		C=C+2;

  		}
    		for(j=0;j<14;j++)
    		{
     			Write_Data_U16(0x00);
    		}
	}




}




//============================================================
//show picture
void show_picture(void)
{ 
	unsigned char i,j;
	unsigned int n=0;


   LCD_SetPos(10,40,129,199);
	for(j=0;j<160;j++)
	{
		for(i=0;i<120;i++)
		{
            Write_Data_U16(pic[n++]);
	    }
	}


    return;
}


//=============================================================
//LCD Initial

void lcd_Initial(void)
{ 
  	CS=1;
	delayms(5);
	RES=0;
	delayms(10);
	RES=1;
	delayms(50);  

 
	Write_Cmd(0xff);
	Write_Cmd_Data(0xa5);
	Write_Cmd(0x9a);
	Write_Cmd_Data(0x08);
	Write_Cmd(0x9b);
	Write_Cmd_Data(0x08);
	Write_Cmd(0x9c);
	Write_Cmd_Data(0xb0);
	Write_Cmd(0x9d);
	Write_Cmd_Data(0x16);
	Write_Cmd(0x9e);
	Write_Cmd_Data(0xc4);
	Write_Cmd(0x8f);
	Write_Cmd_Data(0x55);
	Write_Cmd_Data(0x04);
	Write_Cmd(0x84);
	Write_Cmd_Data(0x90);
	Write_Cmd(0x83);
	Write_Cmd_Data(0x7b);
	Write_Cmd(0x85);
	Write_Cmd_Data(0x33);
	Write_Cmd(0x60);
	Write_Cmd_Data(0x00);
	Write_Cmd(0x70);
	Write_Cmd_Data(0x00);
	Write_Cmd(0x61);
	Write_Cmd_Data(0x02);
	Write_Cmd(0x71);
	Write_Cmd_Data(0x02);
	Write_Cmd(0x62);
	Write_Cmd_Data(0x04);
	Write_Cmd(0x72);
	Write_Cmd_Data(0x04);
	Write_Cmd(0x6c);
	Write_Cmd_Data(0x29);
	Write_Cmd(0x7c);
	Write_Cmd_Data(0x29);
	Write_Cmd(0x6d);
	Write_Cmd_Data(0x31);
	Write_Cmd(0x7d);
	Write_Cmd_Data(0x31);
	Write_Cmd(0x6e);
	Write_Cmd_Data(0x0f);
	Write_Cmd(0x7e);
	Write_Cmd_Data(0x0f);
	Write_Cmd(0x66);
	Write_Cmd_Data(0x21);
	Write_Cmd(0x76);
	Write_Cmd_Data(0x21);
	Write_Cmd(0x68);
	Write_Cmd_Data(0x3A);
	Write_Cmd(0x78);
	Write_Cmd_Data(0x3A);
	Write_Cmd(0x63);
	Write_Cmd_Data(0x07);
	Write_Cmd(0x73);
	Write_Cmd_Data(0x07);
	Write_Cmd(0x64);
	Write_Cmd_Data(0x05);
	Write_Cmd(0x74);
	Write_Cmd_Data(0x05);
	Write_Cmd(0x65);
	Write_Cmd_Data(0x02);
	Write_Cmd(0x75);
	Write_Cmd_Data(0x02);
	Write_Cmd(0x67);
	Write_Cmd_Data(0x23);
	Write_Cmd(0x77);
	Write_Cmd_Data(0x23);
	Write_Cmd(0x69);
	Write_Cmd_Data(0x08);
	Write_Cmd(0x79);
	Write_Cmd_Data(0x08);
	Write_Cmd(0x6a);
	Write_Cmd_Data(0x13);
	Write_Cmd(0x7a);
	Write_Cmd_Data(0x13);
	Write_Cmd(0x6b);
	Write_Cmd_Data(0x13);
	Write_Cmd(0x7b);
	Write_Cmd_Data(0x13);
	Write_Cmd(0x6f);
	Write_Cmd_Data(0x00);
	Write_Cmd(0x7f);
	Write_Cmd_Data(0x00);
	Write_Cmd(0x50);
	Write_Cmd_Data(0x00);
	Write_Cmd(0x52);
	Write_Cmd_Data(0xd6);
	Write_Cmd(0x53);
	Write_Cmd_Data(0x08);
	Write_Cmd(0x54);
	Write_Cmd_Data(0x08);
	Write_Cmd(0x55);
	Write_Cmd_Data(0x1e);
	Write_Cmd(0x56);
	Write_Cmd_Data(0x1c);
    //goa map_sel
	Write_Cmd(0xa0);
	Write_Cmd_Data(0x2b);
	Write_Cmd_Data(0x24);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xa1);
	Write_Cmd_Data(0x87);
	Write_Cmd(0xa2);
	Write_Cmd_Data(0x86);
	Write_Cmd(0xa5);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xa6);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xa7);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xa8);
	Write_Cmd_Data(0x36);
	Write_Cmd(0xa9);
	Write_Cmd_Data(0x7e);
	Write_Cmd(0xaa);
	Write_Cmd_Data(0x7e);
	Write_Cmd(0xB9);
	Write_Cmd_Data(0x85);
	Write_Cmd(0xBA);
	Write_Cmd_Data(0x84);
	Write_Cmd(0xBB);
	Write_Cmd_Data(0x83);
	Write_Cmd(0xBC);
	Write_Cmd_Data(0x82);
	Write_Cmd(0xBD);
	Write_Cmd_Data(0x81);
	Write_Cmd(0xBE);
	Write_Cmd_Data(0x80);
	Write_Cmd(0xBF);
	Write_Cmd_Data(0x01);
	Write_Cmd(0xC0);
	Write_Cmd_Data(0x02);
	Write_Cmd(0xc1);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xc2);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xc3);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xc4);
	Write_Cmd_Data(0x33);
	Write_Cmd(0xc5);
	Write_Cmd_Data(0x7e);
	Write_Cmd(0xc6);
	Write_Cmd_Data(0x7e);
	Write_Cmd(0xC8);
	Write_Cmd_Data(0x33);
	Write_Cmd_Data(0x33);
	Write_Cmd(0xC9);
	Write_Cmd_Data(0x68);
	Write_Cmd(0xCA);
	Write_Cmd_Data(0x69);
	Write_Cmd(0xCB);
	Write_Cmd_Data(0x6a);
	Write_Cmd(0xCC);
	Write_Cmd_Data(0x6b);
	Write_Cmd(0xCD);
	Write_Cmd_Data(0x33);
	Write_Cmd_Data(0x33); 
	Write_Cmd(0xCE);
	Write_Cmd_Data(0x6c);
	Write_Cmd(0xCF);
	Write_Cmd_Data(0x6d);
	Write_Cmd(0xD0);
	Write_Cmd_Data(0x6e);
	Write_Cmd(0xD1);
	Write_Cmd_Data(0x6f);
	Write_Cmd(0xAB);
	Write_Cmd_Data(0x03);
	Write_Cmd_Data(0x67);
	Write_Cmd(0xAC);
	Write_Cmd_Data(0x03);
	Write_Cmd_Data(0x6b);
	Write_Cmd(0xAD);
	Write_Cmd_Data(0x03);
	Write_Cmd_Data(0x68);
	Write_Cmd(0xAE);
	Write_Cmd_Data(0x03);
	Write_Cmd_Data(0x6c);
	Write_Cmd(0xb3);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xb4);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xb5);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xB6);
	Write_Cmd_Data(0x32);
	Write_Cmd(0xB7);
	Write_Cmd_Data(0x7e);
	Write_Cmd(0xB8);
	Write_Cmd_Data(0x7e);
	Write_Cmd(0xe0);
	Write_Cmd_Data(0x00);
	Write_Cmd(0xe1);
	Write_Cmd_Data(0x03);
	Write_Cmd_Data(0x0f);
	Write_Cmd(0xe2);
	Write_Cmd_Data(0x04);
	Write_Cmd(0xe3);
	Write_Cmd_Data(0x01);
	Write_Cmd(0xe4);
	Write_Cmd_Data(0x0e);
	Write_Cmd(0xe5);
	Write_Cmd_Data(0x01);
	Write_Cmd(0xe6);
	Write_Cmd_Data(0x19);
	Write_Cmd(0xe7);
	Write_Cmd_Data(0x10);
	Write_Cmd(0xe8);
	Write_Cmd_Data(0x10);
	Write_Cmd(0xea);
	Write_Cmd_Data(0x12);
	Write_Cmd(0xeb);
	Write_Cmd_Data(0xd0);
	Write_Cmd(0xec);
	Write_Cmd_Data(0x04);
	Write_Cmd(0xed);
	Write_Cmd_Data(0x07);
	Write_Cmd(0xee);
	Write_Cmd_Data(0x07);
	Write_Cmd(0xef);
	Write_Cmd_Data(0x09);
	Write_Cmd(0xf0);
	Write_Cmd_Data(0xd0);
	Write_Cmd(0xf1);
	Write_Cmd_Data(0x0e);

    //LCD_WR_REG(0xF9);
    //LCD_WR_Byte(0x17); 
    //LCD_WR_REG(0xf2);
    //LCD_WR_Byte(0x2e);
    //LCD_WR_Byte(0x1b);
    //LCD_WR_Byte(0x0b);
    //LCD_WR_Byte(0x20);
    //LCD_WR_REG(0xF9);
	Write_Cmd_Data(0x17); 
	Write_Cmd(0xf2);
	Write_Cmd_Data(0x2c);
	Write_Cmd_Data(0x1b);
	Write_Cmd_Data(0x0b);
	Write_Cmd_Data(0x20);
    ////1 dot
	Write_Cmd(0xe9);
	Write_Cmd_Data(0x29);
	Write_Cmd(0xec);
	Write_Cmd_Data(0x04);
    //TE
	Write_Cmd(0x35);
	Write_Cmd_Data(0x00); 
	Write_Cmd(0x44);
	Write_Cmd_Data(0x00);
	Write_Cmd_Data(0x10); 
	Write_Cmd(0x46);
	Write_Cmd_Data(0x10); 
	Write_Cmd(0xff);
	Write_Cmd_Data(0x00); 
	Write_Cmd(0x3a);
	Write_Cmd_Data(0x05); 
	Write_Cmd(0x36); /* Memory Access Control */
    if (DERECTION == 0)
    {
    	Write_Cmd_Data(0x00);
    }
    else if (DERECTION == 1)
    {
    	Write_Cmd_Data(0xC0);
    }
    else if (DERECTION == 2)
    {
    	Write_Cmd_Data(0x60);
    }
    else
    {
    	Write_Cmd_Data(0xA0);
    }
	Write_Cmd(0x11); 
    delayms(120); 
	Write_Cmd(0x29); 
  

}


//===============================================================
 void LCD_SetPos(unsigned int Xstart,unsigned int Ystart,unsigned int Xend,unsigned int Yend)
{
 
 	if(DERECTION==0)
	{
		Write_Cmd(0x2a);
		Write_Cmd_Data((Xstart+0x0c)>>8);
		Write_Cmd_Data(Xstart+0x0c);
		Write_Cmd_Data((Xend+0x0c)>>8);
		Write_Cmd_Data(Xend+0x0c);
		Write_Cmd(0x2b);
		Write_Cmd_Data(Ystart>>8);
		Write_Cmd_Data(Ystart);
		Write_Cmd_Data(Yend>>8);
		Write_Cmd_Data(Yend);
		Write_Cmd(0x2c);
	}
	else if(DERECTION==1)
	{
 		Write_Cmd(0x2a);
		Write_Cmd_Data((Xstart+0x0e)>>8);
		Write_Cmd_Data(Xstart+0x0e);
		Write_Cmd_Data((Xend+0x0e)>>8);
		Write_Cmd_Data(Xend+0x0e);
		Write_Cmd(0x2b);
		Write_Cmd_Data(Ystart>>8);
		Write_Cmd_Data(Ystart);
		Write_Cmd_Data(Yend>>8);
		Write_Cmd_Data(Yend);
		Write_Cmd(0x2c);

	}
	else if(DERECTION==2)
	{
 		Write_Cmd(0x2a);
		Write_Cmd_Data(Xstart>>8);
		Write_Cmd_Data(Xstart);
		Write_Cmd_Data(Xend>>8);
		Write_Cmd_Data(Xend);
		Write_Cmd(0x2b);
		Write_Cmd_Data((Ystart+0x0e)>>8);
		Write_Cmd_Data(Ystart+0x0e);
		Write_Cmd_Data((Yend+0x0e)>>8);
		Write_Cmd_Data(Yend+0x0e);
		Write_Cmd(0x2c);

	}
	else
	{
 		Write_Cmd(0x2a);
		Write_Cmd_Data(Xstart>>8);
		Write_Cmd_Data(Xstart);
		Write_Cmd_Data(Xend>>8);
		Write_Cmd_Data(Xend);
		Write_Cmd(0x2b);
		Write_Cmd_Data((Ystart+0x0c)>>8);
		Write_Cmd_Data(Ystart+0x0c);
		Write_Cmd_Data((Yend+0x0c)>>8);
		Write_Cmd_Data(Yend+0x0c);
		Write_Cmd(0x2c);

	}  

	
}

unsigned char code String6_12[]={         
/*--   --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*--  !  --*/
0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x20,0x00,0x00,
/*--  "  --*/
0x00,0x28,0x50,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*--  #  --*/
0x00,0x00,0x28,0x28,0xFC,0x28,0x50,0xFC,0x50,0x50,0x00,0x00,
/*--  $  --*/
0x00,0x20,0x78,0xA8,0xA0,0x60,0x30,0x28,0xA8,0xF0,0x20,0x00,
/*-- %  --*/
0x00,0x00,0x48,0xA8,0xB0,0x50,0x28,0x34,0x54,0x48,0x00,0x00,
/*--  &  --*/
0x00,0x00,0x20,0x50,0x50,0x78,0xA8,0xA8,0x90,0x6C,0x00,0x00,
/*--  '  --*/
0x00,0x40,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*--  (  --*/
0x00,0x04,0x08,0x10,0x10,0x10,0x10,0x10,0x10,0x08,0x04,0x00,
/*--  )  --*/
0x00,0x40,0x20,0x10,0x10,0x10,0x10,0x10,0x10,0x20,0x40,0x00,
/*--   *  --*/
0x00,0x00,0x00,0x20,0xA8,0x70,0x70,0xA8,0x20,0x00,0x00,0x00,
/*--   +  --*/
0x00,0x00,0x20,0x20,0x20,0xF8,0x20,0x20,0x20,0x00,0x00,0x00,
/*-  ,  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x80,
/*--  -  --*/
0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
/*--   .  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,
/*--    /  --*/
0x00,0x08,0x10,0x10,0x10,0x20,0x20,0x40,0x40,0x40,0x80,0x00,
/*--   0  --*/
0x00,0x00,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00,
/*--  1  --*/
0x00,0x00,0x20,0x60,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00,
/*--   2  --*/
0x00,0x00,0x70,0x88,0x88,0x10,0x20,0x40,0x80,0xF8,0x00,0x00,
/*--   3  --*/
0x00,0x00,0x70,0x88,0x08,0x30,0x08,0x08,0x88,0x70,0x00,0x00,
/*--  4  --*/
0x00,0x00,0x10,0x30,0x50,0x50,0x90,0x78,0x10,0x18,0x00,0x00,
/*--   5  --*/
0x00,0x00,0xF8,0x80,0x80,0xF0,0x08,0x08,0x88,0x70,0x00,0x00,
/*--   6  --*/
0x00,0x00,0x70,0x90,0x80,0xF0,0x88,0x88,0x88,0x70,0x00,0x00,
/*--   7  --*/
0x00,0x00,0xF8,0x90,0x10,0x20,0x20,0x20,0x20,0x20,0x00,0x00,
/*-- 8  --*/
0x00,0x00,0x70,0x88,0x88,0x70,0x88,0x88,0x88,0x70,0x00,0x00,
/*--   9  --*/
0x00,0x00,0x70,0x88,0x88,0x88,0x78,0x08,0x48,0x70,0x00,0x00,
/*--   :  --*/
0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
/*--   ;  --*/
0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x20,0x20,0x00,
/*--   <  --*/
0x00,0x04,0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x04,0x00,0x00,
/*--  =  --*/
0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,
/*--  >  --*/
0x00,0x40,0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x40,0x00,0x00,
/*--  ?  --*/
0x00,0x00,0x70,0x88,0x88,0x10,0x20,0x20,0x00,0x20,0x00,0x00,
/*--   @  --*/
0x00,0x00,0x70,0x88,0x98,0xA8,0xA8,0xB8,0x80,0x78,0x00,0x00,
/*--  A  --*/
0x00,0x00,0x20,0x20,0x30,0x50,0x50,0x78,0x48,0xCC,0x00,0x00,
/*--   B  --*/
0x00,0x00,0xF0,0x48,0x48,0x70,0x48,0x48,0x48,0xF0,0x00,0x00,
/*--  C  --*/
0x00,0x00,0x78,0x88,0x80,0x80,0x80,0x80,0x88,0x70,0x00,0x00,
/*--  D  --*/
0x00,0x00,0xF0,0x48,0x48,0x48,0x48,0x48,0x48,0xF0,0x00,0x00,
/*--  E  --*/
0x00,0x00,0xF8,0x48,0x50,0x70,0x50,0x40,0x48,0xF8,0x00,0x00,
/*--   F  --*/
0x00,0x00,0xF8,0x48,0x50,0x70,0x50,0x40,0x40,0xE0,0x00,0x00,
/*--   G  --*/
0x00,0x00,0x38,0x48,0x80,0x80,0x9C,0x88,0x48,0x30,0x00,0x00,
/*--  H  --*/
0x00,0x00,0xCC,0x48,0x48,0x78,0x48,0x48,0x48,0xCC,0x00,0x00,
/*--   I  --*/
0x00,0x00,0xF8,0x20,0x20,0x20,0x20,0x20,0x20,0xF8,0x00,0x00,
/*--   J  --*/
0x00,0x00,0x7C,0x10,0x10,0x10,0x10,0x10,0x10,0x90,0xE0,0x00,
/*--   K  --*/
0x00,0x00,0xEC,0x48,0x50,0x60,0x50,0x50,0x48,0xEC,0x00,0x00,
/*--   L  --*/
0x00,0x00,0xE0,0x40,0x40,0x40,0x40,0x40,0x44,0xFC,0x00,0x00,
/*--  M  --*/
0x00,0x00,0xD8,0xD8,0xD8,0xD8,0xA8,0xA8,0xA8,0xA8,0x00,0x00,
/*--   N  --*/
0x00,0x00,0xDC,0x48,0x68,0x68,0x58,0x58,0x48,0xE8,0x00,0x00,
/*--   O  --*/
0x00,0x00,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00,
/*--   P  --*/
0x00,0x00,0xF0,0x48,0x48,0x70,0x40,0x40,0x40,0xE0,0x00,0x00,
/*--   Q  --*/
0x00,0x00,0x70,0x88,0x88,0x88,0x88,0xE8,0x98,0x70,0x18,0x00,
/*--  R  --*/
0x00,0x00,0xF0,0x48,0x48,0x70,0x50,0x48,0x48,0xEC,0x00,0x00,
/*--   S  --*/
0x00,0x00,0x78,0x88,0x80,0x60,0x10,0x08,0x88,0xF0,0x00,0x00,
/*--   T  --*/
0x00,0x00,0xF8,0xA8,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00,
/*--   U  --*/
0x00,0x00,0xCC,0x48,0x48,0x48,0x48,0x48,0x48,0x30,0x00,0x00,
/*--    V  --*/
0x00,0x00,0xCC,0x48,0x48,0x50,0x50,0x30,0x20,0x20,0x00,0x00,
/*--   W  --*/
0x00,0x00,0xA8,0xA8,0xA8,0x70,0x50,0x50,0x50,0x50,0x00,0x00,
/*--    X  --*/
0x00,0x00,0xD8,0x50,0x50,0x20,0x20,0x50,0x50,0xD8,0x00,0x00,
/*--    Y  --*/
0x00,0x00,0xD8,0x50,0x50,0x20,0x20,0x20,0x20,0x70,0x00,0x00,
/*--    Z  --*/
0x00,0x00,0xF8,0x90,0x10,0x20,0x20,0x40,0x48,0xF8,0x00,0x00,
/*--   [  --*/
0x00,0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x38,0x00,
/*--    \  --*/
0x00,0x40,0x40,0x40,0x20,0x20,0x10,0x10,0x10,0x08,0x00,0x00,
/*--    ]  --*/
0x00,0x70,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x70,0x00,
/*--    ^  --*/
0x00,0x20,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*--   _  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,
/*--   `  --*/
0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*--  a  --*/
0x00,0x00,0x00,0x00,0x00,0x30,0x48,0x38,0x48,0x3C,0x00,0x00,
/*--   b  --*/
0x00,0x00,0xC0,0x40,0x40,0x70,0x48,0x48,0x48,0x70,0x00,0x00,
/*--   c  --*/
0x00,0x00,0x00,0x00,0x00,0x38,0x48,0x40,0x40,0x38,0x00,0x00,
/*--  d  --*/
0x00,0x00,0x18,0x08,0x08,0x38,0x48,0x48,0x48,0x3C,0x00,0x00,
/*--    e  --*/
0x00,0x00,0x00,0x00,0x00,0x30,0x48,0x78,0x40,0x38,0x00,0x00,
/*--   f  --*/
0x00,0x00,0x1C,0x20,0x20,0x78,0x20,0x20,0x20,0x78,0x00,0x00,
/*--   g  --*/
0x00,0x00,0x00,0x00,0x00,0x3C,0x48,0x30,0x40,0x78,0x44,0x38,
/*--    h  --*/
0x00,0x00,0xC0,0x40,0x40,0x70,0x48,0x48,0x48,0xEC,0x00,0x00,
/*--   i  --*/
0x00,0x00,0x20,0x00,0x00,0x60,0x20,0x20,0x20,0x70,0x00,0x00,
/*--   j  --*/
0x00,0x00,0x10,0x00,0x00,0x30,0x10,0x10,0x10,0x10,0x10,0xE0,
/*--   k  --*/
0x00,0x00,0xC0,0x40,0x40,0x5C,0x50,0x70,0x48,0xEC,0x00,0x00,
/*--  l  --*/
0x00,0x00,0xE0,0x20,0x20,0x20,0x20,0x20,0x20,0xF8,0x00,0x00,
/*--   m  --*/
0x00,0x00,0x00,0x00,0x00,0xF0,0xA8,0xA8,0xA8,0xA8,0x00,0x00,
/*--    n  --*/
0x00,0x00,0x00,0x00,0x00,0xF0,0x48,0x48,0x48,0xEC,0x00,0x00,
/*--    o  --*/
0x00,0x00,0x00,0x00,0x00,0x30,0x48,0x48,0x48,0x30,0x00,0x00,
/*--   p  --*/
0x00,0x00,0x00,0x00,0x00,0xF0,0x48,0x48,0x48,0x70,0x40,0xE0,
/*--  q  --*/
0x00,0x00,0x00,0x00,0x00,0x38,0x48,0x48,0x48,0x38,0x08,0x1C,
/*--    r  --*/
0x00,0x00,0x00,0x00,0x00,0xD8,0x60,0x40,0x40,0xE0,0x00,0x00,
/*--    s  --*/
0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x30,0x08,0x78,0x00,0x00,
/*--   t  --*/
0x00,0x00,0x00,0x20,0x20,0x70,0x20,0x20,0x20,0x18,0x00,0x00,
/*--    u  --*/
0x00,0x00,0x00,0x00,0x00,0xD8,0x48,0x48,0x48,0x3C,0x00,0x00,
/*--   v  --*/
0x00,0x00,0x00,0x00,0x00,0xEC,0x48,0x50,0x30,0x20,0x00,0x00,
/*--   w  --*/
0x00,0x00,0x00,0x00,0x00,0xA8,0xA8,0x70,0x50,0x50,0x00,0x00,
/*--  x  --*/
0x00,0x00,0x00,0x00,0x00,0xD8,0x50,0x20,0x50,0xD8,0x00,0x00,
/*--   y  --*/
0x00,0x00,0x00,0x00,0x00,0xEC,0x48,0x50,0x30,0x20,0x20,0xC0,
/*--  z  --*/
0x00,0x00,0x00,0x00,0x00,0x78,0x10,0x20,0x20,0x78,0x00,0x00,
/* {  --*/
0x00,0x18,0x10,0x10,0x10,0x20,0x10,0x10,0x10,0x10,0x18,0x00,
/*--    |  --*/
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
/*--   }  --*/
0x00,0x60,0x20,0x20,0x20,0x10,0x20,0x20,0x20,0x20,0x60,0x00,
/*--  ~  --*/
0x40,0xA4,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

};  





unsigned int code pic[]=
{//120*160
0x851b,0x025a,0x1a9b,0x12bb,0x12bb,0x1abc,0x0abb,0x22dc,0x333c,0x12bc,0x12bb,0x12bc,0x12bc,0x12bb,0x12bb,0x12bb,0x129b,0x0a7b,0x1adc,0x1afb,0x22db,0x0abb,0x129b,0x12ba,0x12ba,0x12ba,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12ba,0x12ba,0x12ba,0x12bb,0x12bb,0x12bb,0x12da,0x12da,0x12da,0x12da,0x12da,0x12fa,0x12f9,0x1afa,0x196a,0x1061,0x1082,0x1062,0x0841,0x0841,0x0862,0x0862,0x0861,0x0861,0x1062,0x0861,0x0861,0x1062,0x1082,0x1082,0x1082,0x1082,0x1082,0x1062,0x1062,0x1062,0x1062,0x1062,0x1082,0x1062,0x1062,0x10a3,0x2125,0x3186,0x31c8,0x3a4b,0x428c,0x31a7,0x18c3,0x1083,0x0882,0x0861,0x18c3,0x18c3,0x0882,0x1082,0x18c3,0x18e4,0x18c3,0x10c3,0x08a3,0x18e4,0x2146,0x1925,0x2145,0x0882,0x10c3,0x0862,0x0021,0x0841,0x0842,0x1083,0x2945,0x31a7,0x3186,0x4a6a,0x52ac,0x39c7,0x2104,0x0841,0x10c4,0x1906,0x19f1,0x12d9,0x12b8,0x0ab8,0x0278,0x6c9b,0x851b,0x025a,0x129b,0x12bb,0x12bb,0x0a9b,0x2b5b,0x6c9b,0x4bdb,0x439c,0x0a9c,0x12bc,0x12bb,0x12bb,0x12bb,0x0a7b,0x22da,0x645a,0x4bda,0x6419,0x53fa,0x5c5b,0x1ada,0x0a9a,0x12bb,0x12ba,0x1ada,0x129b,0x129b,0x129b,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12db,0x12da,0x12da,0x12da,0x12f9,0x131a,0x1a10,0x1083,0x0882,0x0862,0x0861,0x0841,0x0841,0x1082,0x0861,0x0861,0x0861,0x0861,0x1082,0x1082,0x1062,0x0861,0x0861,0x1062,0x1062,0x0861,0x0841,0x0841,0x0841,0x0861,0x10a2,0x1082,0x1062,0x1062,0x1062,0x18a3,0x2945,0x424b,0x4a6b,0x39e8,0x2925,0x20c3,0x2924,0x18a2,0x20c3,0x2904,0x18a3,0x18c3,0x2104,0x18c3,0x1082,0x1082,0x1083,0x1904,0x10a3,0x1905,0x2125,0x18e4,0x10a3,0x10c3,0x0862,0x0862,0x0862,0x10a3,0x0862,0x20e4,0x4a29,0x524a,0x39e8,0x4aab,0x4a29,0x39e8,0x2966,0x10a3,0x1908,0x21ad,0x1276,0x12b9,0x0ab8,0x0278,0x6c9b,
0x851b,0x0a5a,0x12bb,0x129b,0x12bb,0x0a9b,0x645b,0x22fb,0x231c,0x53fb,0x0a9c,0x12bc,0x12bb,0x12bb,0x0a9b,0x2b1a,0x6c9a,0x2b3a,0x129b,0x853c,0x12bb,0x3bbb,0x5c5c,0x025b,0x027b,0x543b,0x43ba,0x0a7a,0x129a,0x129b,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12db,0x12da,0x12da,0x12da,0x12fa,0x1a96,0x10e4,0x0861,0x0862,0x0861,0x0841,0x0841,0x0861,0x1082,0x0861,0x0861,0x0861,0x0861,0x1062,0x0861,0x0841,0x1062,0x1062,0x0841,0x0841,0x0841,0x0841,0x0861,0x1082,0x18c3,0x18a3,0x0861,0x0862,0x18a3,0x18c4,0x2146,0x426c,0x428c,0x3209,0x39e9,0x2926,0x41e8,0x4186,0x3986,0x39c7,0x3166,0x2924,0x2124,0x2104,0x1062,0x1082,0x1082,0x10a3,0x2105,0x2125,0x1904,0x18e4,0x0883,0x0862,0x0842,0x0862,0x0862,0x0862,0x10a3,0x18e4,0x18c3,0x39c8,0x6acc,0x62ed,0x4a8b,0x4a8a,0x31a7,0x2966,0x2946,0x1909,0x21cf,0x19f1,0x12b9,0x12d8,0x0278,0x6c9b,0x8d1b,0x025b,0x12bb,0x337b,0x0a7c,0x231b,0x649b,0x12bb,0x749b,0x2b7a,0x0a9b,0x12bb,0x0abb,0x12da,0x023a,0x6cda,0x43ba,0x025a,0x3b9b,0x437a,0x023b,0x4bda,0x853c,0x335b,0x129b,0x5c1b,0x129b,0x12bb,0x12bb,0x12bb,0x12bb,0x129b,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12ba,0x12da,0x12ba,0x12da,0x12da,0x198c,0x0881,0x0882,0x0862,0x0841,0x0842,0x0841,0x0841,0x0841,0x0861,0x0861,0x0861,0x0841,0x0861,0x1082,0x0862,0x0861,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0861,0x0861,0x1082,0x18e4,0x2905,0x29a8,0x320a,0x39e9,0x39a7,0x3a09,0x3187,0x39c8,0x5228,0x49c7,0x3186,0x2945,0x3125,0x2945,0x2945,0x18c3,0x18a3,0x18a2,0x18c4,0x1905,0x18e4,0x2125,0x2104,0x10a3,0x1083,0x0862,0x0862,0x0862,0x0882,0x2125,0x2104,0x2125,0x1904,0x2145,0x4229,0x630d,0x52ac,0x424a,0x4229,0x2125,0x2145,0x2148,0x19f3,0x21d0,0x1276,0x12d9,0x0278,0x6c9b,
0x851b,0x025b,0x129b,0x5c1b,0x335b,0x647b,0x749b,0x4bfb,0x84fb,0x2b3a,0x43db,0x7cfb,0x4c1c,0x647b,0x6cbb,0x333c,0x6c9b,0x3b7a,0x6c9a,0x335b,0x43db,0x9d9c,0x643a,0x53fa,0x439a,0x645b,0x335b,0x0a9a,0x129b,0x129b,0x129b,0x129b,0x129b,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12da,0x12da,0x12da,0x1a32,0x10c3,0x0862,0x0862,0x0842,0x1062,0x0862,0x0862,0x0861,0x1082,0x1062,0x0861,0x0841,0x0861,0x1061,0x0861,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x10a2,0x18c3,0x18c3,0x2104,0x3165,0x3166,0x39c8,0x4209,0x39a7,0x3145,0x5206,0x5207,0x4186,0x3145,0x3965,0x3986,0x3145,0x28e4,0x20e3,0x20e4,0x2945,0x2986,0x2966,0x2145,0x1904,0x2104,0x18c3,0x0862,0x0862,0x0862,0x0842,0x0842,0x18c3,0x39c7,0x4228,0x39e8,0x1904,0x2966,0x424a,0x528b,0x39e8,0x39c8,0x3165,0x18a3,0x1907,0x1a13,0x21f1,0x1a35,0x12d9,0x0279,0x6c9b,0x853b,0x025b,0x2b3b,0x645c,0x74db,0xae1c,0x335b,0x333b,0x4bdc,0x5c5b,0xb65b,0x955b,0x5c5b,0x9d9a,0x7d1b,0x0a9c,0x025b,0x439b,0x953a,0x541a,0x53dc,0x6c59,0x021a,0x3b7b,0x84f9,0x8d59,0x541b,0x0a7b,0x129a,0x129b,0x12bb,0x12bb,0x129b,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12db,0x12da,0x12bb,0x2278,0x1928,0x1083,0x0883,0x0862,0x0862,0x1082,0x1062,0x10a3,0x1082,0x0861,0x0841,0x0861,0x0861,0x0841,0x0861,0x0861,0x0861,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0861,0x1082,0x18c3,0x18a3,0x1882,0x18c3,0x2924,0x3965,0x422a,0x4a4b,0x5249,0x49c6,0x5a27,0x6a47,0x5a28,0x51c6,0x49a6,0x41c7,0x2945,0x28e4,0x3124,0x41c7,0x528b,0x4249,0x3a29,0x29a7,0x2986,0x1904,0x18e4,0x18c4,0x0862,0x0842,0x1062,0x0862,0x0842,0x0841,0x2104,0x4a69,0x5acb,0x3a08,0x18e4,0x2105,0x424a,0x528b,0x3186,0x2945,0x18a3,0x10a4,0x19f1,0x1a32,0x1a33,0x12b8,0x0279,0x6c9c,
0x853b,0x023a,0x647a,0x43bb,0x541b,0x7cdb,0x4bfa,0x4bfc,0x6c9b,0x8d5c,0xa5fc,0x4b7b,0x9d7c,0x6cbc,0x6cbc,0x12da,0x0a7c,0x647a,0x3b7b,0x025c,0x1adb,0x6cba,0x4bfa,0x5c1a,0x84fb,0x6cbc,0x3b9b,0x0a7b,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12da,0x1abb,0x19f2,0x1083,0x0883,0x0882,0x0862,0x0882,0x1082,0x10a2,0x10a2,0x0861,0x0841,0x0841,0x0861,0x0841,0x0861,0x0841,0x0861,0x0861,0x0861,0x0841,0x0842,0x1082,0x1062,0x1062,0x1082,0x2104,0x18a3,0x1062,0x20a3,0x28e4,0x3145,0x4209,0x528c,0x5a8a,0x6289,0x6aa9,0x72c9,0x72ca,0x6289,0x6a47,0x5208,0x3966,0x3925,0x41a6,0x5a48,0x734c,0x632c,0x5b0c,0x5aec,0x428a,0x29a7,0x2125,0x18c4,0x1082,0x0862,0x0862,0x0862,0x18c3,0x1083,0x10a3,0x2104,0x39e7,0x52aa,0x4a6a,0x2146,0x2105,0x3186,0x39e8,0x39c8,0x2945,0x2104,0x1082,0x19af,0x1a34,0x1a33,0x1278,0x0279,0x6c9c,0x853b,0x025b,0x231b,0x5c9b,0x541b,0x0abb,0x1afb,0x439c,0x2b1b,0x6c9b,0x1afa,0x12fb,0x335a,0x0a9a,0x337a,0x12bb,0x0abc,0x2b3a,0x12bb,0x129c,0x0a7b,0x231b,0x3b7c,0x129b,0x0a9b,0x1ada,0x2b1a,0x0a9b,0x129b,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12ba,0x1a98,0x18e7,0x0882,0x10a3,0x0882,0x0862,0x0882,0x10a3,0x1082,0x0841,0x0861,0x0841,0x0841,0x0841,0x0841,0x1082,0x0841,0x0861,0x0861,0x0861,0x1062,0x1083,0x1083,0x1062,0x1083,0x18c3,0x18c3,0x18a2,0x28e3,0x2904,0x3105,0x41a7,0x5aab,0x6aec,0x734d,0x732c,0x7b0b,0x7b2a,0x72e9,0x7288,0x6248,0x41a6,0x51e7,0x51e7,0x6aa9,0x8bad,0x8bce,0x6b2b,0x6b4c,0x6b6d,0x52cb,0x39e8,0x18c4,0x10a3,0x1082,0x0862,0x0862,0x0842,0x10a3,0x2925,0x18c4,0x2124,0x2966,0x4a8a,0x52ac,0x31c7,0x2125,0x31e9,0x3187,0x2946,0x18e4,0x18e4,0x18e3,0x198c,0x1a55,0x1a13,0x1275,0x0278,0x6c9c,
0x853c,0x027b,0x0abc,0x0a9b,0x0a9c,0x12db,0x12bc,0x6cba,0x5c5a,0x3bdb,0x12dc,0x337b,0x2b5b,0x335b,0x335b,0x2b3b,0x233b,0x2b5b,0x335a,0x2b3b,0x335b,0x43da,0x2b5b,0x22fa,0x335a,0x339a,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12ba,0x12db,0x19cf,0x1082,0x10a3,0x0862,0x0862,0x0862,0x0862,0x1082,0x1082,0x0841,0x0861,0x0841,0x0841,0x0841,0x0841,0x0841,0x0861,0x1062,0x0861,0x0861,0x1082,0x1062,0x1061,0x1882,0x18a2,0x20a3,0x28c3,0x28e3,0x28c3,0x3124,0x4a08,0x62aa,0x72ec,0x732c,0x7b2c,0x7b2b,0x832a,0x8309,0x7ac8,0x5a48,0x51e7,0x6228,0x6248,0x8b6c,0xac70,0xac70,0x9c0e,0x8bad,0x6b0b,0x5aaa,0x52aa,0x4a6a,0x2946,0x18c4,0x1083,0x0882,0x18a3,0x1083,0x10a3,0x2104,0x3166,0x2924,0x10c3,0x2966,0x52cc,0x426a,0x2145,0x2987,0x422a,0x2987,0x18e4,0x18c3,0x18a3,0x18e7,0x1a55,0x1a34,0x1a55,0x0278,0x6c9c,0x853c,0x025b,0x12dc,0x12bc,0x12bc,0x12dc,0x0adc,0x231b,0x337b,0x0a9c,0x2b7b,0x8d5c,0x6cdc,0x751c,0x751c,0x6cbc,0x43ba,0x857b,0x7d3b,0x74fa,0x647b,0x647b,0x541b,0x647b,0x6c9a,0x7d3b,0x22fb,0x0abb,0x12bb,0x12bb,0x12bb,0x12db,0x12bb,0x12db,0x12db,0x12db,0x12bb,0x12bb,0x12db,0x12dc,0x1a77,0x18e6,0x1083,0x0882,0x0882,0x0882,0x1082,0x0842,0x0862,0x0861,0x0841,0x0861,0x0841,0x0841,0x0841,0x0841,0x0841,0x0861,0x0841,0x0841,0x0862,0x1062,0x1062,0x1882,0x28e3,0x28e3,0x28c3,0x28a3,0x28e3,0x3924,0x5208,0x6289,0x6aca,0x6aeb,0x7b0b,0x832b,0x8b4b,0x8b8b,0x830a,0x6248,0x5a28,0x6a89,0x7aea,0xc4b1,0xe595,0xdd75,0xcd13,0xb490,0xbcb1,0xa44f,0x72ea,0x62aa,0x5269,0x39a7,0x2905,0x18a3,0x1082,0x18a3,0x2125,0x18c3,0x2945,0x3185,0x4227,0x18e3,0x0862,0x29a7,0x424a,0x31a7,0x2966,0x31e9,0x31a7,0x2145,0x20e4,0x18a4,0x18e5,0x1a13,0x1a56,0x2255,0x0299,0x6cbc,
0x853b,0x025b,0x12bc,0x12bc,0x12bb,0x12bc,0x12bc,0x0abb,0x0abb,0x12dc,0x12bb,0x1afb,0x12bb,0x1adb,0x12bb,0x1afb,0x3b9b,0x1afb,0x1afb,0x1b1b,0x1adc,0x129b,0x12db,0x1afb,0x12bb,0x12bb,0x12db,0x12bb,0x12bb,0x12bb,0x12bb,0x12db,0x12bb,0x12db,0x0adb,0x12fc,0x12db,0x12db,0x12db,0x1abb,0x21af,0x10a3,0x1083,0x10a3,0x1083,0x0862,0x0862,0x0842,0x0862,0x0861,0x0861,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x1062,0x1082,0x1062,0x20a3,0x30e4,0x28e4,0x20c3,0x20a3,0x3104,0x4186,0x51e7,0x6268,0x62cb,0x6aeb,0x836b,0x8b6b,0x93ad,0x93ad,0x732b,0x5a68,0x6a48,0x7a88,0x9b8c,0xdd74,0xf618,0xee17,0xe5f6,0xdd54,0xcd12,0xccf1,0xbc90,0x9bed,0x72ea,0x5a28,0x41a6,0x3125,0x2905,0x18c4,0x18e4,0x2946,0x2946,0x3187,0x31a5,0x5248,0x4207,0x2104,0x2105,0x424a,0x2986,0x2987,0x31e9,0x39c8,0x2146,0x2104,0x18c4,0x18c5,0x21f1,0x1a96,0x1a74,0x02b9,0x6cdc,0x8d1b,0x025b,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bb,0x12db,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x129b,0x0a9b,0x12bb,0x12bc,0x12bc,0x12bb,0x12bb,0x129b,0x129b,0x12bb,0x129b,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bb,0x12db,0x0adc,0x12db,0x12bb,0x12bb,0x2277,0x1927,0x1083,0x0883,0x1083,0x1082,0x0862,0x0862,0x0842,0x0862,0x1061,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x1062,0x1082,0x1882,0x18a2,0x3104,0x30e4,0x20a3,0x20a3,0x3905,0x4986,0x5a48,0x6269,0x6289,0x730c,0x834c,0x93ac,0x8bad,0x8b8d,0x730b,0x5269,0x72c9,0x8309,0xb44f,0xedf7,0xf658,0xf658,0xf658,0xee37,0xe5d5,0xe594,0xdd52,0xbc8f,0xa3ec,0x938b,0x62a8,0x5207,0x4186,0x3145,0x2925,0x2946,0x2125,0x3166,0x31a7,0x31a7,0x4a28,0x4a28,0x2145,0x1904,0x3187,0x39e7,0x2987,0x29ca,0x2987,0x18e4,0x2104,0x18c4,0x18a3,0x198e,0x1297,0x1a54,0x0279,0x6cbc,
0x8d1b,0x025a,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bb,0x12bb,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bb,0x12bb,0x12bb,0x12bc,0x12bc,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12db,0x12db,0x0adc,0x12db,0x12bb,0x1abb,0x21cf,0x10c3,0x1083,0x10a4,0x1083,0x0842,0x0842,0x0862,0x1062,0x0862,0x0841,0x0841,0x0861,0x0861,0x0841,0x0841,0x0841,0x0861,0x1062,0x1082,0x1882,0x18a3,0x28e4,0x28e4,0x28c3,0x30e3,0x4145,0x51a6,0x6248,0x6268,0x6aa9,0x7b2c,0x8b6c,0x836c,0x832b,0x7b0b,0x734c,0x62ca,0x7b0a,0xa3cd,0xcd13,0xf679,0xf699,0xf699,0xf679,0xf678,0xf637,0xedf6,0xedd5,0xe593,0xbcb0,0xa3ec,0x9bed,0x8b4b,0x6248,0x51c6,0x4186,0x2904,0x2905,0x2925,0x2965,0x39e8,0x39e9,0x4a69,0x5aca,0x31c8,0x1904,0x10c3,0x2965,0x3166,0x29a8,0x2146,0x18c4,0x18c4,0x18c4,0x18a3,0x1929,0x1a75,0x1a55,0x0278,0x6cbc,0x8d3c,0x025b,0x12dc,0x12bc,0x12dc,0x12dc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bc,0x12bb,0x12bb,0x12bb,0x12bb,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12dc,0x12dc,0x12fc,0x12db,0x12dc,0x1a77,0x1105,0x1083,0x10a3,0x10a3,0x0842,0x0862,0x0862,0x0862,0x0862,0x0841,0x0841,0x0841,0x1082,0x0861,0x0861,0x0841,0x0841,0x1061,0x1082,0x18a3,0x1062,0x20c3,0x20c3,0x28a3,0x3904,0x4945,0x5a07,0x6227,0x6a68,0x72a9,0x7b2b,0x7b0a,0x7ae9,0x830a,0x836c,0x7b6d,0x6aeb,0x832c,0xac50,0xd554,0xfe79,0xfe79,0xf69a,0xf69a,0xf69a,0xf679,0xf658,0xee16,0xedf5,0xe594,0xcd11,0xb44e,0xa3cc,0x9bac,0x7aaa,0x5a28,0x49a6,0x3986,0x2105,0x3166,0x2945,0x41e8,0x39e9,0x52cb,0x6b4d,0x4a8b,0x18e4,0x10c3,0x18c3,0x3186,0x2947,0x1905,0x18c4,0x18e4,0x18c4,0x18a3,0x18e6,0x1a35,0x1a57,0x0278,0x6cbc,
0x853c,0x027b,0x12bc,0x12bc,0x12bc,0x12dc,0x12dc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bb,0x12bb,0x12bb,0x12bc,0x12bc,0x12bc,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12dc,0x12bc,0x12bc,0x12dc,0x12dc,0x0adc,0x12db,0x1abc,0x218d,0x0862,0x0883,0x18c3,0x1062,0x1082,0x1082,0x0862,0x0862,0x0842,0x0862,0x0861,0x0861,0x1082,0x0841,0x0841,0x0841,0x1082,0x1082,0x1082,0x1062,0x18a3,0x28c3,0x28c3,0x4124,0x51a6,0x6228,0x6227,0x6a67,0x7aea,0x834b,0x7ae9,0x7ae9,0x8b6a,0x8b8c,0x732c,0x6aeb,0x8b6d,0xb450,0xddd6,0xf679,0xf679,0xfe7a,0xfe9a,0xf69a,0xf69a,0xf659,0xf638,0xee17,0xedf5,0xe5b4,0xdd53,0xccf1,0xac0d,0x9bac,0x8b2b,0x6aa9,0x5207,0x41c7,0x3967,0x2905,0x41c7,0x3186,0x426b,0x3a2a,0x5b0e,0x5b0d,0x2986,0x10a3,0x1082,0x2945,0x2947,0x18e5,0x10a4,0x10c3,0x18c4,0x1883,0x10c6,0x19f3,0x1a57,0x0258,0x6cbc,0x853b,0x025b,0x12dc,0x12dc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bb,0x12bb,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12dc,0x12bc,0x12dc,0x12dc,0x12dc,0x12bc,0x12dc,0x12dc,0x12dc,0x12fc,0x1a78,0x18c5,0x10a3,0x10c4,0x1082,0x1083,0x10a3,0x0882,0x0842,0x0841,0x0862,0x0862,0x0861,0x0861,0x0841,0x0841,0x0861,0x1082,0x1082,0x1062,0x1061,0x1882,0x28e3,0x30e3,0x4125,0x51a6,0x5a06,0x6247,0x6a88,0x7ae9,0x7b0a,0x6a88,0x8309,0x93ab,0x836b,0x62aa,0x6aca,0x938c,0xb4b1,0xe5d6,0xf658,0xf679,0xf679,0xfe7a,0xf69a,0xf69a,0xf699,0xf659,0xf638,0xf637,0xf616,0xedf5,0xed94,0xdd32,0xbc6f,0xa3ec,0x938c,0x7b0b,0x5a48,0x49e7,0x4a29,0x2925,0x3186,0x4208,0x3a09,0x3a4b,0x4aac,0x5b0d,0x3a08,0x18e4,0x10a2,0x2945,0x2967,0x18e5,0x18e5,0x1083,0x18c3,0x20e4,0x10c4,0x19d0,0x1a78,0x0a58,0x6cbc,
0x8d1b,0x025b,0x12bc,0x12dc,0x12dc,0x12bc,0x12bc,0x12bb,0x12bb,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bb,0x12db,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12db,0x12db,0x12fd,0x19cf,0x0862,0x10a4,0x10a4,0x10a4,0x0883,0x0862,0x0862,0x0841,0x0861,0x0862,0x0862,0x0861,0x0841,0x0841,0x0861,0x1082,0x1082,0x1082,0x1062,0x1883,0x28c3,0x30e3,0x4985,0x6228,0x6a88,0x6aa7,0x72c8,0x7ae9,0x72c9,0x6a67,0x832a,0x9bcc,0x834a,0x62aa,0x6aaa,0x8b8c,0xbcd2,0xe617,0xf678,0xf679,0xf679,0xf679,0xf69a,0xf69a,0xf69a,0xf699,0xf679,0xf658,0xf637,0xf616,0xee16,0xedd5,0xe593,0xccd0,0xb44e,0x9bcd,0x8b6b,0x6aa9,0x41e7,0x4a6a,0x4a4a,0x20e4,0x4a4a,0x31c8,0x3a4b,0x3a2a,0x4aac,0x424a,0x31a7,0x1082,0x18a3,0x2125,0x1905,0x1925,0x18c4,0x10a3,0x18a4,0x18a3,0x19ae,0x1ab8,0x0258,0x6cbc,0x8d3b,0x025b,0x12bc,0x12dc,0x12dc,0x12bc,0x12bc,0x12db,0x12bb,0x12bb,0x12dc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bb,0x12bb,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12dc,0x12bc,0x12bc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12db,0x12fc,0x1aba,0x10e6,0x10a3,0x10a4,0x10a3,0x0862,0x0842,0x0862,0x0862,0x1062,0x1082,0x0861,0x0861,0x0861,0x0841,0x0861,0x1082,0x1062,0x0861,0x1062,0x18a2,0x20c3,0x3104,0x49a6,0x5a48,0x72c9,0x7ae9,0x8329,0x7b09,0x6a88,0x72a8,0x8b6b,0x9bec,0x7ae9,0x6248,0x6288,0x93ad,0xcd13,0xee37,0xee58,0xf678,0xf679,0xf679,0xf69a,0xf69a,0xf69a,0xf69a,0xf699,0xf679,0xf678,0xf658,0xf637,0xf636,0xedf5,0xe5d4,0xdd72,0xc48f,0xa40d,0x9bac,0x7b2a,0x4a08,0x39c7,0x4a6a,0x2105,0x3187,0x4a4a,0x31e9,0x3a2a,0x424a,0x424a,0x3186,0x20e3,0x1082,0x18e4,0x0862,0x18e4,0x18e4,0x1082,0x18a3,0x18c4,0x198d,0x1a98,0x0a58,0x6cbc,
0x853b,0x025b,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12db,0x12bb,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x0abc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x12dc,0x0b1c,0x1a33,0x10a4,0x10a3,0x1083,0x0862,0x1083,0x1082,0x0842,0x0862,0x1082,0x0861,0x0861,0x0861,0x0861,0x0861,0x1082,0x1082,0x0841,0x1062,0x1082,0x1882,0x28e3,0x49e7,0x6288,0x7b09,0x8309,0x8b2a,0x832a,0x6a67,0x7b09,0x93cb,0xa3ed,0x7ac9,0x6227,0x6247,0x938c,0xcd53,0xee17,0xee58,0xf658,0xf679,0xf679,0xf69a,0xf69a,0xf69a,0xf69a,0xfe9a,0xfe9a,0xfe99,0xf679,0xf678,0xf657,0xf637,0xf616,0xedf5,0xe5b3,0xd511,0xb44e,0xa3ac,0x8b6b,0x5a68,0x3986,0x39c7,0x41e8,0x2105,0x424a,0x3a09,0x3a09,0x424a,0x3a09,0x2145,0x2124,0x1082,0x20e4,0x0841,0x10a3,0x18c4,0x1062,0x10a3,0x18c3,0x198d,0x1278,0x0a58,0x6cbc,0x853b,0x027b,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12db,0x12bb,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12bc,0x12dc,0x12bc,0x0adc,0x12dc,0x0adc,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0afc,0x12fc,0x198c,0x10a3,0x1083,0x0862,0x1062,0x10a3,0x0862,0x0842,0x0862,0x1082,0x0861,0x0841,0x0861,0x1082,0x1082,0x10a2,0x1061,0x1082,0x1082,0x1882,0x20a2,0x2904,0x5228,0x7b0b,0x7b09,0x8b4a,0x8309,0x72a8,0x8b2a,0x9bcc,0xa40d,0x830a,0x6268,0x6a68,0x8b6c,0xd574,0xee17,0xee37,0xf658,0xf679,0xf679,0xf699,0xf69a,0xfe9a,0xfe9a,0xfe9a,0xf69a,0xf69a,0xfe99,0xf679,0xf678,0xf658,0xf657,0xf636,0xedf5,0xe5d4,0xdd73,0xccd0,0xabed,0x8b8c,0x62a9,0x3986,0x2945,0x4229,0x2945,0x2966,0x4229,0x31c7,0x39e8,0x4a8a,0x2966,0x10a2,0x1082,0x2104,0x0862,0x10a3,0x18c4,0x0862,0x1083,0x10a2,0x198c,0x1a77,0x0278,0x6cbc,
0x853c,0x027b,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x0adc,0x0adc,0x12bc,0x12bc,0x12dc,0x12dc,0x12dc,0x0adc,0x0adc,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x12dc,0x0adc,0x0afc,0x0afc,0x1a99,0x1907,0x10a3,0x0883,0x0862,0x0862,0x0862,0x0862,0x0862,0x1083,0x0862,0x0841,0x0841,0x1062,0x10a2,0x1082,0x0861,0x1082,0x18a2,0x28e3,0x28e3,0x20c3,0x2104,0x3965,0x6248,0x834b,0x7aea,0x72a8,0x93ac,0x9bcc,0xa40c,0x7b0a,0x6268,0x6268,0x93ad,0xddb5,0xee17,0xee37,0xf657,0xf658,0xf679,0xf679,0xf699,0xf67a,0xfe9a,0xfeba,0xfeba,0xf69a,0xf699,0xf679,0xf679,0xf678,0xf658,0xf657,0xf636,0xf615,0xedf4,0xe593,0xd511,0xb44e,0x93cd,0x6aea,0x3186,0x20e4,0x2986,0x31a7,0x18a3,0x39c7,0x39e7,0x2965,0x4249,0x31a7,0x1082,0x0861,0x20e4,0x1082,0x10a3,0x18e4,0x1083,0x0842,0x18a2,0x194b,0x1a55,0x0299,0x6cbc,0x853c,0x027b,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12bc,0x0adc,0x12dc,0x0adc,0x0adc,0x0adc,0x12dc,0x0adc,0x12dc,0x12dc,0x0adc,0x12dc,0x12fc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x0afd,0x1a13,0x18e5,0x10a3,0x0862,0x0862,0x0862,0x0862,0x0862,0x1082,0x1082,0x0842,0x0841,0x0862,0x1082,0x1082,0x0861,0x1062,0x1883,0x20c3,0x3944,0x51e7,0x4165,0x2903,0x20e3,0x3165,0x6289,0x72a9,0x93ad,0x9bed,0xa42e,0x830a,0x6a68,0x6a68,0x936c,0xd594,0xe616,0xee17,0xee37,0xf638,0xf678,0xf679,0xf679,0xf69a,0xf69a,0xfeba,0xfeba,0xfeba,0xf69a,0xf69a,0xfe99,0xf679,0xf678,0xf657,0xf657,0xf657,0xee16,0xedd5,0xe594,0xdd32,0xbc8f,0x93ec,0x732c,0x41a7,0x18c4,0x2125,0x3187,0x2104,0x2104,0x3186,0x2925,0x39e7,0x31a6,0x18c3,0x0861,0x18c3,0x1083,0x1082,0x2925,0x10a3,0x0862,0x1882,0x196a,0x1a75,0x0298,0x6cbc,
0x853c,0x027b,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x0adc,0x0adc,0x0adc,0x0adc,0x12dc,0x0adc,0x0adc,0x12dc,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12db,0x12db,0x218d,0x1906,0x1084,0x1062,0x0862,0x0862,0x0862,0x0862,0x1082,0x0862,0x0841,0x0842,0x1062,0x1062,0x1082,0x1082,0x1082,0x20a3,0x3965,0x6a89,0x7b2a,0x72ea,0x5a07,0x3124,0x28e4,0x4186,0x7b2b,0x8bac,0x9bed,0x7b0a,0x6a88,0x6a88,0x938c,0xdd54,0xe5b5,0xe5f6,0xee17,0xee37,0xf658,0xf678,0xf679,0xf69a,0xf69a,0xfeba,0xfeba,0xfeba,0xfeba,0xfe9a,0xf69a,0xfe99,0xf679,0xf658,0xf657,0xf657,0xf657,0xf636,0xedd4,0xe594,0xdd52,0xc4b0,0x93cc,0x732c,0x4228,0x18c4,0x10a3,0x18e4,0x2125,0x18c4,0x2105,0x2905,0x2945,0x2125,0x18c3,0x1082,0x10a3,0x10a3,0x1062,0x18c4,0x18c4,0x0862,0x1083,0x2148,0x1a54,0x02b9,0x64bc,0x853c,0x027c,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x0adc,0x0adc,0x0adc,0x0adc,0x12dc,0x0adc,0x12dc,0x12dc,0x0adc,0x0adc,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12fc,0x1a79,0x2148,0x10c4,0x1083,0x1062,0x0862,0x0862,0x1082,0x10a3,0x1082,0x0862,0x0841,0x0862,0x1062,0x1082,0x1082,0x1082,0x1882,0x18a3,0x3145,0x5207,0x730a,0x8bac,0x834b,0x6207,0x4965,0x3945,0x5a48,0x836c,0x72a9,0x5a07,0x6a88,0x8b2a,0xd532,0xdd94,0xe5d5,0xedd5,0xee16,0xee17,0xf658,0xf679,0xf679,0xf69a,0xf6bb,0xfedb,0xfedb,0xf6db,0xfedb,0xfeba,0xfe9a,0xf699,0xf678,0xf678,0xf658,0xf657,0xf657,0xf616,0xedd4,0xe593,0xdd52,0xc4d0,0x9bed,0x6b2b,0x4249,0x2125,0x10a3,0x10a3,0x2104,0x20e4,0x18e4,0x2104,0x3145,0x2945,0x1082,0x1082,0x10a3,0x10a3,0x10a3,0x0862,0x0862,0x0862,0x10a4,0x1929,0x1a53,0x02ba,0x6cbc,
0x853c,0x027c,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x12dc,0x0adc,0x0afc,0x0afc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x0adc,0x0adc,0x12dc,0x12dc,0x12dc,0x12db,0x12fc,0x1a56,0x1926,0x10c4,0x0862,0x1062,0x1082,0x1082,0x1083,0x10a3,0x0862,0x0842,0x0862,0x1061,0x1082,0x1082,0x1082,0x18a2,0x1082,0x2104,0x20e3,0x3965,0x6289,0x838e,0x93ce,0x72c9,0x5a06,0x3965,0x49e6,0x6268,0x5a06,0x6227,0x8b4b,0xccf1,0xdd53,0xe5b4,0xe5d5,0xe5d5,0xedf6,0xee17,0xf658,0xf679,0xf69a,0xf6bb,0xfedc,0xfefc,0xfefc,0xff1c,0xfefc,0xfedb,0xfeba,0xf699,0xf698,0xf678,0xf678,0xf657,0xf637,0xedf5,0xedb4,0xe573,0xd531,0xc4b0,0x93ee,0x6b4c,0x4a49,0x2145,0x18e4,0x10a3,0x1904,0x2105,0x2946,0x2945,0x2904,0x2945,0x1062,0x0841,0x18c3,0x1083,0x18a3,0x0862,0x10a3,0x10a3,0x10a4,0x192a,0x1a54,0x02ba,0x6cbc,0x8d3c,0x027c,0x12fc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x0adc,0x0adc,0x0afc,0x0afc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x0adc,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x1a54,0x2147,0x10a4,0x0882,0x1083,0x1082,0x1082,0x1083,0x0862,0x0842,0x0862,0x1082,0x1082,0x1082,0x1082,0x20c3,0x20e3,0x4a8a,0x4a6a,0x10a2,0x18e3,0x3165,0x6b4d,0x730b,0x834b,0x72c9,0x51c5,0x51e6,0x59e6,0x61e6,0x82ea,0xbcb0,0xcd12,0xdd73,0xe5b4,0xe5d5,0xe5d5,0xe5f5,0xee17,0xf638,0xf659,0xf679,0xf69a,0xfedb,0xf6fc,0xff3d,0xff5e,0xff3d,0xfefc,0xfedb,0xfeba,0xf699,0xf698,0xf678,0xf657,0xee36,0xedf4,0xe5b3,0xdd73,0xd4f1,0xbc90,0x8bee,0x6b4d,0x526a,0x2966,0x2125,0x10c4,0x1904,0x2105,0x2125,0x20e4,0x20e4,0x3165,0x18c3,0x0841,0x18a3,0x1083,0x1082,0x1083,0x10a4,0x08a3,0x1084,0x194b,0x1a33,0x02ba,0x6cbc,
0x8d3c,0x027b,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x0adc,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x0adc,0x12dc,0x12dc,0x0adc,0x0afc,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x1abb,0x2212,0x2148,0x18a4,0x1083,0x10a3,0x1082,0x1082,0x1083,0x0862,0x0862,0x1082,0x1082,0x1082,0x1082,0x20e4,0x3965,0x41e7,0x73d1,0x31c8,0x1862,0x0862,0x4a49,0x4a49,0x62ca,0x836d,0x7b2b,0x6a47,0x59e6,0x59e6,0x7ae9,0xa42e,0xc4b0,0xd512,0xdd74,0xdd94,0xe5b5,0xe5b5,0xe5d5,0xe5d6,0xe5f7,0xe618,0xee38,0xee58,0xee79,0xf69a,0xfedc,0xff3d,0xff5e,0xff3e,0xfefc,0xfebb,0xfe99,0xf679,0xf678,0xf657,0xf615,0xedd4,0xe593,0xdd52,0xccf1,0xb48f,0x8bce,0x632c,0x424a,0x2987,0x1905,0x1905,0x1905,0x2125,0x2104,0x20e4,0x20e4,0x2904,0x18c3,0x0841,0x18c4,0x1083,0x1083,0x1083,0x1083,0x0882,0x10a5,0x218c,0x1a32,0x02da,0x64bc,0x8d3c,0x027b,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x12dc,0x0adc,0x0adc,0x0adc,0x0afc,0x0adc,0x12dc,0x12dc,0x12dc,0x12dc,0x12bb,0x1a9a,0x2214,0x2148,0x10c3,0x10a4,0x10a3,0x1083,0x10a3,0x1082,0x0862,0x1082,0x1082,0x1082,0x10a2,0x20c3,0x41c6,0x5228,0x6248,0x83af,0x3a09,0x0021,0x0841,0x3966,0x2904,0x41c7,0x730c,0x83ce,0x6aa8,0x6226,0x7288,0x8b8c,0xa44e,0xbcb0,0xcd12,0xdd73,0xdd94,0xddb4,0xdd94,0xdd94,0xcd54,0xc514,0xb492,0xb4b2,0xb492,0xb4d2,0xc535,0xd596,0xee39,0xf6bc,0xf71d,0xfefc,0xfedb,0xf69a,0xf679,0xf658,0xf636,0xedf5,0xe5b4,0xe573,0xdd32,0xccd0,0xb44f,0x8bcd,0x630c,0x424a,0x2987,0x2167,0x2967,0x2126,0x18e4,0x2104,0x18e4,0x18a3,0x20c3,0x20e4,0x1082,0x20e4,0x1062,0x1062,0x18a3,0x0862,0x1063,0x1907,0x218b,0x1a54,0x02ba,0x6cdc,
0x8d3c,0x027c,0x12fc,0x12fc,0x12fc,0x12dc,0x12dc,0x12fc,0x12fc,0x12fc,0x0adc,0x0adc,0x0adc,0x0adc,0x0adc,0x0adc,0x0adc,0x0adc,0x12fc,0x0adc,0x12dc,0x12dc,0x0adc,0x12dc,0x0adc,0x0adc,0x0afc,0x0adc,0x12dc,0x12dc,0x12dc,0x12db,0x1aba,0x12db,0x2275,0x2148,0x0882,0x1083,0x10a3,0x18a3,0x10a3,0x1082,0x1082,0x18a3,0x10a2,0x18c3,0x20e3,0x41c6,0x5227,0x6aca,0x72a9,0x832b,0x6acb,0x2904,0x2904,0x3145,0x530d,0x7c11,0x62cb,0x7b6d,0x72c9,0x72a8,0x7aea,0x8bac,0xac4f,0xc4d1,0xd533,0xdd74,0xdd94,0xddb4,0xd573,0xc512,0xb491,0x93ce,0x730b,0x72eb,0x62aa,0x62aa,0x6acb,0x730c,0x93af,0xa431,0xb4d4,0xc535,0xd5b7,0xe639,0xf659,0xf658,0xee36,0xedd4,0xe593,0xdd52,0xd512,0xc4d0,0xac4e,0x8bcd,0x5aaa,0x3a09,0x29a7,0x2987,0x2146,0x2146,0x2125,0x10a3,0x2925,0x18c4,0x20c3,0x18c3,0x1082,0x18c3,0x1083,0x0842,0x10a3,0x1082,0x10a5,0x194a,0x1948,0x1255,0x029a,0x6cbc,0x853c,0x027c,0x12dc,0x0afc,0x0afc,0x12dc,0x12dc,0x12fc,0x0afc,0x0afc,0x0afd,0x0afd,0x0afd,0x0afc,0x0afc,0x0afd,0x0add,0x0afd,0x0afc,0x0afc,0x0adc,0x0adc,0x12dc,0x12dc,0x0adc,0x0adc,0x0adc,0x0adc,0x12dc,0x12dc,0x12dc,0x12db,0x12ba,0x1ada,0x2277,0x1948,0x1083,0x10a3,0x1083,0x18a3,0x1083,0x1062,0x1082,0x1882,0x18c2,0x2904,0x5228,0x62a8,0x6aca,0x7b4b,0x83ad,0x8bae,0x8b8e,0x7b4d,0x834d,0x83d0,0xb599,0x9cd4,0x5a48,0x93cf,0x836c,0x72e9,0x72ea,0x93ad,0xb490,0xcd12,0xd573,0xdd94,0xddb4,0xddb4,0xd553,0xbcb0,0xa42e,0x93ad,0x8b8d,0x7b0b,0x6aca,0x5a89,0x5a48,0x49e8,0x5249,0x5a49,0x72cb,0x72ec,0x7b2d,0x93f0,0xc514,0xe5f7,0xee16,0xe5d4,0xdd73,0xdd52,0xd512,0xc4b0,0xac2e,0x838c,0x5aaa,0x31a7,0x2987,0x29a8,0x2166,0x2125,0x2146,0x0862,0x2125,0x20e4,0x18a3,0x18e3,0x10a2,0x10a3,0x10a3,0x0862,0x10a3,0x1082,0x18e7,0x196a,0x1929,0x1297,0x02b9,0x6cbc,
0x853c,0x027c,0x12fc,0x0afc,0x0afc,0x12dc,0x12dc,0x12fc,0x0afc,0x0afc,0x0afd,0x0afd,0x0afd,0x0afc,0x12fd,0x0afd,0x0add,0x0afd,0x0afc,0x0afc,0x12fc,0x12dc,0x12dc,0x0adc,0x0adc,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x12dc,0x12db,0x12db,0x12db,0x2236,0x1906,0x1083,0x10a3,0x18c4,0x18c4,0x1082,0x1062,0x18c2,0x20c3,0x2904,0x49e8,0x730b,0x838c,0x8b8d,0x8bad,0x93ce,0x9c0f,0x9c30,0xa430,0xb471,0xb4d4,0xac51,0x834c,0x6207,0xac92,0x940e,0x7b2a,0x7b2a,0x9c0e,0xbcf1,0xd574,0xe5b5,0xe5d5,0xe5d5,0xdd94,0xd533,0xbcb0,0xb46f,0xac4f,0xa42f,0xa40e,0x9bcd,0x93ad,0x9bcd,0x93ac,0x93ad,0xa410,0xb472,0xb492,0xac72,0x8b8e,0x7b4d,0xa450,0xdd95,0xe594,0xdd73,0xdd53,0xdd32,0xccf0,0xb46e,0x836b,0x5269,0x31a7,0x2987,0x2987,0x2146,0x2146,0x2125,0x1062,0x18c3,0x18e4,0x18a3,0x18c3,0x1082,0x18a3,0x18a3,0x1062,0x1062,0x0841,0x10e6,0x198b,0x194b,0x0ad9,0x02b9,0x6c9c,0x853c,0x027c,0x12dc,0x12dc,0x12fc,0x12dc,0x12dc,0x12fc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afd,0x0afd,0x0add,0x0add,0x0afd,0x0afd,0x0afd,0x0afd,0x0afd,0x0add,0x0adc,0x12dc,0x12dc,0x12dc,0x0adc,0x0adc,0x12dc,0x12db,0x12db,0x12dc,0x12da,0x2232,0x2127,0x1083,0x10a4,0x2105,0x18c4,0x1062,0x1082,0x18c3,0x28e3,0x49e8,0x628a,0x8bad,0xa42e,0xa40f,0x9c0f,0x93ee,0x8bce,0x9c0f,0xa450,0xac71,0xb4b3,0xa452,0xa451,0x938d,0xb4b2,0x940f,0x7b4b,0x8b6c,0xac90,0xcd73,0xe5d6,0xee37,0xee37,0xedf6,0xddb4,0xcd32,0xc4af,0xbc6f,0xb44e,0xac4e,0xac4f,0xb44f,0xbc90,0xc4d1,0xcd12,0xd533,0xdd74,0xe5b6,0xedd7,0xee39,0xddd7,0xbcb3,0x8b6d,0xa430,0xd574,0xdd73,0xdd53,0xd532,0xd511,0xbc6f,0x834b,0x5228,0x3166,0x2988,0x2987,0x2967,0x31a8,0x2946,0x18a3,0x10a3,0x18c4,0x18a3,0x18c3,0x1082,0x10a3,0x2925,0x1082,0x0862,0x0842,0x10c6,0x21ad,0x116c,0x0afa,0x02b9,0x6cdc,
0x853c,0x027c,0x12dc,0x12fc,0x12dc,0x12dc,0x12dc,0x12dc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afd,0x0afd,0x0afd,0x0add,0x0afd,0x0afd,0x0afd,0x0afd,0x0afd,0x0add,0x12dc,0x12dc,0x0adc,0x12dc,0x12dc,0x12db,0x12dc,0x12db,0x0afc,0x12db,0x1a78,0x2a33,0x1907,0x1083,0x18c4,0x2105,0x18e4,0x1062,0x18a3,0x2904,0x3986,0x5a6a,0x832b,0xac2f,0xb490,0xb491,0xac50,0x9bef,0x9c0f,0xa450,0xa450,0xa430,0xa451,0xac71,0xac51,0xac71,0xac71,0x93ce,0x8b6c,0x9bee,0xc512,0xddd6,0xee78,0xf699,0xf678,0xee17,0xddb4,0xccf1,0xbc6e,0xac0d,0xa3ed,0x9c0d,0x9bee,0x9bce,0xa3ee,0xbc91,0xd533,0xe595,0xe5b5,0xedd6,0xedf7,0xf639,0xf659,0xee18,0xc514,0x93ae,0xc4f2,0xd573,0xd532,0xd532,0xd532,0xbc90,0x836b,0x4a28,0x2925,0x2146,0x2987,0x1905,0x31a7,0x2926,0x10a3,0x10a3,0x18c3,0x18a3,0x18c3,0x1062,0x1082,0x20e4,0x10a2,0x1082,0x0862,0x10c6,0x198c,0x11d0,0x0b1a,0x02b9,0x6cdc,0x853c,0x027c,0x12dc,0x12fc,0x12fc,0x12fd,0x12fd,0x12fc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afd,0x0afd,0x0afd,0x0afd,0x0afd,0x0afd,0x0afd,0x0add,0x0add,0x0adc,0x12fc,0x12dc,0x0adc,0x0adc,0x12dc,0x12db,0x1abb,0x12dc,0x12dc,0x1a9a,0x2258,0x2a13,0x18c4,0x18a3,0x18e5,0x2105,0x18e4,0x1082,0x2905,0x3945,0x5208,0x6aca,0x9bac,0xbc50,0xc4b1,0xc4d2,0xb471,0xac70,0xb491,0xb491,0xac91,0xac72,0xac92,0xa492,0xacd3,0xacb2,0xa470,0x8bad,0x93ad,0xb490,0xd594,0xee58,0xf6fb,0xf6db,0xf679,0xee37,0xddb4,0xc4d0,0xac0d,0x9bab,0x938c,0x832b,0x7aa9,0x72a9,0x72a9,0x832b,0xa3ef,0xccf2,0xe5b5,0xedf6,0xedf7,0xee18,0xf638,0xf638,0xe5d7,0xc4f2,0xb490,0xcd12,0xd552,0xdd52,0xd532,0xc4b0,0x836b,0x41c7,0x20e3,0x10c4,0x2105,0x20e4,0x2105,0x2926,0x1082,0x1082,0x18c3,0x18a3,0x18a3,0x1062,0x10a3,0x18a3,0x1082,0x1082,0x0841,0x10a5,0x196a,0x1a55,0x0b1a,0x02b9,0x6cdc,
0x853c,0x029b,0x12dc,0x12dc,0x12dc,0x0afd,0x0afd,0x0afd,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0adc,0x0adc,0x0adc,0x12dc,0x12dc,0x0afc,0x0afc,0x12dc,0x12db,0x12db,0x12db,0x1a9a,0x2257,0x1a75,0x2a11,0x1927,0x18c3,0x18c4,0x10a3,0x18c3,0x2104,0x2904,0x3966,0x6a8a,0x8b4b,0xabed,0xbc6f,0xc4d1,0xc491,0xbc91,0xc4d2,0xbcd2,0xbcf2,0xbcf3,0xb4b2,0xacb2,0xbd14,0xacd2,0xa470,0x93ee,0x8b8c,0xa3ed,0xc512,0xe616,0xf6db,0xfefc,0xfeba,0xf699,0xee57,0xe5b4,0xc48e,0xa3cb,0x8b4b,0x7aca,0x6228,0x5228,0x3185,0x2924,0x41a7,0x732f,0x9412,0xa3f0,0xd534,0xedd5,0xedf6,0xedf7,0xee18,0xe5f7,0xd595,0xc512,0xcd12,0xd552,0xdd52,0xd532,0xc4b0,0x834a,0x3145,0x1083,0x18c4,0x2145,0x2104,0x18a4,0x1905,0x1061,0x1082,0x18c3,0x18c3,0x2104,0x1082,0x18c3,0x18a3,0x1083,0x0862,0x0842,0x1083,0x196d,0x12fa,0x0b1a,0x02ba,0x6cdc,0x853c,0x029b,0x12dc,0x12dc,0x12dc,0x0afd,0x0afd,0x0afd,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x12fc,0x12dc,0x12dc,0x12dc,0x12bc,0x12dc,0x12dc,0x12bb,0x1abb,0x12db,0x1abb,0x1a78,0x2278,0x2277,0x21ce,0x2105,0x18a3,0x10a3,0x18c4,0x2104,0x2924,0x3145,0x49e8,0x7aeb,0x9b8c,0xb3ee,0xc490,0xc490,0xc471,0xc4b2,0xccd2,0xcd13,0xcd33,0xbcd2,0xbcd3,0xbd13,0xbcf2,0xac70,0x9c2e,0x8bad,0x93ac,0xb48f,0xddb4,0xf679,0xff1c,0xfedb,0xf699,0xf699,0xee77,0xddb4,0xc48e,0xa3ab,0x82a9,0x726a,0x5aac,0x5b0f,0x2105,0x0041,0x2105,0x52ab,0x39c7,0x5aab,0x834d,0xc4b1,0xe5b4,0xe5d6,0xedd6,0xe5f6,0xddb5,0xd553,0xd532,0xd552,0xdd52,0xd532,0xc4b0,0x7b09,0x2925,0x1062,0x1083,0x2946,0x18e4,0x18a4,0x18e4,0x0861,0x10a3,0x18c3,0x20c3,0x18c3,0x0861,0x10a3,0x18c3,0x18a3,0x0862,0x0861,0x1083,0x1255,0x0b1a,0x0af9,0x02ba,0x64dc,
0x853c,0x027b,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x12fc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12db,0x1abb,0x1adc,0x1adb,0x2298,0x2276,0x2234,0x21cd,0x29ab,0x2126,0x10a3,0x10a3,0x2104,0x2945,0x3124,0x4186,0x6acb,0x8b0b,0xabad,0xbc0e,0xc44f,0xc470,0xccd2,0xccf2,0xd513,0xd513,0xc4f2,0xc513,0xc514,0xbcf3,0xac90,0x9c0e,0x93cd,0x8bac,0xa40e,0xc511,0xe616,0xf6da,0xfedb,0xf6ba,0xf6b9,0xf699,0xee58,0xdd93,0xc4d0,0x9b8c,0x8b0b,0x82cb,0x8c75,0x7c54,0x1882,0x0841,0x18e3,0x2125,0x2946,0x41e9,0x5269,0x72cb,0xbcb0,0xdd74,0xe5b5,0xe5b5,0xdd94,0xd573,0xd553,0xdd52,0xdd52,0xd511,0xbc8f,0x6aa9,0x18a3,0x0842,0x0862,0x18c3,0x18a3,0x1083,0x18e4,0x0862,0x10a3,0x18a3,0x18a3,0x18a3,0x0861,0x10a3,0x18c4,0x18c3,0x0862,0x0862,0x1108,0x12fa,0x0afa,0x0afa,0x02ba,0x64bc,0x853c,0x027b,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12fc,0x0afc,0x0afc,0x0afd,0x0afd,0x0afd,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x0afc,0x12fc,0x12dc,0x0adc,0x12dc,0x12dc,0x0afc,0x0afc,0x12dc,0x1ab9,0x2234,0x2a11,0x2253,0x21f1,0x2a34,0x2a31,0x2147,0x18a3,0x18c3,0x3166,0x3145,0x3125,0x5208,0x72aa,0x934b,0xabcd,0xbc0e,0xbc0f,0xccb1,0xd4f2,0xd513,0xd4f3,0xccd2,0xcd13,0xcd33,0xc513,0xb491,0x9c2f,0x93cd,0x8b8c,0x93cc,0xb46f,0xdd73,0xf678,0xfeda,0xfeba,0xfeba,0xf6da,0xf6da,0xee7a,0xddd6,0xcd34,0xac91,0x9bad,0x934c,0xa472,0x9cf6,0x31e9,0x0862,0x20e4,0x18e4,0x6bb2,0x8cb6,0x2966,0x5228,0x8b0b,0xccd1,0xdd53,0xdd73,0xd574,0xd574,0xdd73,0xdd73,0xd552,0xccf1,0xb46e,0x5247,0x1062,0x0842,0x1062,0x1083,0x1062,0x1062,0x18a3,0x1062,0x10a3,0x18a3,0x1082,0x18a3,0x1061,0x1082,0x18c4,0x18a3,0x0882,0x0841,0x116d,0x131b,0x0af9,0x0b19,0x02ba,0x64dc,
0x853c,0x027b,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x12dc,0x0afc,0x0b1d,0x0b1d,0x131d,0x131d,0x131d,0x131d,0x131d,0x0afd,0x0b1d,0x0afd,0x0afc,0x0afc,0x12dc,0x12dc,0x12dc,0x12bb,0x12ba,0x1a98,0x2234,0x1a12,0x2255,0x2299,0x2a78,0x2297,0x2297,0x2a50,0x2147,0x18c4,0x2925,0x3186,0x3166,0x41a7,0x6289,0x7aca,0xa38c,0xb3ee,0xbc0e,0xc44f,0xd4d1,0xd4f3,0xd513,0xccd2,0xd513,0xd533,0xcd12,0xbcd1,0xa44f,0x8bcd,0x8b8c,0x8b8c,0xa40d,0xccf0,0xedf5,0xf6da,0xfeb9,0xf699,0xfeb9,0xfefb,0xfefb,0xf6db,0xe67a,0xd5b7,0xbd15,0xb492,0xa431,0x9baf,0xa431,0x9431,0x5249,0x528b,0x7c54,0xbe3d,0xa539,0x628a,0x49a6,0x82eb,0xb42e,0xcd11,0xd553,0xdd73,0xdd94,0xdd94,0xdd73,0xd532,0xccd1,0xa40d,0x39a5,0x0842,0x0841,0x0842,0x1082,0x1062,0x0862,0x1082,0x1062,0x18a3,0x18c3,0x18a3,0x20e4,0x1062,0x1082,0x18c4,0x18a3,0x1082,0x0841,0x19f1,0x0b1a,0x0afa,0x0b19,0x02ba,0x64bc,0x8d3c,0x029c,0x12fc,0x12dc,0x12dc,0x12dc,0x12dc,0x12fc,0x0afd,0x131d,0x131d,0x133d,0x133d,0x133d,0x131d,0x133d,0x0b3d,0x133d,0x0b1d,0x131d,0x0afc,0x0afc,0x12dc,0x12da,0x1ab9,0x1a98,0x1ad9,0x12fc,0x1afc,0x22da,0x2279,0x2276,0x22b7,0x22b7,0x2a0d,0x2105,0x2124,0x2104,0x39a7,0x39a7,0x5228,0x6a89,0x932b,0xa38c,0xabcd,0xbc0f,0xcc70,0xd4b1,0xd4f2,0xd4f3,0xd533,0xdd33,0xd533,0xc4f2,0xb470,0x9bee,0x838c,0x8b6b,0x9bcd,0xbc6f,0xdd73,0xf678,0xfefb,0xf6b9,0xf698,0xf6b9,0xfefb,0xff1c,0xf71c,0xeedb,0xde19,0xcd77,0xbcf5,0xb493,0xb493,0xbcd4,0xb472,0xb492,0xc556,0xd5b7,0xc4f3,0xabef,0x8b2c,0x7b0b,0x9b6c,0xb44e,0xccf1,0xdd53,0xe594,0xe594,0xe594,0xdd74,0xd532,0xccb1,0x8b8c,0x2104,0x0821,0x0821,0x0841,0x10a3,0x1083,0x1062,0x1083,0x0842,0x1082,0x1083,0x1082,0x2104,0x1082,0x1083,0x18e4,0x1083,0x1082,0x10a4,0x1294,0x0b1a,0x0af9,0x0b1a,0x02d9,0x64dc,
0x853c,0x029c,0x12fd,0x12fc,0x12fc,0x12dc,0x12dc,0x12fc,0x131d,0x131d,0x131d,0x133d,0x133d,0x133d,0x133d,0x133d,0x133d,0x133d,0x0b1d,0x131d,0x12dc,0x12dc,0x12dc,0x12db,0x12dc,0x12fc,0x12fc,0x1ada,0x2a78,0x22b9,0x22b8,0x2ad8,0x22b6,0x2a52,0x320b,0x2946,0x2104,0x2925,0x422a,0x41c8,0x5228,0x6a89,0x932c,0xa36c,0xabcd,0xc42f,0xcc70,0xd4b1,0xd4d2,0xd513,0xdd54,0xdd34,0xd513,0xc4d1,0xa42f,0x8b6c,0x834b,0x938c,0xac2e,0xccf0,0xee16,0xfedb,0xfeda,0xfe98,0xf698,0xfeb9,0xfefb,0xff1c,0xff1c,0xf6fc,0xee7a,0xddf8,0xcd77,0xc515,0xb4b4,0xb4b4,0xc535,0xd5b8,0xcd55,0xd556,0xcd14,0xbc92,0xa3ef,0xa3ef,0xac0f,0xc4b1,0xd532,0xe594,0xe594,0xe594,0xe594,0xdd73,0xd532,0xbcb0,0x6aca,0x10a3,0x0841,0x0821,0x0842,0x18a3,0x18a3,0x1062,0x1083,0x0841,0x1082,0x18c4,0x1082,0x18c3,0x1062,0x1083,0x20e4,0x18a3,0x10a2,0x10e6,0x12b7,0x0b1a,0x0b1a,0x0b1a,0x02d9,0x6cdc,0x853c,0x029c,0x12fd,0x12fc,0x12fd,0x12fd,0x0afd,0x12fd,0x0afd,0x0b1d,0x131d,0x133d,0x133d,0x133e,0x131d,0x131d,0x131d,0x131d,0x131d,0x131d,0x0afc,0x0b1d,0x0b1d,0x0afd,0x12dc,0x12db,0x1aba,0x2298,0x1ad8,0x22d9,0x22d8,0x2ab4,0x2a52,0x2a2f,0x2a0a,0x2946,0x18e3,0x3187,0x424a,0x4a08,0x5a07,0x7aca,0x934c,0xa36c,0xabcd,0xbc2f,0xcc70,0xd4b1,0xd4f2,0xdd33,0xdd53,0xdd54,0xcd13,0xb490,0x93ad,0x832b,0x8b6b,0xa40d,0xc4af,0xdd93,0xf678,0xfeda,0xfeb9,0xfe98,0xf6b8,0xfed9,0xfeda,0xff1c,0xff3d,0xff3d,0xf6bc,0xe639,0xddd8,0xd576,0xc515,0xc4f5,0xcd14,0xd555,0xddb6,0xe596,0xdd96,0xdd75,0xd575,0xdd95,0xdd75,0xdd74,0xe594,0xe5b4,0xe5b4,0xe5b4,0xdd94,0xdd53,0xccf2,0xac6f,0x5249,0x1083,0x0041,0x0841,0x0841,0x1082,0x1083,0x1062,0x1083,0x0842,0x18a3,0x18c3,0x18c3,0x10a3,0x1062,0x10a3,0x18a3,0x1083,0x0882,0x10e6,0x12d9,0x0b1a,0x0afa,0x0b1a,0x02ba,0x6cdc,
0x8d3c,0x029c,0x12fd,0x12fc,0x12fd,0x12fd,0x0afd,0x0afd,0x0afc,0x0b1d,0x131d,0x131d,0x133d,0x133d,0x131d,0x131d,0x12fd,0x131d,0x131d,0x131d,0x131d,0x131d,0x131d,0x12fd,0x12fc,0x12bb,0x2299,0x22b9,0x22d9,0x22d6,0x2a52,0x2295,0x2a72,0x3271,0x324e,0x29a9,0x2104,0x31a8,0x422a,0x4a08,0x5a28,0x7aea,0x8b2b,0x9b8c,0xabed,0xbc2e,0xc44f,0xcc90,0xd4d2,0xdd33,0xdd53,0xd533,0xc4b1,0x9bee,0x8b6c,0x8b4b,0x93cc,0xb46f,0xd532,0xee16,0xfeb9,0xfed9,0xf698,0xf698,0xf6b8,0xfeb9,0xfefa,0xff1c,0xff3d,0xff1d,0xfedc,0xf67a,0xe618,0xddb7,0xd597,0xd577,0xd576,0xd575,0xdd96,0xe5b7,0xedf8,0xee39,0xee59,0xf658,0xf638,0xee16,0xee16,0xee15,0xe5f5,0xe5b4,0xdd74,0xd532,0xc4d1,0x8bcd,0x31a6,0x1083,0x0841,0x0841,0x0861,0x1082,0x1062,0x1083,0x1083,0x1062,0x18a3,0x10a2,0x20e4,0x18a3,0x1082,0x1083,0x1083,0x1083,0x0862,0x1128,0x12fa,0x0b1a,0x0afa,0x0b19,0x02ba,0x6cdc,0x8d3c,0x029c,0x12fd,0x12fc,0x12fc,0x0afd,0x0afd,0x12fd,0x0afc,0x0b1d,0x131d,0x133d,0x131d,0x131d,0x131d,0x131d,0x131d,0x131d,0x131d,0x131d,0x131d,0x131d,0x131d,0x131c,0x1ada,0x1ad9,0x1ada,0x1afa,0x22d8,0x2a73,0x2296,0x2a74,0x2a51,0x2a53,0x2a72,0x2a2e,0x2125,0x3187,0x4a4a,0x5228,0x5a48,0x7aca,0x8b2b,0x9b6c,0xa3cd,0xb42e,0xc44e,0xcc8f,0xd4d1,0xdd33,0xdd33,0xc4d1,0xa3ed,0x8b6c,0x8b6c,0x8b8c,0xa40e,0xc4d1,0xe594,0xf678,0xfeda,0xf6d9,0xf698,0xfe98,0xf6b8,0xfeb9,0xfeda,0xfefc,0xff1d,0xff1d,0xfefc,0xf6bb,0xee5a,0xe5f8,0xddd7,0xddd7,0xddb7,0xddb7,0xe5d7,0xe618,0xee59,0xf67a,0xfe9a,0xfe9a,0xf679,0xf658,0xee57,0xee36,0xe615,0xe5b4,0xdd73,0xcd12,0xb490,0x732c,0x2125,0x0862,0x0841,0x0841,0x0841,0x1082,0x1062,0x1883,0x1062,0x1083,0x18a3,0x1082,0x18c3,0x18a3,0x10a3,0x1083,0x1083,0x1082,0x1082,0x198c,0x0b1a,0x0afa,0x0b1a,0x0b1a,0x02ba,0x6cdc,
0x853c,0x029c,0x12fc,0x12dc,0x12fc,0x0afc,0x0afc,0x12fd,0x131d,0x131d,0x131d,0x133d,0x131d,0x131d,0x131d,0x131d,0x131d,0x133d,0x133d,0x131d,0x131d,0x131d,0x131d,0x1adb,0x1adb,0x1afb,0x1afb,0x22b7,0x2a72,0x2ab7,0x3296,0x2a71,0x22b5,0x22d9,0x22d9,0x2272,0x2104,0x31a6,0x526b,0x4a08,0x6269,0x72ca,0x8b0b,0x936c,0xa3cd,0xabed,0xc44e,0xccb0,0xd4f1,0xd532,0xc4d1,0xa3cd,0x82e9,0x830a,0x8b6c,0x93ad,0xb46f,0xcd32,0xedf6,0xf6da,0xfefb,0xf6b9,0xf698,0xf698,0xf698,0xf698,0xfeb9,0xfefb,0xfefc,0xff1c,0xfefc,0xf6db,0xf69b,0xee39,0xe5f7,0xe5d7,0xe5d7,0xe5f8,0xedf8,0xee39,0xf65a,0xf69a,0xfe9a,0xfe9a,0xfe79,0xf678,0xf657,0xee36,0xe5f5,0xdd93,0xd532,0xc4f1,0xa42f,0x5228,0x10a3,0x0862,0x0841,0x0841,0x0861,0x1083,0x1083,0x18a3,0x1042,0x1062,0x1882,0x18a3,0x2104,0x18a3,0x18a3,0x1083,0x1083,0x1083,0x10a3,0x1211,0x0b1b,0x0b19,0x0b1a,0x0b19,0x02da,0x6cdc,0x8d3c,0x029c,0x12fc,0x12fc,0x12fc,0x12fd,0x12fd,0x131d,0x131d,0x133d,0x1b3d,0x133d,0x133d,0x133d,0x133d,0x131d,0x131d,0x133d,0x135d,0x133d,0x133d,0x1b1d,0x1afc,0x1afb,0x1afc,0x1afb,0x22d8,0x22b6,0x2ab8,0x2a93,0x2a91,0x22f9,0x1b5d,0x22f9,0x22fb,0x222f,0x2944,0x4229,0x422a,0x5229,0x5a69,0x72a9,0x830b,0x934c,0xa3ac,0xb3ed,0xc44f,0xccb0,0xd4f1,0xccf1,0xb44e,0x8aea,0x7267,0x7ae9,0x8b2a,0x9bac,0xb490,0xd573,0xee16,0xf6db,0xf6fc,0xf6b9,0xf678,0xf657,0xf657,0xf657,0xf698,0xfeda,0xfefc,0xfefc,0xfedc,0xfedb,0xfe9b,0xf65a,0xee18,0xedf8,0xedf8,0xedf8,0xee18,0xf639,0xf659,0xf67a,0xf69a,0xf69a,0xf679,0xf658,0xf657,0xee16,0xe5d5,0xd573,0xcd12,0xbcb1,0x8b8d,0x2945,0x0862,0x0862,0x0841,0x0841,0x0861,0x1082,0x10a3,0x18a3,0x1062,0x1883,0x1882,0x1882,0x2104,0x18a3,0x2105,0x18a3,0x18a3,0x1083,0x10c5,0x1254,0x0b1a,0x0b1a,0x0b19,0x0b19,0x02da,0x6cdc,
0x853c,0x029c,0x12fc,0x12fc,0x12fc,0x12fd,0x12fd,0x131d,0x133d,0x1b5d,0x1b3d,0x1b3d,0x1b5e,0x133e,0x133d,0x133d,0x133d,0x133d,0x133d,0x133d,0x1b3d,0x1b1c,0x1b1c,0x22fc,0x1b3b,0x22d9,0x22d9,0x2ab6,0x2a91,0x2ab5,0x1b3c,0x135e,0x1afb,0x1afa,0x2ad8,0x29eb,0x39e8,0x39c8,0x4a4a,0x5249,0x5a48,0x72a9,0x830b,0x934c,0x9bac,0xb40e,0xc46f,0xccb0,0xccd0,0xc48f,0xabed,0x82c9,0x6227,0x6227,0x6207,0x8b2a,0xb46f,0xd532,0xe5d5,0xee57,0xf698,0xf697,0xf677,0xf677,0xf657,0xf636,0xf657,0xf6b9,0xf6ba,0xfedb,0xfedb,0xfebb,0xfe9a,0xfe7a,0xfe59,0xf639,0xf618,0xf618,0xf638,0xf658,0xfe59,0xfe79,0xf699,0xf699,0xf679,0xf658,0xf637,0xedf6,0xddb4,0xd532,0xc4d2,0xac71,0x5249,0x10a2,0x1082,0x0842,0x0841,0x0841,0x1062,0x18a3,0x1083,0x1083,0x1062,0x18a3,0x18a3,0x1883,0x18c3,0x18a3,0x20e4,0x18a3,0x1083,0x10a3,0x196a,0x12d7,0x0b1a,0x0b1a,0x0b1a,0x0b19,0x02da,0x6cdc,0x853c,0x029c,0x12dd,0x12fd,0x12fd,0x12fd,0x12fd,0x131d,0x133d,0x1b5d,0x1b5d,0x1b3d,0x1b5d,0x133d,0x133d,0x133d,0x133e,0x135d,0x133d,0x1b3d,0x1b3d,0x1b1c,0x1b3c,0x1b1d,0x22f9,0x22b7,0x2ab5,0x2a95,0x22d9,0x235d,0x1b5e,0x1b1d,0x1b1c,0x2319,0x2ab5,0x29eb,0x3187,0x2988,0x526b,0x5249,0x6269,0x72ca,0x830b,0x936c,0x9bcd,0xb42e,0xc48f,0xc4d0,0xc4b0,0xbc6f,0xa3ed,0x832a,0x6227,0x4144,0x3904,0x59e6,0x9bcc,0xc4b0,0xd532,0xe594,0xedf5,0xf635,0xf677,0xf698,0xf698,0xee16,0xee16,0xf658,0xf699,0xf69a,0xfeba,0xfe9a,0xfe9a,0xfe7a,0xfe59,0xf639,0xf639,0xf638,0xf638,0xf658,0xfe59,0xfe79,0xfe79,0xf679,0xf658,0xf658,0xee16,0xe5d5,0xdd73,0xccf1,0xb491,0x836d,0x2945,0x10a2,0x0862,0x0842,0x0841,0x0841,0x1062,0x18a3,0x1883,0x1082,0x1083,0x1083,0x18c4,0x18a3,0x18a3,0x18a2,0x20e3,0x20c4,0x18c3,0x18c4,0x19cf,0x12f9,0x0b1a,0x0b1a,0x0b1a,0x0b19,0x02da,0x6cdc,
0x853c,0x02bc,0x12fd,0x12fd,0x12fc,0x12fd,0x131d,0x131d,0x133d,0x133d,0x133d,0x131d,0x133d,0x133d,0x133d,0x133d,0x1b3d,0x1b3d,0x133d,0x133d,0x131d,0x1b1d,0x1b3c,0x22fb,0x22d9,0x2a96,0x2ab8,0x22fc,0x1b5d,0x1b5d,0x1b3d,0x1b3c,0x2319,0x231a,0x2ad6,0x3209,0x2988,0x31a8,0x528b,0x5249,0x6269,0x72ea,0x832b,0x938c,0x9bcd,0xac2e,0xbc6f,0xc4af,0xbc8f,0xb46e,0xa40d,0x8b6b,0x6a88,0x49a5,0x4125,0x4124,0x6a68,0xa3cd,0xb46e,0xc4b0,0xc4d0,0xd532,0xee16,0xf657,0xf657,0xee16,0xedf5,0xee16,0xf658,0xf679,0xf679,0xf679,0xf679,0xf659,0xfe59,0xf639,0xf659,0xf658,0xf658,0xf658,0xfe59,0xfe59,0xfe59,0xfe58,0xf638,0xf637,0xedf5,0xe5b4,0xd532,0xc4b1,0x940f,0x4a27,0x2104,0x1062,0x0842,0x0842,0x0841,0x0841,0x1083,0x18a3,0x1883,0x1083,0x10a3,0x10a3,0x18a3,0x18a3,0x18a3,0x18a3,0x18c3,0x20e4,0x18c2,0x1906,0x1a53,0x0b1a,0x0b1a,0x0b1a,0x0b1a,0x0b3a,0x02da,0x6cfc,0x855c,0x029c,0x12fc,0x12fc,0x12fd,0x12fd,0x12fd,0x12fd,0x131d,0x131d,0x133d,0x133d,0x133d,0x133d,0x133d,0x1b1d,0x131e,0x131d,0x131d,0x131d,0x131d,0x133c,0x131b,0x1afa,0x2a97,0x22b9,0x1b1b,0x1b5d,0x1b5d,0x1b5d,0x1b3d,0x1b1a,0x1afa,0x233b,0x2a4e,0x29ea,0x2146,0x39c8,0x528c,0x526a,0x6289,0x72ea,0x832b,0x938c,0x9bed,0xac4e,0xb46e,0xb46e,0xb44e,0xac2d,0x9bec,0x8b8b,0x7b0a,0x6a68,0x6227,0x6227,0x7268,0x8329,0x9bcc,0xac2e,0xa3cc,0x82c9,0xb40e,0xe5b4,0xedf5,0xedd5,0xedd5,0xedf5,0xf616,0xf658,0xf638,0xf638,0xf638,0xf638,0xfe39,0xfe39,0xfe39,0xfe38,0xfe38,0xfe38,0xfe38,0xfe58,0xfe58,0xf638,0xf617,0xf5f6,0xe5d4,0xdd53,0xccd1,0xac4f,0x62eb,0x3125,0x1062,0x0841,0x0842,0x0842,0x0821,0x0842,0x1083,0x10a3,0x1083,0x18a3,0x1083,0x18a3,0x20e4,0x18c4,0x20e4,0x20c3,0x20e4,0x2104,0x10a3,0x18e6,0x1a96,0x0b1a,0x0b1a,0x0b19,0x0b1a,0x12f9,0x02da,0x6cfc,
0x855c,0x029c,0x12fc,0x12fc,0x12fd,0x12fd,0x12fd,0x12fd,0x131d,0x131d,0x131d,0x131d,0x131c,0x133c,0x1b1d,0x22d8,0x22f9,0x12fd,0x12fd,0x12fc,0x12fc,0x131c,0x131c,0x22b7,0x22ba,0x1afc,0x1b3c,0x1b5d,0x1b3d,0x1b3c,0x231b,0x22fb,0x231b,0x32f6,0x2188,0x2147,0x2925,0x31c8,0x4a8b,0x5269,0x6289,0x7b0b,0x8b4c,0x9bad,0xa3ed,0xac2e,0xac2e,0xa40d,0xa40d,0xa40d,0x93ec,0x93ac,0x8bab,0x8b8b,0x93ac,0xa40d,0xac2e,0x9bec,0xac2e,0xcd32,0xd553,0xa3ac,0x8aa8,0xc46f,0xdd32,0xe594,0xedd5,0xedd5,0xedf6,0xf616,0xf617,0xf617,0xf617,0xf617,0xf618,0xf638,0xfe38,0xfe38,0xfe38,0xf638,0xf638,0xf638,0xf637,0xf637,0xf617,0xf5f5,0xe5b4,0xd512,0xbc90,0x7b6d,0x39a6,0x20c3,0x1882,0x0862,0x1062,0x0862,0x0821,0x1062,0x1083,0x18a3,0x10a3,0x18c3,0x1883,0x18a3,0x18c4,0x18e4,0x18c3,0x2104,0x20e3,0x20e3,0x18c4,0x196b,0x1a98,0x0b19,0x0b19,0x0b19,0x0b1a,0x131a,0x02da,0x6cfc,0x855c,0x029c,0x12fc,0x12fd,0x12fd,0x12fd,0x12fd,0x12fd,0x131d,0x131d,0x131c,0x131c,0x131c,0x12fd,0x1b1c,0x42f1,0x7b50,0x5b56,0x22fb,0x0afd,0x1b1c,0x1afc,0x22ba,0x229a,0x12fc,0x131c,0x131d,0x1b1c,0x1b1c,0x22fb,0x22da,0x22bb,0x32f7,0x21ee,0x1924,0x20e4,0x2104,0x31a7,0x4a6b,0x524a,0x6aaa,0x832c,0x938d,0x9bed,0xa40e,0xa40d,0x9bcc,0x938b,0x93ac,0x93cc,0x93cc,0x93cc,0x9c0d,0xac4e,0xc4d0,0xd593,0xd594,0xc512,0xcd32,0xe5d5,0xe5f5,0xdd53,0xbc4f,0xc46f,0xdd33,0xedf7,0xf637,0xedf6,0xedd5,0xf5f6,0xf5f6,0xf5f6,0xf5d6,0xf5f6,0xf5f7,0xf618,0xfe38,0xfe38,0xf638,0xf618,0xf618,0xf618,0xf617,0xf617,0xf616,0xedd5,0xdd53,0xccd2,0x93ee,0x62c9,0x5a68,0x41e7,0x2904,0x1062,0x0862,0x0842,0x0821,0x1082,0x1083,0x1083,0x1083,0x18a3,0x18a3,0x20c4,0x18c3,0x2104,0x18c3,0x20e4,0x20c3,0x18e3,0x2125,0x19ce,0x12b8,0x131a,0x0b19,0x0b1a,0x131a,0x0b3a,0x02fa,0x6cfd,
0x8d5c,0x02bc,0x12fd,0x12fd,0x12fd,0x12fd,0x12fd,0x0afd,0x12fc,0x1afc,0x12fc,0x12fc,0x131c,0x231b,0x22d8,0x4ad2,0x6af0,0x8371,0x7352,0x331a,0x12dc,0x22db,0x1ada,0x12fc,0x131c,0x131d,0x131c,0x1b1c,0x22fb,0x1afa,0x1afb,0x2b19,0x2a51,0x1946,0x1925,0x18a4,0x20e4,0x2945,0x4a0a,0x524a,0x6aaa,0x834b,0x9bcd,0xa42e,0xac4e,0x9bcc,0x6a88,0x59e6,0x7ac9,0x7b0a,0x8aea,0x932b,0xa38c,0xbc0e,0xdd32,0xedf6,0xe5d5,0xd553,0xdd94,0xee16,0xee36,0xee16,0xee16,0xee37,0xf679,0xfe79,0xf678,0xee16,0xedd5,0xedd5,0xedd5,0xf5b5,0xf5b5,0xf5d6,0xf5d6,0xf5f7,0xf618,0xf618,0xf618,0xf617,0xf617,0xf5f7,0xf5f7,0xf5f7,0xedd5,0xe594,0xd512,0xb46f,0x8b8d,0x832a,0x6289,0x41a6,0x28e4,0x1883,0x1062,0x0842,0x0842,0x1883,0x1883,0x1083,0x1083,0x20e4,0x20e3,0x20e3,0x18a3,0x2124,0x20e4,0x20c3,0x18a3,0x18e3,0x2125,0x220e,0x0ad8,0x131a,0x0b1a,0x0b1a,0x133a,0x133a,0x031b,0x651d,0x8d5c,0x0abc,0x1b1d,0x12fd,0x12fc,0x12fc,0x12fd,0x333a,0x5bb8,0x6bd7,0x63b9,0x53b9,0x3b57,0x2a2e,0x19ab,0x31ea,0x8c54,0xa4b5,0x7b6f,0x8b90,0x5b78,0x231b,0x231b,0x2b3a,0x2b3a,0x1b1c,0x12fc,0x1b1c,0x1afc,0x1afb,0x2af7,0x2a0d,0x2127,0x18c3,0x10a4,0x10a3,0x2125,0x18c3,0x39c8,0x5269,0x6aaa,0x834b,0x9bed,0xac4e,0xac4f,0x9bcd,0x51e6,0x1062,0x3904,0x6165,0x79c6,0x8227,0x9268,0xa2a9,0xcbcd,0xed73,0xe5d4,0xe5b4,0xedf5,0xee36,0xee36,0xee56,0xf677,0xf678,0xf679,0xf679,0xf658,0xee16,0xedd5,0xedb4,0xedb4,0xedb4,0xed94,0xedb5,0xf5d5,0xf5f7,0xf618,0xfe18,0xf618,0xf5f7,0xf5f7,0xf5f7,0xf5d6,0xedb5,0xe594,0xdd33,0xc491,0xa44f,0xb4b1,0x93ae,0x6b4d,0x5228,0x3924,0x3104,0x18a3,0x0821,0x0842,0x1883,0x1883,0x18a3,0x1083,0x2925,0x2104,0x18c3,0x20c4,0x2105,0x2105,0x18a3,0x20c3,0x20e4,0x1927,0x2231,0x12f8,0x0b3a,0x0b3a,0x0b5a,0x0b5a,0x0b5a,0x033b,0x6d1d,
0x8d5c,0x0abc,0x1b1d,0x12fd,0x12fd,0x12fd,0x32f9,0x9434,0xacd6,0xacf7,0xacd6,0x9495,0x52cd,0x2988,0x2168,0x2967,0xcdf9,0xe65a,0xc577,0xacd5,0xa4b5,0x8c75,0x8454,0x9454,0xa495,0x9474,0x4378,0x1ab9,0x1a75,0x322f,0x31a8,0x18e4,0x18c3,0x0882,0x1083,0x0882,0x2925,0x1062,0x2945,0x5249,0x6aa9,0x8b4b,0x9bed,0xa44f,0xac4f,0x9bed,0x6a89,0x4125,0x30e3,0x2082,0x28a2,0x5945,0x79e7,0x9227,0xa228,0xcb8c,0xdcf2,0xe533,0xf5f7,0xf637,0xf636,0xf636,0xf657,0xf657,0xf658,0xf678,0xf657,0xf616,0xedd4,0xedb4,0xed94,0xed94,0xed94,0xed94,0xf5b5,0xf5d6,0xf5f7,0xfdf7,0xfdf7,0xf5d7,0xf5d6,0xf5d6,0xedb5,0xed74,0xdd53,0xc4f1,0x9c0f,0xac8f,0xbcb0,0xa3ee,0x7b0b,0x6a69,0x51c7,0x3924,0x1041,0x0021,0x1082,0x18a2,0x18a3,0x18a3,0x1082,0x2925,0x2946,0x20c3,0x20e4,0x2946,0x2125,0x18c3,0x18a2,0x18e3,0x2188,0x1a52,0x1339,0x0b7a,0x0b7a,0x0b5a,0x0b7a,0x0b7a,0x033a,0x6d1d,0x8d5c,0x0adc,0x1b1e,0x1b1d,0x4b58,0x63b7,0x73f3,0x9c34,0xa474,0xa495,0xa495,0x9c33,0x632f,0x7390,0x73b1,0x5aee,0xad16,0xd5fa,0xbd37,0xad16,0xacf6,0xacf5,0xb536,0xbd56,0xb515,0xbcf3,0xacd4,0x52ac,0x2145,0x31a7,0x10a3,0x18c4,0x0882,0x0882,0x0883,0x1083,0x2946,0x1062,0x18c3,0x5228,0x6a89,0x832b,0x9bed,0xa42e,0xa42e,0x93cd,0x7ac9,0x61c7,0x8229,0x7a08,0x3903,0x1882,0x3124,0x61a6,0x79e7,0xa248,0xbaea,0xc32a,0xdc4f,0xedd6,0xee57,0xf656,0xf657,0xf637,0xf637,0xf657,0xf637,0xedf6,0xedd4,0xedb4,0xedb4,0xed94,0xed94,0xed74,0xed94,0xf595,0xf5b6,0xf5d6,0xf5d6,0xf5b6,0xedb5,0xed94,0xe574,0xdd33,0xccf2,0x9c2f,0x39a6,0x41a5,0x6a67,0x7aea,0x72aa,0x5a07,0x3104,0x0841,0x0020,0x0821,0x1082,0x1882,0x18c3,0x1082,0x1082,0x2925,0x3187,0x2925,0x2925,0x2125,0x2967,0x18a3,0x18c4,0x1926,0x29aa,0x1a73,0x1359,0x0b7a,0x0b7a,0x0b7b,0x139b,0x0b7a,0x035b,0x6d1d,
0x8d5c,0x0add,0x1b1a,0x73d5,0xb4d5,0xbd17,0xb4f7,0xb4f7,0xbd17,0xbd38,0xc558,0xc517,0x42b0,0x3a6e,0x52ed,0x6b6f,0x8c11,0xa493,0xbd16,0xb557,0xb516,0xbd36,0xcd77,0xcdb8,0xd5d8,0xcd97,0xc535,0xacb2,0x62cb,0x18c3,0x10a3,0x1083,0x0861,0x0862,0x0862,0x10a3,0x18e4,0x0862,0x1082,0x41a6,0x6a69,0x830a,0x93cc,0x9c0e,0x9c0e,0x93ac,0x72e9,0x61e7,0x7a28,0xb2aa,0xc2eb,0x8a28,0x5145,0x4186,0x51e7,0x7208,0x9248,0xa268,0xbac9,0xd40f,0xedb6,0xee36,0xee57,0xf637,0xf637,0xf637,0xf636,0xf615,0xedf5,0xedd4,0xedb4,0xed94,0xed94,0xe573,0xed74,0xed95,0xed95,0xf5b5,0xedb5,0xed95,0xed74,0xe573,0xdd33,0xccd2,0xac70,0x41e7,0x0000,0x0000,0x0000,0x1061,0x1082,0x0841,0x0020,0x0021,0x0041,0x0841,0x1082,0x1082,0x18a3,0x18a3,0x10a3,0x3187,0x2966,0x2905,0x2925,0x3186,0x2966,0x2104,0x1926,0x2168,0x21aa,0x1ab5,0x133a,0x0b7a,0x0b7b,0x0b7b,0x0b7b,0x0b7b,0x033a,0x651d,0x855c,0x02bc,0x4af3,0xa474,0xbd38,0xbd38,0xbd18,0xbd17,0xbd17,0xbd37,0xcd78,0xb517,0x32d2,0x2ad3,0x2a8f,0x2a6e,0x2a4d,0x326c,0x5b0f,0x9cb5,0xc577,0xc577,0xcd77,0xd5d9,0xe65b,0xe63a,0xddf8,0xbd34,0xa492,0x62cb,0x2125,0x0862,0x0861,0x1082,0x1082,0x20e4,0x10a3,0x1062,0x0862,0x2925,0x6248,0x7aea,0x8b8c,0x9bed,0x9bed,0x93ac,0x7b2a,0x6a48,0x79e7,0xa269,0xc2cb,0xd30b,0xc2ea,0x9a69,0x69e7,0x51c7,0x6aaa,0x7acc,0x9269,0xaa89,0xcb8c,0xe553,0xee16,0xee16,0xee16,0xee16,0xf616,0xf615,0xedf5,0xedd4,0xedb4,0xe594,0xe573,0xe573,0xe554,0xed74,0xed74,0xed74,0xe574,0xe553,0xdd53,0xdd32,0xccf2,0xb491,0x62aa,0x0040,0x0800,0x0021,0x0821,0x0020,0x0020,0x0021,0x0041,0x0841,0x0041,0x0821,0x1082,0x1082,0x20c4,0x18c4,0x10a3,0x3a09,0x2987,0x20c4,0x2905,0x3187,0x2146,0x2126,0x2167,0x2169,0x29a9,0x1ab6,0x133a,0x0b7a,0x0b7b,0x0b5b,0x0b5b,0x0b5b,0x031a,0x6cfd,
0x855c,0x2275,0x6b2f,0x9413,0x9c34,0xac95,0xacb5,0xa494,0x9c74,0x83b1,0x628b,0x5b0f,0x3314,0x3b76,0x4397,0x3b34,0x3b34,0x4395,0x4bb6,0x8c97,0xcd98,0xcd98,0xcd98,0xddd8,0xe63a,0xe65a,0xe639,0xddd7,0xd576,0xb4f4,0x8bef,0x39a6,0x0841,0x0862,0x10a3,0x2104,0x18a3,0x0862,0x0862,0x10a2,0x51e7,0x72c9,0x8b6b,0x93cd,0x9bed,0x93cd,0x8b6b,0x7aa8,0x79e7,0x9248,0xbaca,0xcaeb,0xd34c,0xdb8d,0xdb6c,0xb32b,0x7a8a,0x6aab,0x51e8,0x6186,0x89c6,0xbb0a,0xdd12,0xe5b4,0xe5d5,0xe5d5,0xedd5,0xedf5,0xedf4,0xedd4,0xe5b3,0xe593,0xe553,0xdd33,0xdd33,0xe533,0xe533,0xe533,0xdd13,0xdd12,0xd512,0xccd1,0xb4b0,0x7b8d,0x10a2,0x0000,0x0821,0x0821,0x0821,0x0841,0x0841,0x0841,0x0841,0x0020,0x0021,0x0841,0x1062,0x1083,0x18a3,0x20e4,0x18c4,0x39e8,0x31a7,0x20e4,0x2905,0x2945,0x2146,0x2986,0x218a,0x2189,0x2967,0x1ab5,0x137a,0x0b5a,0x0b7b,0x0b5b,0x0b5b,0x135b,0x031a,0x6cfd,0x9537,0x4a8e,0x6b4e,0x83b1,0xb495,0xcd58,0xcd78,0xc558,0xb516,0x8bd1,0x41c7,0x320c,0x3b96,0x4bf9,0x7d3d,0x859e,0x7d9e,0x751e,0x5c3a,0x9477,0xc557,0xc577,0xcd97,0xcd97,0xd596,0xddd7,0xddf8,0xe5f8,0xe5f8,0xd596,0xc514,0xacb1,0x6aeb,0x18c3,0x0862,0x10a3,0x18a3,0x0842,0x0862,0x0841,0x4165,0x7288,0x8b2b,0x9bcc,0xa3ed,0x9bed,0x93ac,0x8b0a,0x8288,0x8a27,0xaa89,0xc2eb,0xcb2b,0xd38c,0xe40f,0xec70,0xdbce,0xbb0b,0x9269,0x5965,0x5124,0x7144,0x8a68,0xb40e,0xcd12,0xdd74,0xe594,0xe5b4,0xedd4,0xe5b4,0xe593,0xe573,0xdd52,0xdd32,0xdd12,0xd512,0xd4f2,0xd4f2,0xd4f1,0xccd1,0xc4b1,0xb490,0x8bee,0x2104,0x0020,0x0821,0x0821,0x0821,0x0821,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0862,0x1062,0x18a3,0x18e4,0x2104,0x31c8,0x31c8,0x2105,0x3146,0x2945,0x2966,0x29eb,0x29ec,0x198a,0x29a8,0x2294,0x135b,0x0b5a,0x135a,0x0b5a,0x0b5a,0x0b5a,0x02d9,0x6cdc,
0xa535,0x52ad,0x7b90,0x9c33,0xbcf6,0xd59a,0xdddb,0xd5db,0xbd58,0x8bf2,0x49e9,0x328f,0x43b7,0x5c7d,0xb69f,0xe7df,0xc73f,0x857e,0x5c39,0xb539,0xde1a,0xddf9,0xde1a,0xde19,0xddf8,0xddb7,0xddd8,0xddd8,0xddd8,0xddd7,0xdd96,0xcd54,0xcd34,0x9c50,0x39a6,0x1082,0x1062,0x1083,0x1083,0x0041,0x20c2,0x6a47,0x830a,0x9bac,0xa3ed,0xa40d,0x9bed,0x936b,0x8b09,0x8aa8,0x9a68,0xb2a9,0xc2ca,0xcaca,0xd3ce,0xe555,0xe4f3,0xe3ef,0xe3ee,0xdbae,0xc30b,0xa269,0x79a6,0x6165,0x9b4b,0xd511,0xdd73,0xe593,0xe5b3,0xe593,0xe593,0xe573,0xdd53,0xd532,0xd512,0xd4f2,0xccd1,0xccb1,0xc4b1,0xc4b0,0xb490,0x9c2f,0x39c6,0x0020,0x0821,0x0841,0x0841,0x0821,0x0821,0x0841,0x0841,0x0841,0x0021,0x0021,0x0841,0x0862,0x0842,0x1082,0x18c3,0x18c3,0x2105,0x39e8,0x31a7,0x2104,0x2945,0x2946,0x29a8,0x2252,0x2a2e,0x21ee,0x2a0c,0x2294,0x133a,0x0b5a,0x133a,0x133a,0x0b3a,0x0b3a,0x02d9,0x6cdc,0xb5b8,0x83b2,0xa433,0xb4b5,0xc537,0xd59a,0xd5ba,0xcd79,0xacf7,0x7b6f,0x4a09,0x4333,0x541b,0xa61e,0xf7ff,0xffff,0xdf9f,0x7d5e,0x647a,0xcdda,0xee5b,0xe63a,0xe63a,0xe65b,0xee5a,0xee5a,0xe639,0xe5f8,0xddd8,0xddd8,0xddb7,0xd596,0xd575,0xd554,0xbd13,0x72eb,0x1082,0x1083,0x18c3,0x0061,0x0861,0x51c6,0x82a9,0x936b,0xa3ed,0xa42e,0xa42d,0xa3ed,0x9b8b,0x9b4b,0x930a,0x9ac8,0xaa89,0xbaa9,0xcb0b,0xd36d,0xdc10,0xdbcf,0xdbce,0xdbae,0xdb8d,0xdbad,0xcbef,0xabee,0xa3ad,0xc4d0,0xdd52,0xe593,0xe5b3,0xe5b3,0xe593,0xe593,0xdd73,0xdd32,0xd512,0xcd12,0xccf1,0xc4d1,0xbcb0,0xb490,0x9c2f,0x4a27,0x0041,0x0041,0x0841,0x0841,0x0841,0x0821,0x0821,0x0841,0x0021,0x0841,0x0841,0x0020,0x0862,0x20e4,0x0862,0x1082,0x18a3,0x18c4,0x2125,0x39c8,0x31a8,0x2105,0x2125,0x2946,0x21ca,0x1a95,0x226e,0x2230,0x2250,0x2293,0x1339,0x0b5a,0x133a,0x131a,0x0b1a,0x1319,0x02b9,0x6cdc,
0xce39,0xa474,0xacb5,0xbcd6,0xbd16,0xbd16,0xbcf6,0xacb5,0x8bd1,0x5a2a,0x39c8,0x4375,0xae5e,0xffff,0xffff,0xffff,0xffff,0xa63e,0x749a,0xd61b,0xee5b,0xe63a,0xe63a,0xe65b,0xee9c,0xee9b,0xee7b,0xee5a,0xe639,0xe619,0xe5f8,0xddd7,0xddb6,0xd575,0xd554,0xcd53,0x8bad,0x3186,0x18a3,0x0841,0x0862,0x3924,0x7248,0x8b4a,0xa3ed,0xac4e,0xb44e,0xac4e,0xac0d,0xabed,0xa3ac,0x9b6a,0x9ae9,0xa2a9,0xb2c9,0xbaa9,0xc2eb,0xc30b,0xcb2c,0xcb8d,0xcbee,0xd44e,0xe4f1,0xdd94,0xcd52,0xd511,0xdd52,0xe593,0xe5b4,0xe5d4,0xe5b4,0xe593,0xdd73,0xdd52,0xd532,0xcd11,0xc4f1,0xbcd1,0xb4b0,0xa44f,0x5268,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0821,0x0821,0x0021,0x0020,0x0821,0x0821,0x0821,0x1082,0x18e4,0x0862,0x10a3,0x18c3,0x18c4,0x3186,0x39c8,0x39c8,0x2105,0x2105,0x31a8,0x224f,0x12d7,0x2a8f,0x2a50,0x2250,0x2293,0x1319,0x0b3a,0x131a,0x0b1a,0x0b1a,0x12f9,0x02b9,0x6cdc,0xde7a,0xb4b5,0xb4d4,0xb4b4,0xac74,0x9c11,0x93d0,0x8bd0,0x93f1,0x93d1,0x6b0e,0x7c35,0xa57b,0xb65d,0xcefe,0xe77f,0xf7ff,0xd73e,0x8cdb,0xe63c,0xe63a,0xddf9,0xddf9,0xde1a,0xe63a,0xe63a,0xee5a,0xee3a,0xee5a,0xee3a,0xe639,0xe619,0xe5d8,0xddb7,0xd595,0xd554,0xd554,0xb4b2,0x4a28,0x1041,0x1062,0x1882,0x61e7,0x8b0a,0xa3ed,0xbc6f,0xbc8f,0xbcb0,0xc48f,0xbc6f,0xbc4e,0xb40d,0xabcc,0xa3ab,0xab8b,0xab6b,0xb38b,0xc3cc,0xc42e,0xd4cf,0xdd51,0xddb3,0xe5d4,0xe5d4,0xddb3,0xdd72,0xdd72,0xe593,0xe5b4,0xe5b4,0xe5b4,0xdd93,0xdd52,0xd532,0xd532,0xcd11,0xc4f1,0xb4b1,0x9c6f,0x5268,0x1062,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0821,0x0821,0x0841,0x0841,0x0841,0x0821,0x0821,0x1082,0x18c3,0x1083,0x18a3,0x18c4,0x2105,0x31a7,0x2966,0x31a8,0x2946,0x3146,0x31ea,0x22b4,0x1ab8,0x2270,0x2271,0x2292,0x2294,0x1af9,0x0b1a,0x12fa,0x0af9,0x131a,0x1319,0x02b9,0x6cdc,
0xde7a,0xb4d5,0xb494,0xa432,0x8bb0,0x836f,0x93d1,0xa452,0xc4f6,0xdd9a,0xddda,0xddd9,0xd5db,0xce3d,0xc63d,0xc65d,0xc65d,0xcebd,0xa55a,0xd599,0xd598,0xd5b8,0xddd9,0xde1a,0xe63a,0xe639,0xe63a,0xe63a,0xe639,0xe639,0xe639,0xee39,0xe619,0xe5f8,0xddd7,0xddb6,0xdd76,0xd575,0xbd13,0x72eb,0x20e3,0x1062,0x4965,0x8ae9,0xabed,0xbc90,0xc4d0,0xccf1,0xccf1,0xd511,0xd4f1,0xccf1,0xccd0,0xccd0,0xccd0,0xc4cf,0xccd0,0xd511,0xd572,0xdd93,0xe5d3,0xe5d4,0xedf4,0xedf4,0xe5b4,0xe593,0xdd72,0xdd72,0xdd92,0xdd92,0xdd73,0xdd52,0xd552,0xd531,0xcd11,0xbcf1,0xb4b0,0x942f,0x4a28,0x0882,0x0862,0x0842,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0821,0x0841,0x0841,0x0841,0x0841,0x0020,0x10a3,0x18e4,0x10a3,0x18a3,0x20e4,0x2966,0x2966,0x2946,0x31c8,0x2966,0x2967,0x2a0d,0x1ab7,0x12b7,0x2292,0x1a73,0x1ab4,0x1a95,0x1ad8,0x0b1a,0x0af9,0x12fa,0x12fa,0x12fa,0x02b9,0x6cbc,0xd65a,0xa433,0x9bf2,0x8bf2,0x9413,0xa4b5,0xb4d5,0xc4d5,0xd537,0xe61b,0xf67d,0xee7d,0xf69e,0xf6be,0xf6df,0xf71e,0xeeff,0xe6be,0xe65b,0xddda,0xddfa,0xe65b,0xee5c,0xee7c,0xee7b,0xee7b,0xee5b,0xe63a,0xe61a,0xe61a,0xe63a,0xe639,0xe63a,0xe63a,0xe619,0xe618,0xddf7,0xddb6,0xd595,0xcd54,0x9c0e,0x41a6,0x20a3,0x7268,0xa3cd,0xc48f,0xccd1,0xd511,0xdd32,0xdd53,0xdd53,0xe573,0xe573,0xe593,0xe593,0xe593,0xe5b3,0xe5b4,0xedd4,0xedf4,0xedf4,0xedf4,0xedf3,0xe5f3,0xe5b3,0xe593,0xdd52,0xd531,0xd531,0xd551,0xd531,0xcd11,0xc511,0xbcd1,0xb4b0,0xa490,0x7bcd,0x31a5,0x0862,0x0862,0x0862,0x0862,0x0841,0x0841,0x0841,0x0841,0x0841,0x0021,0x0841,0x0861,0x0841,0x0841,0x0841,0x0041,0x18c3,0x18c4,0x18a3,0x18c3,0x2104,0x2945,0x39e8,0x31a7,0x2986,0x2105,0x2189,0x2250,0x1ab8,0x1ab7,0x2293,0x1a94,0x1ad5,0x1ab7,0x1ad7,0x12fa,0x12fa,0x12fa,0x12da,0x12f9,0x02b9,0x6cbc,
0xc5b8,0x93b1,0xa474,0xac94,0xc517,0xcd78,0xcd58,0xd578,0xddb9,0xe63b,0xee7d,0xf69e,0xf6df,0xf6ff,0xfeff,0xff1f,0xf71f,0xf6ff,0xf6de,0xf69e,0xf69d,0xee9d,0xf6be,0xf6be,0xf69d,0xee7c,0xee7c,0xee5b,0xee5b,0xee5b,0xee3b,0xe65a,0xee5a,0xe65b,0xe65a,0xee5a,0xe639,0xe618,0xddf7,0xddb6,0xd594,0xbcd1,0x72eb,0x51c6,0x932a,0xbc2e,0xcc90,0xd4f1,0xdd32,0xdd53,0xe573,0xe594,0xe594,0xedb5,0xedd5,0xedd5,0xedf5,0xee15,0xedf5,0xedf4,0xedf4,0xe5d3,0xe5d2,0xe5b2,0xe5b2,0xdd92,0xd531,0xd510,0xccf0,0xc4ef,0xbcd0,0xb4af,0xac8f,0xa46f,0x8bee,0x5a89,0x18e3,0x0021,0x0862,0x0862,0x0862,0x0862,0x0842,0x0841,0x0021,0x0841,0x0841,0x0841,0x0862,0x0841,0x0021,0x0841,0x0841,0x0821,0x10c3,0x10a3,0x20e4,0x1083,0x20e4,0x2104,0x4a4a,0x2966,0x31a7,0x2105,0x29cc,0x22b4,0x1ab8,0x1ab7,0x1ab5,0x1ab6,0x1ad5,0x1ad8,0x22f6,0x12d9,0x12fa,0x12fa,0x12da,0x12d9,0x0299,0x6cbc,0xc5f8,0xa453,0xbcd5,0xcd37,0xd599,0xddb9,0xd599,0xddb9,0xe5fa,0xe61a,0xe61b,0xee3c,0xf67d,0xf6be,0xf6df,0xf6ff,0xf71f,0xf6ff,0xfeff,0xf6ff,0xf6df,0xf6df,0xf71f,0xff3f,0xf71f,0xf6fe,0xf6de,0xf6dd,0xeebd,0xee9c,0xee7c,0xee7c,0xee7c,0xee9b,0xee9b,0xee7b,0xee7b,0xee5a,0xee39,0xe638,0xe617,0xddd6,0xd594,0xa42f,0x8b0a,0xabac,0xbc4e,0xcc90,0xdcf1,0xdd32,0xe552,0xe573,0xe594,0xedb5,0xedf5,0xf5f5,0xf616,0xf615,0xedf5,0xedd4,0xe5d3,0xe5b2,0xe5b2,0xe592,0xdd91,0xd551,0xcd0f,0xc4af,0xbc8e,0xb46e,0xa44e,0x9c0e,0x8bad,0x62c9,0x2944,0x0841,0x0821,0x0842,0x0862,0x0862,0x0862,0x0862,0x0841,0x0021,0x0841,0x0841,0x0841,0x0862,0x0862,0x0841,0x0020,0x0841,0x0821,0x0021,0x10a4,0x10a3,0x20e4,0x18e4,0x2104,0x2105,0x39a7,0x2966,0x31c8,0x2146,0x220e,0x1ab6,0x1ad8,0x12b8,0x1ad7,0x1ab7,0x1ab5,0x12f9,0x1ad7,0x12d8,0x0afa,0x12da,0x12da,0x12f9,0x0299,0x6cbc,
0xd659,0xb493,0xc515,0xd598,0xdd99,0xd599,0xd558,0xcd37,0xc516,0xcd37,0xd578,0xddba,0xe5fb,0xe63c,0xee7d,0xf67d,0xf69d,0xf6be,0xf6df,0xf6ff,0xf6df,0xf6ff,0xff1f,0xff5f,0xff5f,0xf75f,0xf73f,0xf73f,0xf71f,0xf6fe,0xf6dd,0xf6dd,0xf6dd,0xf6bd,0xf6bd,0xf6bc,0xf69c,0xf69c,0xf69c,0xee7b,0xee7a,0xee39,0xe618,0xddd6,0xcd33,0xb42e,0xabed,0xbc2e,0xccb0,0xdd11,0xdd32,0xdd53,0xe573,0xedb4,0xedf5,0xf615,0xf615,0xee15,0xedf4,0xe5b3,0xe5b2,0xdd92,0xdd72,0xd571,0xcd30,0xc4ef,0xbcae,0xac4d,0x9c0d,0x93cd,0x732a,0x4a27,0x2924,0x0861,0x0020,0x0041,0x0841,0x0842,0x0862,0x0862,0x0862,0x0862,0x0842,0x0841,0x0021,0x0841,0x0841,0x0862,0x0841,0x0841,0x0021,0x0841,0x0862,0x0841,0x10c4,0x10a3,0x18c4,0x2105,0x2125,0x2104,0x3187,0x2966,0x31c9,0x2168,0x1a72,0x12d9,0x1ab7,0x12b7,0x12d8,0x1ab7,0x12b7,0x0b1a,0x1318,0x12d9,0x0afa,0x12da,0x12fa,0x12f9,0x029a,0x6cbc,0xde59,0xc4b4,0xcd16,0xc517,0xc4f7,0xcd59,0xc559,0xb539,0xacf8,0xacf7,0xbd58,0xbd58,0xc538,0xc4f6,0xc4d6,0xd558,0xddb9,0xe5fa,0xee7d,0xf6be,0xfedf,0xf6ff,0xf71f,0xff3f,0xf73f,0xf75f,0xf75f,0xf75f,0xff1f,0xff1f,0xff1f,0xff1f,0xf71f,0xfefe,0xfefe,0xfefe,0xf6de,0xf6de,0xf6dd,0xf6dd,0xf6bc,0xf67b,0xee5a,0xe638,0xe5f6,0xddb4,0xccf1,0xb42e,0xb40d,0xc48f,0xd4f0,0xdd31,0xdd32,0xe572,0xedb3,0xedd4,0xedd4,0xe5d3,0xe593,0xdd72,0xd570,0xd550,0xcd10,0xc4ef,0xb4ae,0xac4d,0x93cc,0x836b,0x62a9,0x3165,0x18a2,0x0841,0x0021,0x0841,0x0821,0x0821,0x0841,0x0842,0x0842,0x0862,0x0862,0x0862,0x0862,0x0041,0x0821,0x0841,0x0862,0x0842,0x0821,0x0821,0x0841,0x0862,0x0842,0x0841,0x18c4,0x10a3,0x2104,0x2104,0x2987,0x2126,0x31a7,0x29a7,0x31ea,0x2a0b,0x1294,0x0ad9,0x1ad8,0x1ab7,0x12da,0x12d7,0x1a97,0x0b1a,0x0b39,0x1ad9,0x0af9,0x0af9,0x0af9,0x12fa,0x029a,0x6cbc,
0xd619,0xb434,0xb4b6,0xb519,0xb59c,0xc5fe,0xce5f,0xd6df,0xdedf,0xdf5f,0xdf3f,0xe71f,0xdefe,0xd69c,0xbdb9,0x8bd1,0xa412,0xd537,0xddba,0xee1c,0xee5d,0xee7d,0xeebe,0xf6df,0xf6ff,0xf71f,0xf73f,0xf73f,0xff3f,0xff3f,0xff5f,0xff5f,0xff5f,0xff5f,0xff5f,0xff3f,0xff3f,0xff1f,0xff1f,0xff1e,0xfefd,0xf6dd,0xee9b,0xee7a,0xee59,0xe617,0xe5f6,0xdd94,0xc4f1,0xbc6e,0xbc2d,0xc46e,0xccaf,0xd4f0,0xdd51,0xe571,0xdd51,0xdd31,0xd510,0xd4ef,0xccce,0xc4ae,0xb44d,0x9bcc,0x834b,0x72ea,0x6288,0x49e6,0x10a2,0x0020,0x0821,0x0841,0x0841,0x0841,0x0841,0x0821,0x0841,0x0842,0x0842,0x0862,0x0882,0x0882,0x0042,0x0041,0x0842,0x0841,0x0862,0x0862,0x0821,0x0821,0x0821,0x0021,0x0841,0x10a3,0x10a3,0x18e4,0x2986,0x2145,0x31e9,0x31c9,0x3a08,0x322b,0x324c,0x2250,0x12d7,0x0af9,0x12d9,0x12d9,0x12d9,0x12d8,0x1ab7,0x0afa,0x0b39,0x1ad9,0x0af9,0x0b19,0x0b19,0x131a,0x02ba,0x6cdc,0xc5d9,0x9457,0xad7c,0xbdde,0xbe1e,0xbe1f,0xce7f,0xd69f,0xdeff,0xe73f,0xe75f,0xe75f,0xe75f,0xe77f,0xf7bf,0xdefe,0xa4d6,0x93d2,0xb494,0xd558,0xdd99,0xddba,0xe61b,0xe65d,0xee9e,0xeedf,0xf6ff,0xf71f,0xf73f,0xf75f,0xff7f,0xff5f,0xff7f,0xff7f,0xff9f,0xff7f,0xff7f,0xff5f,0xff5f,0xff3f,0xff1e,0xf6fe,0xf6dd,0xf6dc,0xee9b,0xee7a,0xe658,0xe617,0xe5f6,0xddb4,0xcd31,0xc48f,0xbc2d,0xbc0c,0xc42d,0xcc6e,0xc46e,0xbc4d,0xb40c,0xa3ec,0x938b,0x7b2a,0x6aa9,0x5a68,0x5a47,0x5a68,0x5268,0x2103,0x0041,0x0841,0x0822,0x0841,0x0841,0x0841,0x0842,0x0842,0x0842,0x0841,0x0841,0x0862,0x10a3,0x0882,0x0862,0x0862,0x0841,0x0841,0x0862,0x0862,0x0821,0x0821,0x0041,0x0841,0x10c4,0x2167,0x0883,0x1925,0x29a7,0x29a8,0x322a,0x3a6c,0x39e8,0x2a2c,0x2a2b,0x1ab4,0x12f9,0x0af9,0x0ad9,0x12f9,0x12d9,0x12f9,0x12b8,0x12fa,0x0b19,0x12d9,0x12f9,0x0b1a,0x0b19,0x131a,0x02ba,0x6cdc,
0xc63b,0x94fb,0xa55d,0xad9e,0xbdff,0xbe3e,0xc65f,0xd69f,0xdeff,0xdf1f,0xe73f,0xe73f,0xe73f,0xe71f,0xe75f,0xefbf,0xefbf,0xc65c,0x9433,0x93b1,0xbc95,0xcd38,0xd599,0xdd99,0xddfb,0xe65d,0xee9f,0xeedf,0xef3f,0xf75f,0xf77f,0xf75f,0xff7f,0xff9f,0xffbf,0xffbf,0xff9f,0xff9f,0xff7f,0xff5f,0xff3f,0xff1f,0xf71e,0xf6fd,0xf6fc,0xf6db,0xf6ba,0xee99,0xe657,0xe616,0xddd5,0xddb3,0xd552,0xc4af,0xb3cc,0x82c8,0x6247,0x5a27,0x5a07,0x5207,0x5207,0x4a27,0x5247,0x5a88,0x5aa8,0x5247,0x52aa,0x18e4,0x0841,0x0842,0x0842,0x0841,0x0841,0x0841,0x0841,0x0842,0x0842,0x0841,0x0842,0x0862,0x0882,0x0862,0x0862,0x0862,0x0841,0x0861,0x0882,0x0842,0x0821,0x0841,0x0021,0x10c4,0x2a2b,0x1926,0x1882,0x2125,0x2967,0x31ea,0x32ef,0x4b30,0x41c8,0x326e,0x2a2c,0x12b7,0x12f9,0x0afa,0x12d9,0x12d9,0x12f9,0x0af9,0x12b9,0x0b19,0x0b1a,0x0b1a,0x12d9,0x12fa,0x0b1a,0x12f9,0x02ba,0x6cbc,0xbe1b,0x849a,0x9d5c,0xa59e,0xadde,0xbe3e,0xc65f,0xd69f,0xdeff,0xe73f,0xe73f,0xe73f,0xe73f,0xe75f,0xe75f,0xef7f,0xef7f,0xef9f,0xdf3f,0x9cb6,0x7350,0x8bd2,0xa474,0xbcf6,0xd558,0xddba,0xde1c,0xe67d,0xeedf,0xf71f,0xf73f,0xf77f,0xff7f,0xff9f,0xff9f,0xff9f,0xff9f,0xff9f,0xff7f,0xff5f,0xff5f,0xff3f,0xff3f,0xff3e,0xff3d,0xf71d,0xf6fc,0xf6da,0xeeba,0xee99,0xee58,0xe637,0xe616,0xe5f5,0xddb3,0xb4af,0x7b2b,0x5a27,0x5207,0x5248,0x5288,0x6288,0x6ac9,0x6ae9,0x6ac9,0x3144,0x4229,0x18e4,0x0841,0x0862,0x0842,0x0841,0x0841,0x0841,0x0842,0x0842,0x0842,0x0842,0x0842,0x0882,0x0882,0x0862,0x0862,0x0882,0x0862,0x08a3,0x10a3,0x0821,0x0841,0x0041,0x0842,0x220c,0x224c,0x1062,0x1082,0x1925,0x31e8,0x428d,0x5436,0x430f,0x39e8,0x3b10,0x2a8f,0x12b7,0x0af9,0x0afa,0x12f9,0x12f9,0x12f9,0x12d9,0x12d9,0x0b19,0x131a,0x131a,0x12d9,0x131a,0x0b1a,0x12f9,0x02ba,0x6cbc,
0xb5fb,0x7459,0x9d5d,0xa5de,0xadbe,0xbe3e,0xc67e,0xce9e,0xdeff,0xdf3f,0xe73f,0xe73f,0xef7f,0xe75f,0xe73f,0xe75f,0xef5f,0xef7f,0xef9f,0xe75f,0x9d39,0x6350,0x6b2f,0x8bf2,0xb4d6,0xcd38,0xd579,0xddfb,0xe65d,0xeebe,0xeeff,0xf73f,0xf73f,0xf77f,0xf77f,0xf77f,0xff7f,0xff7f,0xff5f,0xff5f,0xf73f,0xf73f,0xf73f,0xff5f,0xff5e,0xff3e,0xff1d,0xf71c,0xf6fc,0xf6fb,0xf6db,0xf6da,0xf6b9,0xf6b9,0xee57,0xee35,0xddd4,0xc4f0,0x93cc,0x7b2a,0x6b0a,0x7309,0x7329,0x7329,0x6aa9,0x18c3,0x4249,0x2145,0x10a3,0x0883,0x0841,0x0841,0x0841,0x0841,0x0842,0x0842,0x0842,0x0842,0x0862,0x0882,0x0862,0x0862,0x0862,0x0882,0x10c4,0x1905,0x1082,0x0021,0x0862,0x0861,0x2168,0x32f0,0x21a8,0x0841,0x1082,0x2125,0x31e8,0x5bb4,0x6497,0x3ace,0x3a4b,0x4373,0x4b93,0x12b7,0x0b1a,0x131a,0x0af9,0x0afa,0x12fa,0x12fa,0x12f9,0x0b1a,0x131a,0x0b1a,0x0af9,0x131a,0x131a,0x12f9,0x02ba,0x6cbc,0xbe1b,0x7c9a,0x951c,0xa5be,0xb61f,0xb5fe,0xc67e,0xd6ff,0xd6df,0xd6ff,0xe75f,0xe75f,0xe75f,0xe73f,0xef7f,0xef9f,0xef9f,0xef7f,0xef9f,0xefbf,0xe75f,0x9d1b,0x6b92,0x7392,0x83d2,0xa475,0xbcf7,0xcd58,0xd5ba,0xde1c,0xe67d,0xeebe,0xeeff,0xef1f,0xf73f,0xf75f,0xf75f,0xf75f,0xf75f,0xff3f,0xf73f,0xf73f,0xf73f,0xff3f,0xff3e,0xff3e,0xff1d,0xf71c,0xf71c,0xf71c,0xff1c,0xff1c,0xff3b,0xff1b,0xf6fa,0xf6b9,0xee77,0xee36,0xddb3,0xc531,0xa46e,0x8bcb,0x7b6a,0x7b49,0x6288,0x1882,0x4aaa,0x2165,0x2166,0x10c4,0x0842,0x0841,0x0041,0x0841,0x0842,0x1062,0x0862,0x0862,0x0862,0x0882,0x0862,0x0862,0x0862,0x08a3,0x1926,0x10e5,0x0820,0x0861,0x0882,0x1105,0x3352,0x32f0,0x1925,0x0841,0x10a3,0x2146,0x29e9,0x7cf9,0x74d6,0x4b50,0x42ad,0x6457,0x53f5,0x1af8,0x031a,0x0b1a,0x0b19,0x0b1a,0x12f9,0x12fa,0x0af9,0x0b1a,0x0b1a,0x0b1a,0x0b19,0x0af9,0x12fa,0x12f9,0x02b9,0x6cdc,
0xbe1b,0x7c9a,0x951c,0xa5be,0xb61f,0xc67f,0xce9f,0xcebf,0xd6de,0xdeff,0xe73f,0xe73f,0xef7f,0xef7f,0xef9f,0xef7f,0xefbf,0xef9f,0xef7f,0xef7f,0xef9f,0xdf1f,0x9d1a,0x7bf6,0x73b4,0x7bb1,0x8c12,0xacb5,0xc517,0xc558,0xd5ba,0xde1c,0xe65d,0xe69e,0xeedf,0xeeff,0xef1f,0xf73f,0xf73f,0xf73f,0xf73f,0xf71f,0xf71f,0xff3f,0xff3e,0xf73d,0xf71d,0xf71c,0xf6fb,0xf6fb,0xff1c,0xff1c,0xff3c,0xff3c,0xff3c,0xff1b,0xf6fa,0xf6b9,0xee77,0xe636,0xddd3,0xcd51,0xb48f,0xa40d,0x72c8,0x20a2,0x4aec,0x1925,0x3229,0x2166,0x0882,0x0862,0x0841,0x0841,0x0862,0x1062,0x0862,0x0862,0x1082,0x0882,0x0882,0x0882,0x0862,0x10c4,0x1946,0x10e4,0x0821,0x10a2,0x10c3,0x3b11,0x5436,0x3af0,0x10c4,0x0862,0x18e4,0x2146,0x42ef,0x9ddc,0x6c95,0x4b30,0x42ee,0x855a,0x6cb8,0x3bf8,0x0b3a,0x0afa,0x0b19,0x0b19,0x0af9,0x12fa,0x12f9,0x0b1a,0x0b1a,0x0b1a,0x0afa,0x0af9,0x0af9,0x12f9,0x02b9,0x6cdc,0xbe1b,0x7c79,0x9d5d,0xa5be,0xb61f,0xc69f,0xc69e,0xcebf,0xdf3f,0xdeff,0xdeff,0xe75f,0xf7bf,0xe75f,0xe75f,0xe75f,0xef9f,0xef9f,0xef5f,0xe75f,0xe75f,0xef9f,0xdeff,0xa57c,0x8437,0x7bd4,0x7371,0x7b90,0x9433,0xacd6,0xbd38,0xc579,0xcdba,0xd5db,0xde3c,0xe65d,0xe6be,0xeeff,0xf71f,0xf71f,0xf71f,0xf71f,0xf71e,0xf71e,0xf73e,0xf71d,0xf6fd,0xf6fc,0xf6db,0xf6db,0xf6da,0xf6fb,0xff1b,0xff1b,0xff1c,0xff3c,0xff5c,0xff1b,0xf6da,0xf698,0xee57,0xee16,0xe5d4,0xd592,0xbcf0,0x836c,0x6b6c,0x29c7,0x3acd,0x2a09,0x18a4,0x10a3,0x1081,0x0882,0x1082,0x1082,0x1062,0x0862,0x1083,0x08a2,0x08a3,0x0883,0x0883,0x10a4,0x2146,0x08a3,0x0861,0x1904,0x2a2c,0x4c37,0x5bf3,0x4b92,0x10c3,0x1082,0x2104,0x2986,0x4b51,0x853b,0x6c76,0x4b51,0x5bd3,0x95db,0x8d7a,0x6d19,0x3c5b,0x02da,0x0afa,0x0b1a,0x0b19,0x0af9,0x12d9,0x12f9,0x0b39,0x131a,0x12fa,0x0afa,0x12fa,0x12f9,0x02ba,0x6cbc,
0xbe1b,0x84ba,0x953c,0xadde,0xb5fe,0xbe5f,0xcebf,0xd6ff,0xd6df,0xdeff,0xe71e,0xe75f,0xef7f,0xef7f,0xe75f,0xef7f,0xe73f,0xef9f,0xef9f,0xef7f,0xef7f,0xefbf,0xefbf,0xdf3f,0xb63d,0x94fb,0x8437,0x73b3,0x7392,0x6b2f,0x732e,0xa474,0xb517,0xbd38,0xc578,0xcdba,0xddfb,0xe65c,0xee9d,0xeede,0xf6de,0xf6de,0xf6de,0xf6fe,0xf6fd,0xf6fc,0xf6dc,0xf6db,0xeebb,0xeeba,0xeeba,0xf6ba,0xf6da,0xf6db,0xf6fb,0xff3c,0xff3c,0xff3b,0xff1b,0xf6da,0xf6b8,0xee77,0xee56,0xe635,0xe5f4,0xd5b3,0xc511,0x940d,0x73cf,0x4aab,0x2104,0x10c4,0x10e4,0x08a2,0x10a3,0x18c3,0x1082,0x0862,0x1083,0x10c4,0x10e4,0x10a3,0x10a4,0x10c4,0x1946,0x0862,0x0883,0x2187,0x3b94,0x5c36,0x74d8,0x5370,0x0882,0x1082,0x2125,0x31a7,0x6435,0x9ddc,0x7cd6,0x53b3,0x6c55,0x95dc,0x9dfc,0x7d19,0x757c,0x1b7b,0x0afa,0x0b19,0x0b1a,0x0b1a,0x12fa,0x0b19,0x0b39,0x0b19,0x0afa,0x12fa,0x12fa,0x12f9,0x02ba,0x6cbc,0xbe1b,0x84bb,0x9d5d,0xa59d,0xb61e,0xc67f,0xc67f,0xce9e,0xd6df,0xdf3f,0xe73f,0xe73f,0xe73f,0xef5f,0xef7f,0xe75f,0xe75f,0xe77f,0xefbf,0xef9f,0xef9f,0xef9f,0xef9f,0xef9f,0xdf5f,0xc67e,0xa5bd,0x9d1c,0x8438,0x6330,0x3166,0x41a8,0x5a8c,0x8390,0x9c54,0xb4f6,0xc516,0xcd58,0xddb9,0xe63b,0xe67c,0xe67c,0xe69c,0xee9c,0xee9c,0xee9c,0xee9b,0xee9a,0xee9a,0xe67a,0xe679,0xe679,0xee99,0xeeba,0xf6da,0xf6fb,0xf71b,0xff1b,0xff1b,0xf6fb,0xf6da,0xf6d9,0xf6b8,0xf698,0xee57,0xee36,0xe5f5,0xdd92,0xcd51,0xac90,0x734b,0x5249,0x632e,0x634f,0x2166,0x18e3,0x18c3,0x1082,0x10a3,0x18e4,0x1926,0x1905,0x10c4,0x10e4,0x18e4,0x0841,0x1904,0x2a6c,0x43f7,0x5c77,0x8dba,0x328c,0x1062,0x20e5,0x3a2a,0x31e8,0x7c96,0xadfc,0x7cd6,0x5bd3,0x7cf8,0x95bc,0xae5e,0x857b,0x95dc,0x6d3e,0x0b19,0x0b19,0x1319,0x0b1a,0x0b1a,0x0afa,0x0b19,0x12f9,0x12fa,0x0afa,0x0afa,0x12fa,0x02ba,0x6cbc,
0xbe3c,0x84bb,0x9d7d,0xa59e,0xb5fe,0xbe3e,0xbe3e,0xce9f,0xdeff,0xdf3f,0xdf1f,0xe73f,0xe75f,0xe75f,0xef9f,0xef7f,0xe77f,0xe75f,0xef9f,0xef9f,0xef7f,0xe77f,0xe77f,0xe75f,0xdf3f,0xdf5f,0xcede,0xd6ff,0xb61f,0x8c9a,0x422b,0x3166,0x3166,0x3166,0x39a7,0x6aed,0x93f1,0xac74,0xbcf5,0xc557,0xcd98,0xd5d8,0xddf9,0xde3a,0xe63a,0xe65a,0xe65a,0xe659,0xe659,0xe659,0xe659,0xe658,0xe658,0xe679,0xee99,0xeeba,0xf6da,0xf6da,0xf6da,0xfedb,0xf6db,0xfeda,0xfefa,0xf6da,0xf6b9,0xee77,0xee56,0xe615,0xe5d4,0xddb3,0xd572,0xc510,0x93ac,0xad77,0xbe7c,0x5b4f,0x2146,0x0882,0x10a2,0x1925,0x2187,0x2167,0x1925,0x1905,0x10e4,0x0862,0x1987,0x3b52,0x5418,0x6478,0x959a,0x3a6b,0x18c3,0x2988,0x4aee,0x3209,0x84b6,0xa5fc,0x6c57,0x6455,0xae3c,0xc6fe,0xcf3e,0xb69e,0x9e3d,0xb6de,0x447c,0x02fa,0x131a,0x0b1a,0x0afa,0x0afa,0x12fa,0x12fa,0x0afa,0x0afa,0x0afa,0x12fa,0x02ba,0x6cdc,0xbe3c,0x84bb,0x9d7d,0xadbe,0xadbd,0xb61e,0xc69f,0xce9f,0xd6bf,0xd6df,0xdeff,0xe73f,0xe75f,0xef7f,0xef7f,0xefbf,0xe77f,0xe75f,0xe75f,0xefbf,0xef9f,0xe79f,0xe77f,0xe75f,0xd6df,0xdf5f,0xdf5f,0xe79f,0xe7bf,0xb63f,0x4a8d,0x3186,0x31a7,0x31a7,0x3146,0x2905,0x39a7,0x628b,0x7b8f,0x9c52,0xac93,0xbcd4,0xc535,0xcd76,0xcdb7,0xd5d8,0xd5d8,0xd5d7,0xd5f7,0xde18,0xde18,0xde38,0xde38,0xde38,0xe658,0xe679,0xee99,0xeeba,0xf6ba,0xf6da,0xf6da,0xf6fa,0xf6fb,0xf6fb,0xf6da,0xf6b9,0xf698,0xee77,0xee56,0xe636,0xee15,0xe5d4,0xcd31,0xacd1,0xef7f,0xe79f,0xadfb,0x7413,0x42ac,0x2166,0x2167,0x2987,0x2146,0x1925,0x21c9,0x1946,0x220a,0x4c17,0x5c58,0x7d1a,0x8d79,0x4aed,0x2126,0x52ed,0x4b0e,0x3a2a,0x6c34,0xa61b,0x8d18,0x7cb7,0xb67d,0xae3d,0xae7d,0xbeff,0xae7d,0xc6de,0x9e5f,0x239a,0x0afa,0x0b1a,0x0b1a,0x0b1a,0x12fa,0x12f9,0x0af9,0x12fa,0x12fa,0x12fa,0x02ba,0x6cdc,
0xbe1c,0x84bb,0x9d5d,0xa57d,0xadde,0xb5ff,0xc65f,0xce7f,0xce9f,0xdeff,0xdf1e,0xe77f,0xe77f,0xef7f,0xef7f,0xe77f,0xefbf,0xef9f,0xe75f,0xef9f,0xefbf,0xe77f,0xe79f,0xe79f,0xe75f,0xdf5f,0xdf7f,0xdf7f,0xf7ff,0xe77f,0x5b2f,0x3187,0x39a7,0x39a7,0x3987,0x3166,0x3146,0x3146,0x20e4,0x41a7,0x730d,0x8bd0,0x9410,0xa451,0xacb3,0xbd14,0xbd35,0xbd35,0xc576,0xcdb6,0xcdd7,0xd5f7,0xd617,0xde17,0xde38,0xde58,0xe679,0xee9a,0xf6ba,0xf6da,0xf6db,0xf6db,0xf6fb,0xf6fb,0xf6fb,0xf6da,0xf6d9,0xf6b9,0xf698,0xf698,0xf677,0xee56,0xe614,0xbcf1,0xdefc,0xf7df,0xf7df,0xdf5f,0xc6bf,0x9dbb,0x63d3,0x428d,0x2187,0x2146,0x3b10,0x21e9,0x220a,0x4c17,0x5c98,0x8d9b,0x7cf6,0x4b2f,0x29a8,0x5bb2,0x4b0d,0x4aed,0x7433,0xb5d9,0xadfa,0x8d19,0x9ddc,0xb69e,0xc6fe,0xcf3f,0xbebe,0xae5d,0xb69f,0x651d,0x031a,0x131a,0x0b1a,0x0b1a,0x12f9,0x12f9,0x12f9,0x12fa,0x12da,0x12fa,0x02ba,0x6cbc,0xbe1b,0x7cba,0x953b,0xa59e,0xadde,0xb5fe,0xbe3e,0xc67e,0xd6ff,0xdf3f,0xe73f,0xe75f,0xe75f,0xe73f,0xef7f,0xefbf,0xef9f,0xefbf,0xe75f,0xe73f,0xefbf,0xdf7f,0xdf7f,0xef9f,0xdf3e,0xdf3f,0xe79f,0xefdf,0xf7ff,0xf7ff,0xb5f9,0x3a09,0x39e8,0x39a7,0x39a7,0x3187,0x3166,0x3187,0x2945,0x1062,0x20a3,0x3966,0x526a,0x5aca,0x7b6d,0x93ce,0x940f,0x9c50,0xacb2,0xb514,0xbd55,0xc575,0xcdb6,0xd5d7,0xd5f7,0xde38,0xde58,0xe699,0xee9a,0xf6ba,0xf6ba,0xf6db,0xfefb,0xf6fb,0xf6fb,0xfefa,0xfeda,0xf6da,0xf6b9,0xfeb9,0xf6b8,0xf697,0xee77,0xd573,0xdebb,0xf7df,0xf7df,0xef9f,0xdf5f,0xdf5f,0xd71f,0xc69e,0x9d7a,0x6c55,0x5c37,0x32ce,0x19a9,0x5c38,0x751a,0x9e1d,0x9d99,0x5351,0x29c8,0x5b93,0x532e,0x8473,0x8cd5,0x84d6,0xae3c,0x8d18,0xbe9d,0xdfbf,0xcf3e,0xcf3f,0xc71f,0xae9d,0xb6df,0xa67f,0x2bbb,0x02fa,0x131a,0x0b1a,0x1319,0x1319,0x12f9,0x12fa,0x12fa,0x12fa,0x02ba,0x6cdc,
0xbe1b,0x7c99,0x9d3c,0xa57d,0xadde,0xb5fe,0xbe3e,0xce9f,0xd71f,0xdf5f,0xdf3f,0xdf1f,0xe75f,0xef7f,0xe77f,0xef9f,0xefbf,0xef9f,0xefbf,0xdf3f,0xe75f,0xe77f,0xdf5f,0xefbf,0xefbf,0xdf7f,0xdf7f,0xefdf,0xffdf,0xf7df,0xefbf,0x6b90,0x422a,0x4208,0x41c8,0x39a7,0x3166,0x3987,0x3187,0x18c4,0x1882,0x1882,0x3166,0x31a7,0x5a8a,0x8b2a,0x938b,0x93cc,0x93cd,0x940f,0x9c71,0xacd2,0xbd34,0xc575,0xcdb6,0xd5f7,0xde17,0xde58,0xe679,0xee79,0xee99,0xeeba,0xf6da,0xf6fb,0xf6fb,0xf6fa,0xfeda,0xfeda,0xfeda,0xfeda,0xfed9,0xf6b9,0xf698,0xddd5,0xde59,0xffdf,0xf7df,0xf7df,0xef9f,0xe77f,0xe77f,0xdf5f,0xdf3f,0xdf5f,0xc6df,0xa5fd,0x7cb7,0x7cfa,0x8d9b,0xae9e,0x9dba,0x84b5,0x31e8,0x6c13,0x5330,0x8cd6,0x6bd1,0x957a,0xb65c,0xae5b,0xd77f,0xdf9f,0xdf9f,0xdf7f,0xe79f,0xdf9e,0xd77e,0xdfbf,0x963e,0x1b9a,0x0afa,0x0b19,0x1319,0x12f9,0x0af9,0x12fa,0x12fa,0x12fa,0x029a,0x6cbc,0xbe1b,0x7c79,0x951c,0xa57d,0xadbe,0xb5fe,0xc67f,0xcebf,0xd6df,0xd6ff,0xdf3f,0xe75f,0xe77f,0xe77f,0xef9f,0xef9f,0xefbf,0xef9f,0xef9f,0xe77f,0xdf3f,0xe75f,0xe77f,0xe79f,0xe7bf,0xdf3f,0xdf5f,0xe79f,0xf7df,0xf7ff,0xf7ff,0x9d17,0x52ce,0x52cd,0x4a4b,0x39c8,0x3987,0x39a7,0x3187,0x2125,0x1082,0x18a3,0x18c3,0x31a7,0x4229,0x72ca,0x936a,0xa3ab,0xa3ec,0xa3cc,0x93ac,0x8bce,0x9c50,0xacd3,0xbd34,0xc595,0xcdb6,0xd5f7,0xde38,0xe658,0xe679,0xee99,0xeeba,0xf6da,0xf6da,0xf6da,0xf6da,0xf6da,0xf6da,0xf6da,0xf6da,0xf6d9,0xf6d9,0xddf5,0xd5f7,0xffdf,0xffdf,0xffff,0xf7bf,0xef9f,0xef9f,0xef9f,0xef9f,0xef9f,0xdf5f,0xd73f,0xd73f,0xc6df,0xb67f,0xa63d,0x959b,0x9559,0x5b92,0x6413,0x5b92,0x7c95,0x5b70,0xbe7c,0xcf1e,0xbebd,0xd75f,0xe7bf,0xefdf,0xefdf,0xefdf,0xefff,0xdf7e,0xd73e,0xdf7f,0xb6fe,0x3c1b,0x02fa,0x131a,0x1319,0x12fa,0x0afa,0x12fa,0x12d9,0x0aba,0x6cbc,
0xb5fb,0x7c9a,0x8cfb,0x9d5c,0xa5be,0xb61f,0xc65f,0xce9f,0xce9f,0xd6df,0xdf3f,0xe75f,0xe77f,0xe77f,0xef9f,0xefbf,0xef9f,0xefbf,0xe79f,0xefbf,0xe77f,0xdf3f,0xdf7f,0xdf7f,0xefdf,0xdf7f,0xdf5f,0xdf9f,0xe7df,0xefff,0xf7ff,0xd71d,0x63d5,0x5392,0x530f,0x4a6b,0x41c8,0x39c7,0x39a7,0x3166,0x18a3,0x18a3,0x1882,0x2145,0x4208,0x41e7,0x830a,0x9b8b,0xabcb,0xac0c,0xac0c,0x9beb,0x8b8c,0x8bad,0x9c50,0xb4f3,0xbd34,0xcd95,0xd5d7,0xde17,0xe658,0xe679,0xee99,0xeeba,0xf6da,0xf6da,0xf6da,0xf6da,0xf6da,0xf6da,0xf6da,0xf6da,0xf6da,0xe616,0xd5f7,0xffff,0xffff,0xffff,0xf7bf,0xf79f,0xf7bf,0xf7df,0xf7bf,0xef7f,0xe77f,0xef9f,0xef9f,0xdf5f,0xd73f,0xcf1f,0xc6ff,0xbebf,0xb69f,0xa61d,0x957a,0x7cf9,0x7c96,0xbe9d,0xc6be,0xd75f,0xe7bf,0xefff,0xe7df,0xe7df,0xe7bf,0xe7bf,0xdf9f,0xbede,0xa67e,0xae7e,0x963d,0x239a,0x0afa,0x1319,0x12fa,0x12da,0x12da,0x12d9,0x029a,0x6cbc,0xadda,0x7459,0x8cfb,0x953c,0xa5be,0xb63e,0xbe3f,0xc65f,0xcebf,0xcedf,0xdf1f,0xe75f,0xefbf,0xef9f,0xe77f,0xef9f,0xefbf,0xefbf,0xefbf,0xe7bf,0xe79f,0xdf3f,0xe75f,0xdf7f,0xe7bf,0xe79f,0xdf5f,0xdf9f,0xe7df,0xefdf,0xefdf,0xefdf,0x955b,0x63d7,0x5bb4,0x534f,0x4a6b,0x41e8,0x39c7,0x31a7,0x2104,0x1083,0x10a3,0x1082,0x2924,0x3186,0x4a49,0x936b,0xa3ab,0xa3ec,0xabeb,0xb40c,0xb42c,0xa3cb,0x836b,0x83ce,0x9c71,0xb513,0xbd74,0xcdb6,0xd617,0xde58,0xe679,0xee99,0xeeba,0xf6da,0xf6da,0xf6da,0xf6da,0xf6da,0xf6fa,0xf6da,0xf6da,0xe616,0xcdb6,0xffff,0xffff,0xffff,0xf7df,0xffdf,0xf7df,0xf7df,0xf7df,0xf7bf,0xef9f,0xf7df,0xf7df,0xef9f,0xe79f,0xe77f,0xd73f,0xd71f,0xd71f,0xcf3f,0xcf1f,0xc6df,0xae7f,0x9e1d,0xae5c,0xb69d,0xcf1e,0xdf9f,0xefbf,0xefff,0xe7bf,0xdf9f,0xcf5f,0xb6be,0x95fd,0xa65f,0xb6df,0x9e5d,0x2bd9,0x0ad9,0x12f9,0x12f9,0x12d9,0x12d9,0x0299,0x6c9c,
0xadda,0x7459,0x8cdb,0x9d5d,0xa57d,0xadde,0xbe3e,0xc67f,0xcebf,0xd6ff,0xdf3f,0xdf5f,0xe77f,0xef9f,0xef9f,0xef9f,0xef9f,0xef9f,0xefbf,0xe79f,0xe79f,0xe75f,0xdf3f,0xdf5f,0xe79f,0xe79f,0xdf3f,0xdf5f,0xe7bf,0xefdf,0xe7bf,0xefdf,0xc6be,0x7c9b,0x6c39,0x5bb4,0x5330,0x4a8c,0x4229,0x39c8,0x2966,0x1083,0x1083,0x1882,0x1882,0x2925,0x39e8,0x5227,0x938b,0xa3cb,0xabec,0xabeb,0xac0c,0xb42c,0xac0c,0x8b8b,0x7b4b,0x8bee,0xa4b1,0xb534,0xc595,0xd5d7,0xde18,0xe658,0xe679,0xee9a,0xeeba,0xf6da,0xf6da,0xf6da,0xf6fa,0xf6da,0xf6da,0xe617,0xcdb6,0xffff,0xffff,0xffff,0xffdf,0xffff,0xffdf,0xf7df,0xf7df,0xffdf,0xf7df,0xf7df,0xf7bf,0xf7bf,0xf7bf,0xef9f,0xe77f,0xe77f,0xe77f,0xdf7f,0xd75f,0xd73f,0xcf3f,0xcf1f,0xbedf,0xb69f,0xae5e,0xae5e,0xbe9d,0xc6de,0xb6bd,0xa63d,0xa65e,0xa67f,0xae9f,0xb6df,0xbeff,0xc71f,0x961d,0x1359,0x0ad9,0x12f9,0x12d9,0x12d9,0x0279,0x6c9c,0xb5da,0x6c18,0x8cfb,0x953c,0x9d5c,0xadbe,0xb5fe,0xc67f,0xd6ff,0xd71f,0xdf3f,0xdf3f,0xe75f,0xef9f,0xef9f,0xe77f,0xef9f,0xefbf,0xefbf,0xefbf,0xe77f,0xe75f,0xdf3f,0xdf7f,0xdf9f,0xe79f,0xd73f,0xd71f,0xdf5f,0xe79f,0xe7df,0xefdf,0xd77f,0xa5ff,0x84fc,0x6c38,0x5bb4,0x5350,0x4aac,0x3a09,0x39e8,0x18c4,0x1062,0x1082,0x1082,0x1082,0x2104,0x2945,0x5248,0x938b,0xa3eb,0xa3cb,0xabeb,0xac0b,0xb42c,0xbc4c,0xa3cb,0x72ea,0x7b6d,0x9c50,0xacf2,0xbd54,0xcdb6,0xd5f7,0xde38,0xe679,0xee99,0xee99,0xeeb9,0xeeba,0xf6da,0xf6da,0xf6fa,0xe617,0xc575,0xffff,0xffff,0xffff,0xffff,0xffff,0xffdf,0xf7df,0xf7df,0xffff,0xf7df,0xf7df,0xf7df,0xf7df,0xf7bf,0xf7bf,0xefbf,0xef9f,0xef9f,0xefbf,0xe79f,0xe77f,0xdf7f,0xdf5f,0xd73f,0xd71f,0xcf3f,0xcf5f,0xc71e,0xb67f,0xae7f,0xae5e,0xa63e,0x95fd,0xae7e,0xb69e,0xae7d,0xb6be,0xb6df,0x757d,0x133a,0x12f9,0x1b1a,0x12f9,0x0279,0x6cbc,
0xadda,0x6c18,0x8cfb,0x951b,0x9d5c,0xa5be,0xb5de,0xc63f,0xcedf,0xd6ff,0xd6ff,0xe73f,0xe73f,0xe75f,0xefbf,0xef9f,0xefbf,0xefbf,0xefbf,0xef9f,0xe75f,0xdf3f,0xdf3f,0xdf5f,0xdf7f,0xdfbf,0xd75f,0xd73f,0xcf1f,0xd73f,0xe7df,0xefdf,0xdf9f,0xbe9f,0xae3f,0x84fc,0x6bf7,0x5bd5,0x5351,0x4a6c,0x422a,0x2987,0x1082,0x1082,0x1082,0x1082,0x1882,0x20e4,0x3186,0x5aaa,0x836b,0x9bcb,0xa3cb,0xabeb,0xb42b,0xb44c,0xc46c,0xb42c,0x7309,0x62ea,0x8bee,0xa4b1,0xb533,0xc595,0xcdd6,0xd617,0xde38,0xe658,0xe679,0xee99,0xeeba,0xf6da,0xf6da,0xddd6,0xbd34,0xf7df,0xf7ff,0xffff,0xffff,0xffdf,0xf7df,0xf7df,0xffdf,0xffdf,0xffdf,0xf7df,0xffdf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7bf,0xef9f,0xef9f,0xefbf,0xefbf,0xf7df,0xef9f,0xe77f,0xdf5f,0xdf7f,0xdf7f,0xdf7f,0xd77f,0xcf5f,0xc71f,0xbedf,0xbedf,0xb69f,0xa61d,0x8d7c,0x9dfd,0xa65e,0x9e3e,0x651c,0x0b7a,0x035b,0x133a,0x02b9,0x6cbc,0xadda,0x6c17,0x84ba,0x953c,0x9d5c,0xadbe,0xb5fe,0xbe1f,0xc65f,0xcedf,0xdf1f,0xdf1f,0xdf3f,0xe75f,0xef9f,0xef9f,0xef9f,0xef9f,0xef9f,0xefbf,0xe77f,0xdf1f,0xdf3f,0xdf3f,0xdf5f,0xdf7f,0xd71f,0xcf1f,0xd73f,0xdf7f,0xefdf,0xefdf,0xdf7f,0xbe7f,0xbebf,0xa5ff,0x7cbb,0x6418,0x5bd6,0x4acf,0x428b,0x3a0a,0x18c3,0x1082,0x1082,0x1082,0x1882,0x18a2,0x2124,0x3a09,0x39e7,0x730b,0x8b8d,0x8b8b,0x93cb,0x9bec,0x9bec,0x9bcc,0x7b8d,0x636d,0x5aaa,0x738c,0x9450,0xacd2,0xbd54,0xcdb5,0xd5d6,0xd617,0xde38,0xe678,0xe699,0xee9a,0xeeba,0xcd95,0xb4d3,0xf7df,0xf7df,0xffff,0xffdf,0xffdf,0xffdf,0xffdf,0xffdf,0xffdf,0xffdf,0xffdf,0xf7df,0xf7df,0xf7df,0xf7bf,0xf7bf,0xf7df,0xf7df,0xf7bf,0xf7df,0xefbf,0xf7df,0xefbf,0xf7bf,0xefbf,0xef9f,0xe77f,0xe77f,0xe79f,0xe7bf,0xdf9f,0xd75f,0xcf3f,0xd73f,0xcf1f,0xc6df,0xbebf,0xbedf,0xb69e,0x95dd,0x6d1c,0x2c3b,0x037a,0x02b9,0x64bc,
0xadda,0x63f7,0x849a,0x8cfb,0x9d5c,0xad9e,0xb5fe,0xbe1f,0xc65f,0xd6df,0xd6df,0xdeff,0xe73f,0xe75f,0xe77f,0xef9f,0xefbf,0xefbf,0xef9f,0xef9f,0xe79f,0xdf5f,0xdf3f,0xdf3f,0xd73f,0xdf7f,0xc6bf,0xcedf,0xcf1f,0xe7bf,0xe7df,0xefdf,0xd77f,0xb65f,0xbe9f,0xbebf,0x9d9e,0x747a,0x6c18,0x5332,0x4aac,0x42ad,0x3187,0x1061,0x1082,0x1082,0x10a2,0x1882,0x20a2,0x20e3,0x18e4,0x31c8,0x636e,0x5b2d,0x52cb,0x73b0,0x7bf0,0x8c73,0x73af,0x7c11,0x8c10,0x62a9,0x6b0a,0x8bee,0xa4b1,0xb513,0xbd74,0xcdb6,0xd5f7,0xde38,0xde58,0xe679,0xe679,0xc534,0xa471,0xf7bf,0xf7df,0xffff,0xffdf,0xffdf,0xffff,0xffdf,0xffdf,0xf7df,0xffff,0xffff,0xf7df,0xf7df,0xf7df,0xf7bf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7ff,0xf7df,0xefbf,0xf7df,0xefbf,0xefbf,0xefbf,0xe7bf,0xe79f,0xdf7f,0xdf7f,0xdf5f,0xd73f,0xcefe,0xcf1f,0xcf1f,0xbe9e,0xae7f,0x759d,0x3c1b,0x857d,0xadb9,0x63d7,0x849a,0x8cda,0x953c,0xadbe,0xb5de,0xbe3f,0xce7f,0xcebf,0xdedf,0xdedf,0xe73f,0xe77f,0xe77f,0xe77f,0xef9f,0xefbf,0xf7bf,0xefbf,0xefbf,0xe79f,0xdf3f,0xdf5f,0xd73f,0xdf7f,0xcefe,0xc6bf,0xcf3f,0xe7df,0xe7df,0xefdf,0xcf1f,0xae1e,0xb67f,0xc6df,0xb65f,0x8d1c,0x7459,0x63d5,0x4aee,0x4aee,0x3a4b,0x18a3,0x1082,0x1082,0x10a2,0x18a2,0x20a3,0x20c3,0x18a2,0x2125,0x29c7,0x3a07,0x5b91,0x8cf6,0x7c12,0x8cd6,0x83f1,0x8bee,0xb48f,0xa42e,0x4a69,0x5aaa,0x7bad,0x9c50,0xacf2,0xbd54,0xc595,0xcdd6,0xd617,0xde38,0xde38,0xacd3,0x8c10,0xef9f,0xffff,0xffff,0xf7df,0xffdf,0xf7df,0xffff,0xffdf,0xf7df,0xffdf,0xffdf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7bf,0xf7df,0xf7ff,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xf7df,0xf7df,0xf7df,0xefdf,0xf7df,0xefdf,0xefbf,0xef9f,0xefbf,0xe79f,0xdf7f,0xd73f,0xdf5f,0xd75f,0xcf1f,0xc6ff,0xb6bf,0xcf1f,
0xadb9,0x63d6,0x7c79,0x8cda,0x951b,0xa55d,0xb5fe,0xbe3f,0xc65f,0xce7f,0xd69f,0xdedf,0xe73f,0xe75f,0xe77f,0xe77f,0xe77f,0xefbf,0xf7df,0xefdf,0xefbf,0xe77f,0xe77f,0xdf5f,0xd75f,0xd75f,0xcf1f,0xd73f,0xdf9f,0xe7df,0xe7bf,0xefdf,0xc6be,0x9d7e,0xae1e,0xbebf,0xbedf,0xa5df,0x7c9b,0x6c58,0x5310,0x4b0f,0x430f,0x2966,0x1061,0x1082,0x1082,0x18a2,0x20c3,0x2904,0x28e3,0x3185,0x3a07,0x39c8,0x428a,0x52cb,0x52ec,0x4aed,0x93cc,0xac4f,0xb48e,0x93ed,0x42ee,0x426a,0x4a69,0x734c,0x8c0f,0x9c91,0xad13,0xbd74,0xc5b5,0xd5f7,0xc5d6,0x9c71,0x736d,0xe75e,0xffff,0xffff,0xffff,0xf7df,0xf7df,0xffff,0xffff,0xf7df,0xffdf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7bf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7ff,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xefdf,0xefbf,0xe7bf,0xe7bf,0xe77f,0xdf5f,0xdf7f,0xd73f,0xcf1f,0xdf7f,0xadda,0x5bb6,0x7478,0x84ba,0x94fb,0x9d3c,0xadbe,0xbe1f,0xc65f,0xce7f,0xce7f,0xdeff,0xe75f,0xe75f,0xe77f,0xef9f,0xef9f,0xefbf,0xefdf,0xf7df,0xefdf,0xe79f,0xe79f,0xdf5f,0xdf7f,0xd75f,0xc6ff,0xceff,0xe79f,0xe79f,0xe7bf,0xe7bf,0xbe9e,0x9d7e,0xb65f,0xbe9f,0xbebf,0xb65f,0x853d,0x749a,0x5b93,0x4aef,0x4b50,0x428c,0x18c3,0x1062,0x1082,0x1082,0x18c3,0x28e3,0x2904,0x18a2,0x18a2,0x3a4a,0x5bb2,0x5b91,0x6b8f,0x83ad,0x9c2d,0xa44e,0xac4d,0x734c,0x3ace,0x42ee,0x430e,0x4249,0x5aaa,0x7b8d,0x940f,0xa4b2,0xb533,0xbd55,0xb534,0x83ee,0x5acb,0xdefd,0xffff,0xffff,0xf7df,0xf7ff,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7bf,0xf7df,0xf7bf,0xf7df,0xf7bf,0xf7df,0xffdf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xefdf,0xf7df,0xf7df,0xffdf,0xffdf,0xffdf,0xf7df,0xf7df,0xffdf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7ff,0xefdf,0xefbf,0xefbf,0xefbf,0xe77f,0xdf5f,0xd75f,0xe79f,
0xa599,0x5bb5,0x7478,0x7c79,0x94fb,0xa55d,0xad9d,0xb5dd,0xbe3e,0xce7f,0xd6bf,0xd6df,0xdf1f,0xe75f,0xef7f,0xef9f,0xefbf,0xefbf,0xefbf,0xf7df,0xf7df,0xefbf,0xe77f,0xdf7f,0xdf5f,0xd73f,0xceff,0xd75f,0xe79f,0xe79f,0xe79f,0xe7bf,0xb67e,0x957e,0xb65f,0xbe7f,0xbe9f,0xb69f,0x9dfe,0x84db,0x6c17,0x4b10,0x4b51,0x4b51,0x31a8,0x1062,0x1061,0x1062,0x1082,0x18a3,0x18a3,0x1881,0x18a2,0x3208,0x6c12,0x5370,0x6bf1,0x940e,0x9c0d,0xa42d,0x9c2e,0x4b0d,0x3a6c,0x3aee,0x4b50,0x42cd,0x3a29,0x4a28,0x62ca,0x83ad,0x9450,0xa4b2,0x9471,0x6b4c,0x5269,0xd6bb,0xffff,0xffdf,0xf7df,0xefbf,0xf7df,0xf7df,0xf7bf,0xf7df,0xf7bf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xffdf,0xf7df,0xf7df,0xffdf,0xf7df,0xf7df,0xf7df,0xf7df,0xffdf,0xffdf,0xf7df,0xffff,0xffff,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xffff,0xf7df,0xf7ff,0xf7df,0xf7df,0xefdf,0xefdf,0xef9f,0xdf7f,0xefdf,0xa5b9,0x5395,0x7458,0x7c99,0x8cfb,0x9d3c,0xad9d,0xadbd,0xbe3e,0xcebf,0xd6df,0xdeff,0xe73f,0xe75f,0xe77f,0xef9f,0xefbf,0xefbf,0xf7df,0xefbf,0xf7df,0xefbf,0xef9f,0xdf7f,0xd77f,0xd73f,0xcf1f,0xdf7f,0xe79f,0xe79f,0xe7bf,0xe7bf,0xb67e,0x955e,0xae1e,0xb65e,0xb69f,0xb67f,0xae5f,0x9dbe,0x749a,0x5373,0x4b51,0x4bb3,0x42ee,0x18e5,0x18c4,0x18e5,0x2126,0x2106,0x2106,0x2126,0x2146,0x2167,0x31ea,0x320b,0x322b,0x52ac,0x7b4c,0x8bac,0x83ce,0x430e,0x32ad,0x3aae,0x3a8c,0x3a8c,0x3ace,0x3a8b,0x3a28,0x4a28,0x62eb,0x736d,0x6b4c,0x5289,0x4228,0xce9a,0xffff,0xffff,0xf7df,0xefbf,0xef9f,0xf7df,0xf7df,0xefbf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7ff,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xffdf,0xffdf,0xf7df,0xffff,0xf7df,0xf7df,0xffff,0xf7df,0xffdf,0xffdf,0xf7df,0xffff,0xffff,0xffdf,0xffdf,0xf7ff,0xffff,0xf7ff,0xf7df,0xf7df,0xf7df,0xefbf,0xf7bf,
0xa578,0x5395,0x6c37,0x7c99,0x8cda,0x94fb,0xa57c,0xb5de,0xc63f,0xc67f,0xcebf,0xdeff,0xdf3f,0xe75f,0xe79f,0xefbf,0xefbf,0xefbf,0xefbf,0xefbf,0xefbf,0xefbf,0xefbf,0xe79f,0xdf7f,0xd75f,0xc6df,0xd75f,0xe7bf,0xe7bf,0xe7bf,0xdf9f,0xae3e,0x8d3d,0xae3f,0xbe9f,0xae5e,0xb69f,0xae5f,0xae3f,0x853d,0x5bf5,0x42ef,0x3a8d,0x324c,0x29ea,0x31ea,0x31ea,0x31ea,0x29a9,0x29a9,0x29a9,0x2188,0x29a9,0x2189,0x2188,0x29a9,0x2189,0x29aa,0x39c9,0x3a2a,0x322b,0x328d,0x3ace,0x326c,0x29c8,0x3209,0x3aac,0x3acd,0x324b,0x31c7,0x41e7,0x4208,0x39c7,0x39c7,0xc639,0xffff,0xffff,0xf7df,0xe77f,0xef9f,0xefbf,0xefbf,0xf7df,0xf7df,0xf7df,0xefbf,0xf7bf,0xf7ff,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7ff,0xf7ff,0xffff,0xf7df,0xf7df,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7bf,0xf7df,0xf7df,0xf7df,0x9d78,0x5395,0x7438,0x7c79,0x84ba,0x94fb,0xa55c,0xb5de,0xbe3f,0xc67f,0xce9f,0xd6bf,0xdf1f,0xe77f,0xefbf,0xefbf,0xefbf,0xe77f,0xefbf,0xefbf,0xefbf,0xef9f,0xefdf,0xefdf,0xdf7f,0xdf7f,0xc6df,0xd75f,0xdfbf,0xdf9f,0xdf9f,0xdf7f,0x9dbd,0x851c,0xa5dd,0xbe9f,0xb67f,0xb69f,0xb67f,0xae1e,0x7c76,0x428e,0x322b,0x3a2b,0x320a,0x320a,0x31ea,0x29a9,0x29c9,0x21c9,0x29ca,0x29ea,0x29ca,0x29eb,0x29eb,0x2a0b,0x29ca,0x29ca,0x29ca,0x29cb,0x29ea,0x21ca,0x21aa,0x29ca,0x322b,0x324b,0x2a09,0x320a,0x3a8c,0x4330,0x3aef,0x29c8,0x2125,0x2925,0x2946,0xbdf8,0xffff,0xffdf,0xf7df,0xe77e,0xef9f,0xef9f,0xe77f,0xefbf,0xf7df,0xefbf,0xf7df,0xefbf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7ff,0xefdf,0xf7df,0xf7df,0xf7ff,0xf7df,0xf7df,0xf7ff,0xf7ff,0xf7df,0xf7df,0xefdf,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xefbf,0xf7df,
0xa578,0x5374,0x6c17,0x7458,0x8499,0x9d3c,0xa59d,0xadde,0xbe1e,0xc65f,0xce9f,0xd6df,0xe75f,0xef9f,0xefbf,0xefbf,0xef9f,0xefbf,0xefbf,0xefbf,0xefbf,0xefbf,0xefbf,0xe7bf,0xe79f,0xdf5f,0xc6ff,0xd77f,0xdfbf,0xdf9f,0xdf9f,0xcf3f,0x957d,0x84fc,0x9d9d,0xb67f,0xae5f,0xa5fd,0x6c14,0x42ae,0x29c9,0x322b,0x3a8d,0x3a6c,0x322b,0x29c9,0x2168,0x21a9,0x29c9,0x29ea,0x2a0b,0x29ca,0x29eb,0x29eb,0x2a0b,0x326c,0x21a9,0x29eb,0x29eb,0x21ca,0x21eb,0x21eb,0x21eb,0x21aa,0x2169,0x21aa,0x29eb,0x322b,0x322a,0x3a8c,0x3aef,0x3aae,0x324b,0x2146,0x1904,0xad56,0xffff,0xf7df,0xf7df,0xe79f,0xdf5f,0xdf7f,0xefbf,0xef9f,0xe75f,0xe77f,0xefbf,0xefbf,0xefbf,0xefbf,0xe79f,0xefbf,0xefbf,0xefbf,0xefdf,0xf7ff,0xf7df,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xefdf,0xf7df,0xa598,0x5374,0x6bf7,0x7c58,0x8499,0x951c,0xa59d,0xb5fe,0xbe1f,0xc65f,0xcebf,0xdf1f,0xe75f,0xe75f,0xef9f,0xefbf,0xf7df,0xf7df,0xefbf,0xefbf,0xefbf,0xefbf,0xefbf,0xe7bf,0xe79f,0xdf7f,0xbe9e,0xcf3f,0xd77f,0xd77f,0xd75f,0xb69f,0x84fc,0x7cdb,0x8d3c,0xa5fe,0x957b,0x3a4c,0x29c9,0x322c,0x3a4c,0x324c,0x3a6c,0x3a4b,0x29ea,0x2188,0x2989,0x29ca,0x29c9,0x21c9,0x29ea,0x2a0a,0x324c,0x2a2b,0x29ea,0x21a8,0x21a9,0x326d,0x2a2d,0x29ec,0x2a6d,0x2a2c,0x21eb,0x220b,0x21aa,0x21ab,0x218a,0x29ca,0x320a,0x3209,0x320a,0x328d,0x3aee,0x3aee,0x1988,0x8c93,0xffff,0xf7df,0xffff,0xe79f,0xd71e,0xdf5e,0xe79f,0xdf5f,0xdf7f,0xdf7f,0xe7bf,0xef9f,0xefbf,0xe79f,0xe79f,0xefdf,0xf7bf,0xf7df,0xffff,0xffff,0xf7df,0xf7df,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xa578,0x4b74,0x6c38,0x7c59,0x849a,0x8cfb,0xa55c,0xadde,0xb61e,0xc6bf,0xd6ff,0xdf1f,0xdf1f,0xdf3f,0xe77f,0xef9f,0xf7df,0xefbf,0xf7df,0xefdf,0xefbf,0xefbf,0xef9f,0xe7bf,0xe79f,0xdf7f,0xd75f,0xd77f,0xd75f,0xd77f,0xc6ff,0x9dbe,0x749a,0x7479,0x7cdb,0x955d,0x4acd,0x1906,0x3a2b,0x3a4c,0x3a6d,0x3a6d,0x322b,0x320a,0x29c9,0x2188,0x29ca,0x29ca,0x29ea,0x29ea,0x322c,0x2a0b,0x2a2b,0x324c,0x29a9,0x1968,0x326e,0x328f,0x2a4d,0x326d,0x2a2d,0x2a2c,0x2a0b,0x220b,0x2a2d,0x29cb,0x21ab,0x21aa,0x21aa,0x320a,0x322a,0x320a,0x322b,0x3a8c,0x2a6c,0x7412,0xffff,0xffdf,0xffff,0xe79f,0xdf7f,0xe7bf,0xd73e,0xd73f,0xdf7f,0xdf7f,0xefbf,0xefbf,0xef9f,0xf7df,0xf7df,0xf7df,0xf7ff,0xffff,0xffff,0xffff,0xffdf,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffdf,0xffdf,0xffff,0xffff,0xa578,0x4b34,0x6c38,0x7c7a,0x84ba,0x951c,0x9d3c,0xa5bd,0xb65e,0xcebf,0xd6ff,0xd6ff,0xdf1f,0xe73f,0xe77f,0xef9f,0xefbf,0xefbf,0xefbf,0xefff,0xefdf,0xef9f,0xe79f,0xe79f,0xe79f,0xdf5f,0xd75f,0xcf5f,0xc71f,0xc71f,0xae5f,0x84fc,0x6c39,0x6c58,0x74b9,0x6393,0x2167,0x2168,0x3a4c,0x3a6c,0x3a4c,0x322b,0x322a,0x2988,0x2988,0x29a9,0x2a0a,0x29ea,0x29ca,0x2a0b,0x2a0b,0x31eb,0x324b,0x21e9,0x21ca,0x2a2d,0x2a4e,0x324f,0x326e,0x2a6d,0x328e,0x2a4c,0x2a4d,0x220c,0x2a2d,0x2a0c,0x29ec,0x21cb,0x21aa,0x1969,0x29a9,0x324b,0x322b,0x322a,0x2a2b,0x5b90,0xf7bf,0xffff,0xffff,0xf7df,0xe79f,0xdf7e,0xdf5f,0xd71e,0xdf5f,0xdf7f,0xe75f,0xe75f,0xe77f,0xf7df,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffdf,0xf7df,0xf7df,0xffff,
0xa579,0x5375,0x6c18,0x747a,0x84bb,0x8d1d,0x9d9e,0xa5be,0xb63f,0xc67e,0xcedf,0xd6ff,0xdf1f,0xe73f,0xe77f,0xef9f,0xef9f,0xefdf,0xf7df,0xefdf,0xefdf,0xefbf,0xe77f,0xdf7f,0xdf5f,0xd73f,0xcf3f,0xc71f,0xbedf,0xae3f,0x957e,0x747a,0x6417,0x6417,0x5bb5,0x320b,0x1927,0x31ea,0x3a4c,0x3a4c,0x3a4c,0x31ea,0x2188,0x2168,0x29ea,0x2a2b,0x29ea,0x2a0b,0x320b,0x2a2b,0x2a4b,0x2a2b,0x21a9,0x21a9,0x328e,0x2a8f,0x2a4e,0x2a4e,0x328e,0x2a6d,0x2a6d,0x2a4d,0x224d,0x2a6d,0x21ec,0x2a0c,0x2a2d,0x21ab,0x21aa,0x21cb,0x1927,0x2188,0x328d,0x326c,0x326c,0x532e,0xef9f,0xffff,0xffff,0xf7ff,0xe77e,0xe77e,0xdf5e,0xdf3e,0xdf3f,0xdf5f,0xd71f,0xd71e,0xe79f,0xefbf,0xefdf,0xf7ff,0xffff,0xf7df,0xf7df,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7df,0xffdf,0xadfb,0x6419,0x749a,0x7cbb,0x8cfc,0x957d,0xa5be,0xb5fe,0xadde,0xc67f,0xcebf,0xd6df,0xdf3f,0xe75f,0xe77f,0xef9f,0xefbf,0xefdf,0xf7df,0xefdf,0xefdf,0xefbf,0xef9f,0xdf5f,0xdf7f,0xd75f,0xc6ff,0xb69f,0x9dfe,0x8d3e,0x7cdb,0x6417,0x63b6,0x63b5,0x3aaf,0x29aa,0x2168,0x322c,0x3a4c,0x3a4c,0x322b,0x29a8,0x2168,0x320b,0x2a0a,0x21ea,0x29eb,0x320b,0x320b,0x29eb,0x2a0a,0x21c9,0x2189,0x326f,0x3270,0x32b0,0x2a8e,0x2a8e,0x326d,0x324d,0x2a8d,0x2a6e,0x2a4e,0x2a6e,0x220c,0x2a2c,0x2a2c,0x21ec,0x21eb,0x21ec,0x21aa,0x10e5,0x2a0a,0x32ce,0x2a8c,0x3acc,0xdefc,0xffff,0xffdf,0xf7df,0xe75f,0xdf3e,0xd73e,0xdf5f,0xe77f,0xd71e,0xc6be,0xcf1f,0xd75f,0xe79f,0xefdf,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7ff,0xf7df,0xffff,
0xbe3c,0x74bc,0x8d5e,0x959e,0xa61f,0xb67f,0xbebf,0xbe7e,0xc6bf,0xc69f,0xcebf,0xd71f,0xdf5f,0xe75f,0xe77f,0xefbf,0xefdf,0xefdf,0xefbf,0xefdf,0xefdf,0xefbf,0xefbf,0xdf7f,0xdf5f,0xd75f,0xc6df,0xa5ff,0x8d5d,0x7cdc,0x6438,0x5bb5,0x5bb4,0x5311,0x3a2c,0x2167,0x29c9,0x3a2c,0x322b,0x3a2b,0x29ea,0x2188,0x2a0b,0x2a0b,0x29eb,0x29eb,0x29ea,0x2a0b,0x29ea,0x29ea,0x2187,0x2189,0x3290,0x32b0,0x2a6f,0x328f,0x328e,0x2a6e,0x2a4d,0x2a4d,0x2a6d,0x2a8e,0x328e,0x2a4d,0x222d,0x2a4d,0x2a4d,0x220c,0x21ec,0x21ec,0x21cb,0x1969,0x1106,0x324c,0x32cd,0x224c,0xb5f9,0xffff,0xf7df,0xf7df,0xe77f,0xcefe,0xd71e,0xd73f,0xd71e,0xc6de,0xc6de,0xcede,0xd75f,0xdf5f,0xefdf,0xf7df,0xefbf,0xf7df,0xf7ff,0xf7ff,0xf7df,0xffff,0xffff,0xffdf,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffdf,0xf7df,0xf7ff,0xffff,0xb5fb,0x6c5b,0x7cdc,0x851e,0x9ddf,0xae5f,0xbedf,0xcf3f,0xcf5f,0xdf9f,0xdf9f,0xe7bf,0xe7bf,0xe7bf,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefbf,0xe79f,0xdf7f,0xd71f,0xb65f,0x84fd,0x747a,0x5bd6,0x5373,0x5372,0x5351,0x322c,0x320b,0x2147,0x3a6d,0x3a6c,0x3a4c,0x29ca,0x21a9,0x29eb,0x2a2b,0x2a4c,0x2a2b,0x2a0b,0x2a0b,0x2a0b,0x29ca,0x2188,0x2148,0x2a4e,0x32d0,0x2a4e,0x328f,0x2a4e,0x2a6e,0x2a6e,0x2a6e,0x2a6e,0x2a8e,0x2a6e,0x2a6e,0x2a6e,0x224e,0x224d,0x224d,0x220c,0x21ec,0x21ec,0x21cc,0x21ac,0x1106,0x1947,0x322b,0x2a2b,0x9537,0xffff,0xf7bf,0xf7df,0xe79f,0xd71e,0xcefe,0xc6fe,0xbebe,0xc6df,0xc6de,0xcf3f,0xd73e,0xe77f,0xe79f,0xe77f,0xef9f,0xf7df,0xefdf,0xefdf,0xf7df,0xf7df,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7df,0xf7df,0xf7ff,0xffff,
0xb61c,0x6c7b,0x7cdc,0x84fd,0x959f,0xae3f,0xb67f,0xc6ff,0xcf5f,0xd79f,0xdfbf,0xe7df,0xefff,0xefff,0xefff,0xf7ff,0xf7df,0xefdf,0xf7df,0xefdf,0xefbf,0xefdf,0xefdf,0xe7bf,0xdf7f,0xd71f,0xa5fe,0x7479,0x5bd5,0x4b11,0x4acf,0x5310,0x3a8d,0x322c,0x29a9,0x2168,0x426d,0x3a4c,0x29ca,0x2189,0x322b,0x320b,0x29ea,0x2a0b,0x2a0b,0x29ea,0x21ea,0x21ca,0x2188,0x2127,0x2a2d,0x2a8f,0x2aaf,0x2a4e,0x2a6e,0x2a4d,0x2a4d,0x2a4d,0x2a6e,0x2a6e,0x2aaf,0x2a8f,0x224e,0x2a6e,0x2a6e,0x222c,0x224d,0x222d,0x220d,0x220c,0x220c,0x21cc,0x218a,0x1926,0x29a7,0x2187,0x63b0,0xffdf,0xf7bf,0xf7df,0xe79f,0xd73e,0xcf3e,0xb69d,0xb69e,0xbebe,0xc6be,0xd71f,0xdf3f,0xdf7f,0xdf5f,0xdf5f,0xefbf,0xefdf,0xefbf,0xefdf,0xefbf,0xefbf,0xefdf,0xf7df,0xf7ff,0xf7ff,0xffff,0xffff,0xf7df,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7df,0xf7ff,0xffff,0xb5fb,0x6c7b,0x851d,0x851e,0x959f,0xae5f,0xb67f,0xc6ff,0xcf7f,0xd79f,0xdfbf,0xe7df,0xefff,0xefff,0xf7ff,0xf7ff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7ff,0xefdf,0xefdf,0xe7bf,0xdf7f,0xdf3f,0x9d9c,0x53b5,0x4331,0x42ad,0x4a8d,0x4aad,0x31ea,0x322c,0x2147,0x29ea,0x322b,0x29ea,0x2169,0x29ea,0x326c,0x29ca,0x29ca,0x21a9,0x29c9,0x29a9,0x29ea,0x2188,0x1926,0x29aa,0x326e,0x2a6f,0x328f,0x32af,0x326e,0x2a2d,0x2a4e,0x2a4d,0x2a4d,0x2a6e,0x2a8f,0x2a8f,0x2a4e,0x2a8f,0x2a6e,0x2a6d,0x222d,0x222d,0x222d,0x2a2d,0x2a2d,0x21eb,0x21cc,0x1968,0x2167,0x1905,0x3a29,0xef7f,0xf7bf,0xf7bf,0xe77f,0xcf1e,0xcf1e,0xae7d,0xb67e,0xc6be,0xc6de,0xbebe,0xd71f,0xd73f,0xd75f,0xe7bf,0xef9f,0xe77f,0xefbf,0xefdf,0xefbf,0xefdf,0xefdf,0xefdf,0xf7df,0xf7ff,0xffff,0xffff,0xffff,0xf7ff,0xf7df,0xf7df,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffdf,0xf7df,0xffdf,0xf7ff,0xf7df,0xffdf,
0xb5fb,0x6c7b,0x855e,0x8d3f,0x8d7f,0xae5f,0xbe9f,0xc6ff,0xcf5f,0xdfbf,0xdfbf,0xe7df,0xefff,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xefbf,0xdf7f,0xdf5f,0x9d9c,0x4331,0x42ce,0x3a2a,0x426b,0x3a2b,0x29cb,0x29eb,0x1905,0x320b,0x324c,0x31eb,0x320b,0x324c,0x320b,0x29a9,0x29aa,0x2989,0x2168,0x2989,0x29c9,0x1905,0x2189,0x326e,0x2a6f,0x2a8f,0x328e,0x2a6d,0x2a2d,0x2a2c,0x2a2c,0x2a2d,0x2a4e,0x2a4e,0x228e,0x2a6d,0x2a4e,0x222e,0x2a6e,0x2a6e,0x224d,0x220d,0x2a4e,0x2a4e,0x19ec,0x220c,0x21ec,0x21ab,0x1946,0x10a3,0x2146,0xdefd,0xf7df,0xf7bf,0xef9f,0xd71e,0xb67d,0xa63d,0xae3d,0xbebe,0xc6de,0xc6fe,0xc6ff,0xbe9e,0xdf7f,0xe7bf,0xdf5f,0xdf7f,0xe77f,0xe79f,0xefbf,0xefbf,0xefbf,0xefdf,0xf7df,0xf7ff,0xf7df,0xf7df,0xf7ff,0xf7df,0xf7df,0xf7df,0xf7ff,0xffff,0xf7ff,0xffff,0xffff,0xf7ff,0xffff,0xffdf,0xffdf,0xf7df,0xf7df,0xffdf,0xb61c,0x6c9c,0x855e,0x8d5f,0x9dbf,0xb67f,0xb69f,0xc71f,0xd75f,0xd79f,0xdfbf,0xefdf,0xefff,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7ff,0xefbf,0xdf5f,0x957b,0x42ce,0x3a6b,0x31c8,0x39e9,0x29a9,0x29eb,0x29ea,0x2147,0x320c,0x324b,0x322b,0x322b,0x322b,0x31ea,0x2188,0x29aa,0x2989,0x2147,0x2188,0x1906,0x1927,0x29ec,0x2a6e,0x326f,0x32b0,0x2a8e,0x2a2d,0x2a0c,0x2a2c,0x2a0c,0x222d,0x2a4e,0x222d,0x224e,0x224d,0x2a4d,0x2a2d,0x2a4e,0x2a4e,0x222d,0x29ed,0x2a0d,0x220d,0x220d,0x220d,0x2a0c,0x21cc,0x1927,0x0882,0x10e4,0xc65a,0xffdf,0xf7bf,0xf79f,0xc6bd,0xb67d,0xa63d,0xa61d,0xbebe,0xc6de,0xcf1f,0xc6ff,0xcf1f,0xdf7f,0xdf5f,0xdf7f,0xdf7f,0xe77f,0xe77f,0xe79f,0xe79f,0xe7bf,0xefdf,0xf7ff,0xf7df,0xefdf,0xefdf,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7ff,0xffff,0xffff,0xf7ff,0xf7df,0xf7df,0xffdf,0xf7df,0xf7df,0xf7df,0xffff,
0xadfb,0x6c5b,0x851e,0x8d5f,0x9dff,0xb69f,0xbe9f,0xc6df,0xcf3f,0xd79f,0xe7df,0xefff,0xefff,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xefdf,0xae1b,0x3a4c,0x31e9,0x31a8,0x31a8,0x2989,0x320c,0x21a9,0x2127,0x29eb,0x2a0b,0x31eb,0x320b,0x29c9,0x29ca,0x1968,0x29ca,0x2167,0x2127,0x1906,0x10e5,0x29aa,0x29ec,0x2a6e,0x2a6f,0x2a6e,0x2a4d,0x220c,0x2a0c,0x2a0d,0x2a0c,0x220c,0x224e,0x2a6e,0x2a4e,0x2a6f,0x2a6e,0x2a4e,0x222d,0x220d,0x222d,0x2a4e,0x224e,0x1a0c,0x2a2d,0x220d,0x2a2d,0x21cc,0x1969,0x10a3,0x0862,0xa536,0xffff,0xf7bf,0xf7bf,0xc69c,0xbe7d,0xae5c,0x9dfc,0xa63d,0xcf1f,0xbedf,0xc6ff,0xdf9f,0xdf5f,0xd75f,0xdf7f,0xe79f,0xe7bf,0xdf7f,0xdf5f,0xe7bf,0xefdf,0xf7ff,0xf7df,0xefdf,0xf7ff,0xefdf,0xefbf,0xf7df,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7ff,0xffff,0xf7ff,0xf7df,0xefbf,0xf7df,0xf7df,0xf7df,0xf7df,0xffff,0xad99,0x5bb7,0x745a,0x84dd,0x957e,0xb65f,0xbe9f,0xbedf,0xc73f,0xd79f,0xe7df,0xefff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xe79f,0x532f,0x2988,0x31a8,0x2988,0x29aa,0x3a2c,0x2167,0x2148,0x2a0b,0x322b,0x3a4c,0x326c,0x29ea,0x2169,0x2168,0x2188,0x2127,0x1927,0x10e5,0x1947,0x29ab,0x29ec,0x2a2d,0x2a2e,0x2a4e,0x324d,0x2a0c,0x29eb,0x29eb,0x29ec,0x2a0c,0x224e,0x2a4e,0x2a6e,0x2a6f,0x2a6f,0x224f,0x222e,0x220d,0x220e,0x2a4e,0x2a4e,0x222d,0x2a2d,0x222d,0x220d,0x21cd,0x21ab,0x10c4,0x0042,0x6b8f,0xffff,0xf7df,0xffdf,0xdf5e,0xae5d,0x9ddc,0x9e1d,0xa63d,0xb67e,0xb69e,0xcf5f,0xd73f,0xd75e,0xdf7f,0xdf7f,0xe7bf,0xe7bf,0xdf7f,0xd75f,0xdf7f,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefbf,0xefdf,0xf7df,0xf7ff,0xf7df,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xffff,
0xad99,0x5354,0x63d7,0x6c38,0x7c9a,0x9d9e,0xae3e,0xbedf,0xcf5f,0xdfbf,0xe7df,0xefff,0xefff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7ff,0xadb8,0x2988,0x3167,0x2989,0x320b,0x3a2c,0x10e5,0x2169,0x3a2c,0x320c,0x322c,0x2a0b,0x31ea,0x2189,0x2168,0x1906,0x2147,0x1905,0x1927,0x298a,0x29ab,0x31ec,0x2a0d,0x2a2d,0x2a2d,0x2a0d,0x2a0c,0x2a0c,0x2a0c,0x2a0c,0x220d,0x2a2d,0x2a6e,0x226f,0x2a6f,0x2a6f,0x224e,0x224e,0x220e,0x2a0d,0x220d,0x2a2e,0x220d,0x222e,0x224e,0x220d,0x220d,0x21cd,0x1907,0x0862,0x4aab,0xf7df,0xf7df,0xffdf,0xef9f,0xb67d,0xa61d,0x8dbc,0xae9e,0xae5e,0xae7e,0xc71f,0xd73f,0xd77f,0xdf7f,0xe79f,0xe79f,0xdf9f,0xe7bf,0xdfbf,0xe7bf,0xe79f,0xe79f,0xefbf,0xefdf,0xefbf,0xefdf,0xefdf,0xefdf,0xefdf,0xf7ff,0xf7df,0xf7df,0xf7df,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7df,0xffff,0xa578,0x5bb6,0x84da,0x957c,0xa5fe,0xbebf,0xcf1f,0xcf3f,0xd75f,0xe7bf,0xe7df,0xe7df,0xefff,0xf7ff,0xffff,0xffff,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7ff,0xdf5e,0x424b,0x2146,0x29aa,0x29cb,0x322c,0x10e5,0x21a9,0x320b,0x324c,0x320c,0x3a2c,0x320b,0x29a9,0x2127,0x1906,0x2126,0x1105,0x2169,0x2989,0x29aa,0x29cb,0x29ec,0x2a2d,0x2a2d,0x2a0d,0x29ec,0x29ec,0x29ec,0x2a0d,0x2a2d,0x2a2e,0x222e,0x224f,0x2a6f,0x2a4f,0x2a6f,0x224f,0x2a4f,0x2a4e,0x222e,0x224f,0x222e,0x222e,0x224e,0x2a6f,0x220e,0x21ee,0x196a,0x10a3,0x2967,0xdf1d,0xffff,0xf7df,0xef9f,0xcefd,0xb67d,0x8dbc,0x95fd,0x9dfd,0xb69e,0xbebe,0xbefe,0xcf5f,0xd77f,0xd77f,0xd75f,0xdf9f,0xe7bf,0xefff,0xefdf,0xe79f,0xdf9f,0xdf7f,0xe7bf,0xe7bf,0xefdf,0xefbf,0xefdf,0xf7ff,0xefdf,0xefbf,0xefdf,0xf7ff,0xf7ff,0xefff,0xf7df,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7df,0xffdf,
0xbe5d,0x853e,0xa5df,0xae5f,0xb65f,0xbedf,0xcf1f,0xcf3f,0xd77f,0xe7bf,0xe7df,0xefdf,0xefff,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7ff,0xf7ff,0xadb7,0x2168,0x31cb,0x29eb,0x322c,0x1105,0x2a0b,0x322c,0x324d,0x324d,0x322c,0x29eb,0x2168,0x1906,0x2127,0x10c5,0x2128,0x2169,0x298a,0x29cb,0x29ec,0x29ec,0x2a0d,0x2a2d,0x2a0d,0x29ed,0x29cb,0x29cc,0x2a0d,0x2a0d,0x220d,0x2a2e,0x222f,0x224f,0x224f,0x226f,0x224f,0x2a4f,0x2a4f,0x222e,0x222e,0x224e,0x222e,0x2a4e,0x2a8f,0x2a2e,0x222f,0x21ab,0x10c4,0x08c4,0xbe19,0xffdf,0xf7bf,0xefbf,0xc6de,0xae3c,0xa63d,0x95dd,0x95fd,0xa63d,0xae5d,0xb67e,0xc6ff,0xd75f,0xcf5f,0xcf1e,0xd75f,0xefdf,0xf7df,0xefdf,0xe7df,0xe7bf,0xd77f,0xdf7f,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefbf,0xefdf,0xefdf,0xefdf,0xefbf,0xefff,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xffff,0xbe3c,0x84dc,0x9d9e,0x9dbf,0xa5ff,0xb67f,0xbebf,0xd73f,0xdf7f,0xdf7f,0xdf5f,0xdf7f,0xe79f,0xe7bf,0xefbf,0xefdf,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xefff,0xdf9e,0x426c,0x298a,0x320c,0x322c,0x18e5,0x29ea,0x322c,0x324d,0x326d,0x320c,0x29ea,0x2147,0x1906,0x18e5,0x1906,0x2149,0x298a,0x29ab,0x29ec,0x2a0c,0x2a0d,0x2a0d,0x2a0d,0x2a0c,0x29ed,0x29cc,0x29cc,0x29ec,0x2a0d,0x2a2e,0x2a4f,0x2a6f,0x226f,0x2a70,0x224f,0x2a70,0x2a70,0x224f,0x222e,0x2a2e,0x222e,0x222e,0x2a4f,0x224e,0x222d,0x220f,0x21cc,0x1927,0x0083,0x8473,0xffdf,0xf79f,0xf7bf,0xbebe,0xb69d,0xa65d,0x9e1d,0xa65e,0x9e1d,0xa63d,0xb67e,0xc6fe,0xc6fe,0xcf1f,0xcf3f,0xdf7f,0xe79f,0xe79f,0xefdf,0xefdf,0xe7bf,0xdf7f,0xe7bf,0xe7bf,0xefdf,0xf7ff,0xf7ff,0xefdf,0xefdf,0xefdf,0xefdf,0xefbf,0xefdf,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7ff,0xf7ff,0xffff,
0xb5fb,0x7459,0x84dc,0x8d1d,0x9d9d,0xa5be,0xa59e,0xc67f,0xd6ff,0xcedf,0xcedf,0xd6ff,0xd73f,0xdf5f,0xe77f,0xe79f,0xe79f,0xe7bf,0xefdf,0xefdf,0xefbf,0xefdf,0xefdf,0xf7df,0xf7df,0xefdf,0xefdf,0xefbf,0xdf9f,0x4aac,0x2169,0x3a4d,0x322b,0x18c5,0x29ca,0x320b,0x3a4d,0x3a2c,0x31eb,0x2989,0x1906,0x1906,0x10c5,0x2148,0x2169,0x21ca,0x29ec,0x320d,0x320c,0x2a0d,0x2a0d,0x29ec,0x21ec,0x29ed,0x29ed,0x21ac,0x21cb,0x29ec,0x2a2e,0x2a6f,0x224f,0x2a6f,0x2a90,0x2270,0x2a70,0x2250,0x222f,0x220f,0x222f,0x222e,0x222f,0x2a6e,0x226e,0x222d,0x222e,0x21ee,0x1968,0x08a3,0x530e,0xf7bf,0xf79f,0xefbf,0xd75f,0xbede,0xa63d,0xa63d,0x9e3d,0x95fd,0xa63d,0xae7e,0xb69e,0xbebe,0xbedf,0xcf3f,0xdf7f,0xe7bf,0xe7bf,0xdf9f,0xe7bf,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefff,0xefbf,0xefdf,0xefff,0xefdf,0xe7bf,0xe7bf,0xefdf,0xf7df,0xf7df,0xf7df,0xf7ff,0xf7df,0xf7df,0xf7ff,0xffff,0xadb9,0x6c18,0x7cba,0x8cdb,0x953d,0x953c,0x9d5d,0xbe1f,0xc67f,0xc69f,0xd6ff,0xd73f,0xdf5f,0xe77f,0xe77f,0xe79f,0xe79f,0xe79f,0xefbf,0xefbf,0xefdf,0xefdf,0xefdf,0xf7ff,0xf7df,0xefbf,0xe79f,0xe77f,0xd73f,0x3a0a,0x2189,0x3a8d,0x29a9,0x18e5,0x29eb,0x320c,0x3a6e,0x322c,0x29ca,0x1927,0x1906,0x18e5,0x2147,0x2989,0x2989,0x29ca,0x2a0c,0x320d,0x31ec,0x2a0d,0x2a0d,0x2a2d,0x2a0c,0x2a0d,0x29cd,0x29cc,0x29ec,0x29ec,0x2a4e,0x2a6f,0x224f,0x2270,0x2270,0x2a90,0x2a70,0x2270,0x2a50,0x2250,0x224f,0x226f,0x224f,0x228f,0x228f,0x226e,0x224f,0x21ef,0x1969,0x08a4,0x3a4b,0xdf5f,0xf7bf,0xefbf,0xe79f,0xbe9d,0x9e1d,0xae7e,0x9e1e,0x95fd,0xae7e,0xa65e,0xae7e,0xb69e,0xbede,0xcf1e,0xd75f,0xdf9f,0xdfbf,0xdfbf,0xd77f,0xe7bf,0xefff,0xefdf,0xefff,0xefdf,0xe7bf,0xe7bf,0xe7df,0xe7bf,0xe7bf,0xe79f,0xefbf,0xefff,0xf7df,0xf7df,0xf7df,0xf7df,0xf7df,0xf7ff,0xf7df,0xf7ff,
0xadba,0x6c38,0x7cba,0x8d1c,0x8d1c,0x8cdb,0x9d5d,0xa59e,0xbe3e,0xc69f,0xcebf,0xd71f,0xe79f,0xe79f,0xe77f,0xdf5f,0xe77f,0xefbf,0xe79f,0xe79f,0xefbf,0xefdf,0xefdf,0xefdf,0xefbf,0xefbf,0xdf7f,0xdf5f,0xcf1f,0x3a2c,0x29eb,0x42cf,0x1967,0x1905,0x320c,0x3a4e,0x3a6e,0x320b,0x2988,0x1906,0x18e5,0x1906,0x2968,0x31aa,0x298a,0x29cb,0x29eb,0x29ec,0x2a0d,0x322d,0x2a2d,0x2a0d,0x29ec,0x29ec,0x29ed,0x29ec,0x29cb,0x21ec,0x2a4f,0x2270,0x2a70,0x2a4f,0x2a70,0x2270,0x2270,0x2250,0x224f,0x2a70,0x2250,0x2270,0x224f,0x2a6f,0x226e,0x224e,0x224e,0x220f,0x21ab,0x10e4,0x21a8,0xcedd,0xffdf,0xf7bf,0xefbf,0xb69e,0xae7e,0xa67d,0x9e1e,0x9e1d,0xa67e,0xa65d,0xa65e,0xae9e,0xc71f,0xcf3e,0xd77f,0xcf3f,0xd77f,0xdf7f,0xe7bf,0xefdf,0xefdf,0xefdf,0xefff,0xefdf,0xefdf,0xefff,0xdfbf,0xe7bf,0xe79f,0xefdf,0xefdf,0xefff,0xf7df,0xf7df,0xf7df,0xf7ff,0xf7ff,0xf7df,0xf7df,0xffff,0xb5fa,0x6c59,0x7c9a,0x8d1c,0x8cfc,0x94fc,0x9d5d,0x9d5d,0xadde,0xc67f,0xcebf,0xd73f,0xdf7f,0xe79f,0xe79f,0xdf3f,0xe77f,0xe77f,0xe79f,0xef9f,0xefbf,0xefdf,0xefbf,0xe79f,0xe79f,0xdf7f,0xe79f,0xd73f,0xcf1f,0x7434,0x29ab,0x3a8e,0x1946,0x2127,0x322d,0x324d,0x322d,0x2189,0x1926,0x18e5,0x18c5,0x2148,0x2169,0x29cb,0x29cb,0x29cb,0x2a0c,0x29ec,0x2a0d,0x2a0d,0x2a0d,0x29ed,0x29cc,0x29cc,0x29cc,0x29aa,0x21ab,0x220d,0x2a70,0x2290,0x2a90,0x2a4f,0x2250,0x2250,0x2270,0x2250,0x2250,0x224f,0x224f,0x224f,0x222f,0x224f,0x224f,0x224e,0x2a8f,0x222f,0x19cd,0x1105,0x1105,0xa598,0xffff,0xf7bf,0xf7df,0xc6ff,0xae7e,0x9dfd,0x9e3d,0xa65e,0x95fc,0x9e1d,0xae5e,0xbeff,0xbede,0xc71f,0xcf5f,0xd77f,0xd75f,0xdf7f,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefdf,0xefff,0xe7df,0xe7df,0xefdf,0xefdf,0xf7ff,0xf7ff,0xf7df,0xefbf,0xf7df,0xf7ff,0xf7ff,0xf7df,0xf7df,0xf7ff,0xffff,
0xb5da,0x63f8,0x7c9a,0x8cfc,0x951d,0x9d7e,0xa59e,0xa57e,0xb5de,0xc65f,0xcebf,0xd73f,0xd73f,0xdf5f,0xdf3f,0xdf5f,0xdf5f,0xdf5f,0xe79f,0xe79f,0xefbf,0xefdf,0xe79f,0xe79f,0xe79f,0xdf5f,0xdf5f,0xdf5f,0xcf1f,0xc6bd,0x4aee,0x3a6e,0x1905,0x2989,0x320c,0x322c,0x29cb,0x2147,0x10e5,0x10c5,0x2127,0x2169,0x2189,0x31cb,0x29ec,0x29ec,0x2a2d,0x220c,0x2a0c,0x2a0d,0x29ec,0x29ec,0x29ab,0x29cc,0x29cb,0x218a,0x29ec,0x2a4f,0x2a6f,0x2a70,0x2270,0x222f,0x222f,0x2a70,0x2270,0x2250,0x2250,0x2250,0x2270,0x2270,0x224f,0x224f,0x224f,0x2a6f,0x226f,0x224f,0x220e,0x1127,0x10c4,0x8474,0xffff,0xf7bf,0xf7df,0xd75f,0xa63e,0x8ddd,0xa65e,0xa65e,0x9e3e,0x961d,0xa65e,0xb6be,0xbefe,0xc71f,0xbede,0xd77f,0xe7bf,0xefff,0xefbf,0xefdf,0xefff,0xefff,0xefff,0xefff,0xe7df,0xe7df,0xefdf,0xefdf,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7df,0xffff,0xadb9,0x63d7,0x7c7a,0x849b,0x84bb,0x9d5d,0xa5be,0xa59e,0xbe1f,0xc65f,0xcebf,0xd6ff,0xd73f,0xd6ff,0xd6ff,0xdf3f,0xdf3f,0xdf7f,0xe7bf,0xe7bf,0xefdf,0xefbf,0xefbf,0xefbf,0xefbf,0xefbf,0xe79f,0xdf5f,0xd75f,0xe7bf,0x9558,0x2a2d,0x18e5,0x21aa,0x3a4e,0x322c,0x2189,0x18e5,0x10a4,0x18e6,0x2989,0x2169,0x2969,0x2969,0x29cb,0x2a0d,0x2a0d,0x2a0c,0x2a0d,0x2a0c,0x29ec,0x29ec,0x29ab,0x29ac,0x218a,0x218a,0x2a0e,0x2a70,0x2a4f,0x2a6f,0x224f,0x222f,0x222e,0x2a4f,0x2a91,0x2270,0x2250,0x2250,0x2250,0x2250,0x222f,0x2a4f,0x224e,0x224e,0x224e,0x222e,0x222f,0x1948,0x10c4,0x5b2f,0xf7ff,0xf7df,0xf7df,0xdf5f,0x9e3e,0x961e,0xa65e,0x9e1e,0x9e1d,0x9e3d,0xa67e,0xa69e,0xbeff,0xbefe,0xcf3f,0xcf1e,0xdfbf,0xefff,0xefbf,0xefdf,0xefdf,0xefff,0xefff,0xe7df,0xe7df,0xefdf,0xefdf,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xffff,0xf7ff,0xf7ff,0xf7ff,0xffff,0xf7ff,0xffff,
0xad99,0x5bb6,0x7459,0x7c5a,0x7c7a,0x8cdb,0x953d,0xa59e,0xb5fe,0xc67f,0xcedf,0xd71f,0xd6ff,0xce7f,0xd6df,0xdf3f,0xdf5f,0xe77f,0xe77f,0xefdf,0xefdf,0xefbf,0xefbf,0xefdf,0xefbf,0xefdf,0xefdf,0xe79f,0xd73f,0xd73f,0xc6de,0x42cf,0x18e5,0x29eb,0x326e,0x2a2c,0x2168,0x18a4,0x18c4,0x2148,0x298b,0x216a,0x2127,0x2148,0x29ab,0x29ed,0x2a0d,0x2a0d,0x2a0c,0x31ed,0x29cb,0x29cc,0x29cc,0x218a,0x2169,0x21aa,0x222e,0x2a70,0x2a50,0x2a2f,0x220e,0x222e,0x2a4f,0x224f,0x2271,0x2a71,0x2271,0x2270,0x2250,0x2270,0x2a70,0x2a4f,0x222e,0x220e,0x224e,0x224f,0x224f,0x21ab,0x10c4,0x39ea,0xef7f,0xffdf,0xf7df,0xe79f,0xa65e,0xae5e,0x9e3e,0xa65e,0x9e1e,0xa67e,0xa67e,0xae9e,0xae9e,0xbeff,0xcf3f,0xd77f,0xdf9f,0xe7bf,0xefff,0xefff,0xefdf,0xefff,0xefdf,0xe7df,0xefdf,0xf7ff,0xefdf,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xffff,0xad99,0x5bb7,0x7439,0x7459,0x7c9a,0x84bb,0x951d,0x9d7e,0xa59e,0xbe3f,0xd71f,0xd71f,0xce9f,0xce9f,0xdeff,0xdf3f,0xdf7f,0xe77f,0xe79f,0xe7bf,0xe79f,0xe7bf,0xefdf,0xefdf,0xefbf,0xefbf,0xe7bf,0xe79f,0xdf7f,0xd73f,0xdf9f,0x7453,0x10c4,0x320c,0x322d,0x29a9,0x2126,0x18c4,0x1906,0x298a,0x29cc,0x298a,0x2106,0x2127,0x29aa,0x322d,0x322e,0x2a2e,0x2a0c,0x2a0d,0x29cb,0x29cb,0x29ab,0x2149,0x2169,0x21cc,0x224f,0x2a70,0x2a70,0x220e,0x21cd,0x220e,0x224f,0x2a71,0x2a71,0x2291,0x2a91,0x2a70,0x2a70,0x2270,0x2270,0x222f,0x222e,0x224e,0x222e,0x224f,0x2a70,0x21ee,0x10e5,0x2987,0xdf1e,0xffdf,0xf7df,0xefdf,0xb6de,0xae7e,0xa67e,0xa65f,0xa65e,0xae9f,0x961d,0xae7e,0xae7e,0xaebe,0xc71f,0xd77f,0xdfbf,0xe7bf,0xe7bf,0xefff,0xf7ff,0xefff,0xe7df,0xefdf,0xefff,0xefdf,0xefdf,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xffff,
0xa599,0x5bb7,0x6c18,0x747a,0x7c9b,0x84dc,0x953d,0x9d5d,0x9d5d,0xb61f,0xceff,0xcedf,0xce9f,0xcedf,0xdf3f,0xdf5f,0xdf5f,0xdf5f,0xe7bf,0xe79f,0xe79f,0xe7bf,0xe79f,0xe79f,0xef9f,0xe7bf,0xe7bf,0xe7bf,0xe7bf,0xe7bf,0xdf7f,0x9d98,0x1906,0x320c,0x320b,0x2147,0x10a4,0x18e5,0x2149,0x29cc,0x29ec,0x2128,0x18e5,0x2148,0x21aa,0x2a0d,0x2a0e,0x2a2e,0x2a0c,0x2a2d,0x29ec,0x29aa,0x2149,0x2148,0x218a,0x2a2e,0x224f,0x2a91,0x2a4f,0x21ec,0x21cc,0x21ed,0x2250,0x2a91,0x2271,0x2271,0x2a71,0x2250,0x224f,0x2270,0x2a70,0x224f,0x222e,0x220d,0x222e,0x2a4f,0x224f,0x2a50,0x1927,0x10c4,0xc67b,0xffff,0xf7df,0xf7ff,0xcf1f,0xb6be,0xae9e,0xa65e,0xaebf,0xa65e,0xa67e,0xa63d,0xae7e,0xb6be,0xc71f,0xcf3e,0xd79f,0xdfbf,0xe7bf,0xefdf,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xefdf,0xefdf,0xefff,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xffdf,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xf7df,0xffff,0xa579,0x5355,0x63f7,0x745a,0x7c9b,0x8cfd,0x9d5e,0x9d3d,0x9d5d,0xbe5f,0xc69f,0xc67f,0xcebe,0xd73f,0xd73f,0xdf3f,0xd73f,0xdf5f,0xe79f,0xe79f,0xefdf,0xe7bf,0xe79f,0xe79f,0xe77f,0xe77f,0xe79f,0xe7bf,0xe7bf,0xdf7f,0xd77f,0xc6dd,0x3a0a,0x29eb,0x21ca,0x1906,0x10a4,0x2106,0x29ab,0x31ed,0x29ab,0x1906,0x18c5,0x2148,0x29ab,0x29ed,0x2a0d,0x2a2e,0x2a0c,0x220d,0x29cb,0x2189,0x2148,0x2148,0x29ab,0x2a4f,0x2a50,0x2290,0x220e,0x29cc,0x21cb,0x2a2e,0x2250,0x2291,0x2291,0x2251,0x2271,0x2a71,0x2270,0x2270,0x2a70,0x224f,0x21ec,0x21cc,0x220d,0x222e,0x224e,0x2250,0x21ab,0x0062,0xa576,0xffff,0xf7df,0xf7ff,0xcf3f,0xb6be,0xb69e,0xae9e,0xae9e,0x9e3e,0xae7e,0xa67e,0xae9e,0xb6df,0xc71f,0xcf5f,0xd75f,0xdf9f,0xdf9f,0xefdf,0xf7df,0xf7df,0xf7ff,0xf7ff,0xefff,0xefdf,0xefff,0xf7ff,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7df,0xf7ff,0xffff,0xf7ff,0xf7df,0xffff,
0xa578,0x4b34,0x63d7,0x6c19,0x747a,0x8d1d,0x953d,0x953d,0xa59e,0xb61f,0xbe1f,0xc67f,0xcedf,0xd71f,0xd6ff,0xd71f,0xdf5f,0xe79f,0xe77f,0xe7bf,0xefbf,0xe7bf,0xefbf,0xe7bf,0xe79f,0xe77f,0xe79f,0xe79f,0xe7bf,0xdf7f,0xd75f,0xe7bf,0x6bd1,0x29aa,0x2189,0x10e5,0x10c4,0x2928,0x320e,0x2a0d,0x2169,0x10c4,0x18e5,0x2968,0x29cb,0x2a0e,0x320e,0x2a0d,0x29cc,0x2a0c,0x29cb,0x2148,0x1928,0x2169,0x2a0d,0x2a70,0x2a50,0x2a4f,0x2a0e,0x29ac,0x21ac,0x222e,0x2a70,0x2271,0x2271,0x2292,0x2292,0x2a91,0x2250,0x2250,0x2270,0x224f,0x2a0d,0x21ed,0x21ec,0x222e,0x2a90,0x226f,0x220e,0x08c5,0x8c93,0xffff,0xf7df,0xffdf,0xdf9f,0xb6be,0xae7e,0xae9e,0xa65e,0xb6be,0xb6be,0xa65e,0xae9f,0xb6df,0xbf1f,0xcf5f,0xc71e,0xd77f,0xdfbf,0xe7bf,0xefdf,0xefff,0xefdf,0xf7df,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xffdf,0xf7df,0xffff,0xffff,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xa557,0x4313,0x63f7,0x6c19,0x7459,0x84dc,0x951d,0x9d7e,0xaddf,0xaddf,0xb5df,0xce9f,0xd6ff,0xcedf,0xcebf,0xd6ff,0xe77f,0xe79f,0xe77f,0xe7bf,0xe7bf,0xe7bf,0xe7bf,0xe79f,0xe79f,0xe7bf,0xe7bf,0xe7bf,0xe79f,0xd75f,0xd77f,0xe7bf,0x8cb5,0x2189,0x2147,0x18e5,0x1905,0x298a,0x322e,0x2a2d,0x2147,0x10a3,0x1906,0x298a,0x29cc,0x2a0d,0x320d,0x2a0d,0x29aa,0x21aa,0x298a,0x2127,0x2169,0x29cc,0x2a0e,0x3250,0x2a2f,0x29ee,0x21ab,0x218a,0x29cc,0x220e,0x2a70,0x2270,0x2250,0x2271,0x2a92,0x2a71,0x2a50,0x2270,0x2250,0x2a2e,0x224f,0x220d,0x21ec,0x222e,0x2a6f,0x224f,0x222e,0x1129,0x6baf,0xffff,0xf7df,0xffff,0xe7bf,0xb69f,0xae9e,0xae9f,0xa65e,0xbede,0xbefe,0xb6bf,0xa67f,0xa65e,0xbeff,0xcf5f,0xcf3e,0xd77f,0xdf9f,0xe7bf,0xe7bf,0xefdf,0xf7ff,0xefdf,0xefdf,0xf7ff,0xffff,0xffff,0xffff,0xffff,0xf7ff,0xf7df,0xf7ff,0xf7ff,0xf7ff,0xefdf,0xefdf,0xefff,0xefff,0xf7ff,
0xa558,0x42f2,0x63d7,0x6c18,0x7459,0x84bb,0x8cfd,0xa5bf,0xadfe,0xa59e,0xb5fe,0xcebf,0xcedf,0xcebf,0xcedf,0xd6ff,0xdf7f,0xdf5f,0xe79f,0xefdf,0xe7bf,0xe79f,0xe7bf,0xe79f,0xefbf,0xefdf,0xefdf,0xefbf,0xe77f,0xdf5f,0xdf7f,0xdf7f,0x9d78,0x2168,0x1926,0x18e4,0x2106,0x31ec,0x2a4e,0x29ab,0x2106,0x10a3,0x2127,0x31ab,0x29ed,0x29ee,0x29ed,0x29ed,0x2989,0x2969,0x2989,0x2148,0x218a,0x2a0d,0x2a2f,0x324f,0x2a4f,0x29ed,0x29ab,0x218a,0x220e,0x222f,0x2a71,0x2a70,0x2a50,0x2a50,0x2271,0x2270,0x2250,0x2270,0x2a70,0x220d,0x222e,0x222e,0x220e,0x222e,0x2270,0x2290,0x2250,0x19cd,0x4a8b,0xefbf,0xf7df,0xffdf,0xefbf,0xbedf,0xb69f,0xae9e,0xaebe,0xbede,0xb6be,0xbedf,0xbedf,0xae7f,0xae9f,0xbeff,0xc73f,0xd79f,0xdf9f,0xdf9f,0xe7df,0xefdf,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xffff,0xffff,0xffff,0xf7ff,0xf7ff,0xf7df,0xefff,0xf7df,0xefbf,0xefff,0xf7ff,0xd73e,0xadf9,0xbe19,0xa558,0x42f2,0x5bb6,0x63f7,0x7459,0x7c9b,0x8cdc,0x9d7e,0xa5be,0xa57e,0xb63f,0xc69f,0xcedf,0xcebf,0xcedf,0xd71f,0xdf7f,0xdf7f,0xe7bf,0xefbf,0xefdf,0xefbf,0xe7bf,0xefbf,0xefdf,0xefdf,0xefdf,0xe79f,0xe79f,0xdf7f,0xd75f,0xd73f,0xbe5c,0x31ea,0x1926,0x1905,0x2128,0x320e,0x326f,0x29aa,0x18c4,0x10c4,0x2969,0x320d,0x320d,0x29ed,0x31ec,0x29cb,0x2168,0x2968,0x2989,0x298a,0x29cc,0x2a4f,0x2a50,0x2a2e,0x2a0e,0x29ec,0x29ab,0x21ab,0x220e,0x224f,0x2a50,0x2250,0x2a50,0x2a50,0x2270,0x2270,0x2a71,0x224f,0x2a2e,0x220d,0x220d,0x2a4f,0x222f,0x222f,0x224f,0x2290,0x2270,0x222f,0x29ca,0xd6dc,0xf7ff,0xf7df,0xf7ff,0xdf7f,0xb6bf,0x963e,0xb6be,0xb6df,0xbeff,0xc71f,0xbede,0xb6bf,0xa69e,0xaebe,0xc73f,0xd79f,0xdfbf,0xdfbf,0xe7df,0xefdf,0xf7ff,0xf7ff,0xf7ff,0xffff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7df,0xf7ff,0xefdf,0xe7bf,0xb619,0x6b8f,0x31e9,0x0883,0x632d,
0x9d57,0x4312,0x5395,0x63f7,0x7439,0x7c9b,0x84dc,0x953d,0x9d5e,0xa59e,0xb61f,0xbe5f,0xcebf,0xcebf,0xd6ff,0xdf3f,0xdf5f,0xe7bf,0xe7bf,0xe79f,0xefdf,0xefdf,0xe7bf,0xef9f,0xefbf,0xefbf,0xe7bf,0xdf7f,0xd75f,0xdf7f,0xd75f,0xd75f,0xdf5f,0x4acd,0x1926,0x1905,0x2989,0x324f,0x320d,0x2148,0x10a3,0x1905,0x298a,0x322e,0x324e,0x29ec,0x29aa,0x2989,0x2147,0x2968,0x298a,0x29ab,0x2a0d,0x2a2f,0x2a70,0x2a4f,0x29ed,0x29ab,0x29aa,0x29cb,0x222e,0x2a70,0x2a50,0x2a70,0x2a70,0x2a50,0x2a91,0x2a71,0x2270,0x2a2f,0x2a0e,0x2a0d,0x21ed,0x222e,0x224f,0x222f,0x222e,0x2270,0x226f,0x2270,0x21cd,0xbe39,0xffff,0xffdf,0xffdf,0xe79f,0xb6be,0x95fd,0xa63e,0xb69f,0xbeff,0xbf1e,0xbefe,0xb6df,0xaebe,0xb6ff,0xbeff,0xc75f,0xcf7f,0xdf9f,0xe7df,0xefdf,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xf7ff,0xefdf,0xefdf,0xf7ff,0xefff,0xefdf,0xd71e,0x9d57,0x530d,0x2147,0x10c5,0x08a4,0x0863,0x6b6e,0x9d37,0x42f2,0x5394,0x63f7,0x6c38,0x7c7a,0x84fc,0x953d,0x953d,0xa5be,0xadbe,0xbe5f,0xcebf,0xcebf,0xd6ff,0xdf3f,0xe77f,0xe77f,0xe77f,0xe79f,0xe7bf,0xdf7f,0xe7bf,0xe79f,0xefbf,0xe79f,0xe79f,0xdf7f,0xdf5f,0xdf7f,0xd73f,0xdf7f,0xefff,0x8473,0x18e5,0x2126,0x29cb,0x328f,0x29ab,0x18e5,0x1083,0x2128,0x29ab,0x2a0c,0x2a2d,0x29ec,0x298a,0x2148,0x2106,0x2168,0x29cb,0x29cc,0x2a2e,0x2a4f,0x2a50,0x2a0e,0x21cb,0x218a,0x29ab,0x29ec,0x2270,0x224f,0x2250,0x2250,0x222f,0x2a50,0x2271,0x2a50,0x2a50,0x2a2f,0x21ed,0x21ec,0x21ec,0x220e,0x224f,0x222e,0x222e,0x224f,0x2270,0x2250,0x19ee,0x9d57,0xffff,0xf7bf,0xffbf,0xef9f,0xb67e,0xae7e,0x9e3e,0x95dd,0xae7e,0xb6be,0xb6df,0xae7e,0xb6bf,0xbf1f,0xb6df,0xb6df,0xc73f,0xcf7f,0xdfbf,0xe7df,0xe7df,0xe7df,0xefdf,0xefdf,0xefbf,0xefdf,0xf7ff,0xefbf,0xc6bc,0x7412,0x320a,0x1967,0x1947,0x29c9,0x2188,0x1907,0x10c6,0x6b90,
0x9d37,0x3ad1,0x5373,0x5bd6,0x63d7,0x7c7b,0x84fd,0x8cfd,0x9d5e,0xa5be,0xa59e,0xbe3f,0xc67f,0xcebf,0xd6ff,0xd73e,0xdf5f,0xdf5f,0xdf3f,0xe77f,0xdf7f,0xdf7f,0xdf7f,0xe7bf,0xe79f,0xe79f,0xdf7f,0xd73f,0xdf5f,0xd75f,0xdf7f,0xdf9f,0xe7bf,0xb5f9,0x2106,0x2126,0x31ec,0x326e,0x2188,0x08a3,0x10a4,0x2989,0x29ec,0x2a0c,0x29cc,0x29ec,0x2189,0x2147,0x2126,0x2189,0x2a0c,0x29ed,0x2a2f,0x2a4e,0x2a4f,0x2a0d,0x2189,0x218a,0x29cc,0x220e,0x2a70,0x2270,0x2270,0x2270,0x21ef,0x222f,0x2250,0x2a4f,0x222f,0x222f,0x21ed,0x21ed,0x21ed,0x21ed,0x220e,0x220f,0x222e,0x222f,0x2270,0x2270,0x11ee,0x7414,0xffff,0xf79f,0xffbf,0xefbf,0xb69e,0xaebe,0xa65e,0x95fe,0x9e1d,0xa63e,0xae7e,0xae7e,0xb69f,0xbefe,0xbeff,0xb69f,0xb6bf,0xcf5f,0xdfbf,0xe7df,0xd79f,0xd79f,0xe79f,0xefdf,0xefff,0xdf5e,0xa597,0x5b6f,0x2189,0x1107,0x2189,0x29ea,0x29ca,0x29ea,0x29ea,0x1928,0x1928,0x73d1,0x9d57,0x3ad1,0x4b53,0x5bb6,0x63d8,0x743a,0x7cbc,0x84dc,0x9d7e,0xa59e,0xa59e,0xadde,0xbe3e,0xce9f,0xd6fe,0xd73f,0xdf3f,0xdf3f,0xe77f,0xe77f,0xe77f,0xdf7f,0xe7bf,0xe7bf,0xe79f,0xe7bf,0xe79f,0xe77f,0xdf7f,0xd75f,0xdf9f,0xdf7f,0xd75f,0xdf7f,0x426b,0x18e6,0x320d,0x324d,0x2146,0x0882,0x1926,0x29ca,0x29ec,0x29ec,0x29ec,0x29cb,0x2169,0x2127,0x2147,0x29aa,0x2a2d,0x2a0d,0x2a2e,0x222d,0x2a0d,0x29cc,0x2169,0x21aa,0x21ed,0x224f,0x2270,0x2270,0x2270,0x2250,0x2250,0x2230,0x2270,0x224f,0x222e,0x220d,0x21ed,0x21ed,0x1a2e,0x21ed,0x222e,0x222f,0x220e,0x222f,0x224f,0x2270,0x1a4f,0x42b0,0xe77e,0xffdf,0xffdf,0xf7df,0xcf3f,0xbeff,0xae7e,0x9e3e,0x9e3e,0x9e3e,0x9e1e,0xae7f,0xb6df,0xb6de,0xc6ff,0xc71f,0xb6be,0xbeff,0xd77f,0xefdf,0xe7df,0xe7df,0xefff,0xcedc,0x7432,0x3a6b,0x21c9,0x1989,0x1949,0x2189,0x29ca,0x2a0b,0x2a0b,0x2a0b,0x29eb,0x1949,0x1128,0x7c13,
0x9d57,0x3ab0,0x5374,0x63b6,0x63d8,0x6c19,0x747a,0x84bb,0x8d3d,0xa59e,0x9d5d,0xadde,0xb61f,0xc69f,0xd71f,0xd6ff,0xdf3f,0xdf5f,0xe79f,0xe79f,0xdf7f,0xe79f,0xefdf,0xe7bf,0xe7bf,0xe7bf,0xe79f,0xe79f,0xdf7f,0xdf7f,0xd75f,0xceff,0xd73f,0xefff,0x7c73,0x18e6,0x324e,0x322d,0x18e4,0x1083,0x2169,0x29ec,0x29ed,0x29ec,0x29ab,0x2169,0x2147,0x2127,0x2969,0x29cb,0x29ed,0x21ed,0x2a2d,0x2a4f,0x29ed,0x218a,0x2168,0x21ab,0x220e,0x2a70,0x2270,0x2270,0x2250,0x2250,0x2250,0x2250,0x2270,0x224f,0x220e,0x21ec,0x21cb,0x21cc,0x21cd,0x220d,0x1a0d,0x222e,0x220e,0x220e,0x220e,0x222f,0x2250,0x19cd,0xb5f9,0xffff,0xf7df,0xffdf,0xcf1f,0xb6be,0xb6be,0xaebe,0xa65e,0x9e3e,0x963e,0xa67e,0xaebf,0xb6be,0xbede,0xbf1e,0xbeff,0xc71f,0xd77f,0xefdf,0xf7ff,0xd6fc,0x8451,0x31c8,0x1928,0x29ea,0x326c,0x2a6c,0x21cb,0x21cb,0x21eb,0x2a4c,0x2a0b,0x2a2c,0x2a2c,0x2169,0x1129,0x73f3,0x9d37,0x32b0,0x4b32,0x5374,0x63f7,0x6c19,0x6c39,0x7c9b,0x8cfc,0x9d5d,0x953d,0xa57e,0xb61f,0xcedf,0xcede,0xd6ff,0xd71f,0xdf5f,0xdf7f,0xe79f,0xe79f,0xe7bf,0xe79f,0xe79f,0xe7bf,0xe7bf,0xe7bf,0xdf7f,0xdf7f,0xd73f,0xceff,0xceff,0xd75f,0xdf9f,0xb65a,0x2147,0x326f,0x29ec,0x1083,0x18c4,0x29ab,0x29ed,0x29ec,0x29eb,0x29aa,0x2168,0x1906,0x2148,0x29ab,0x220c,0x29ec,0x29cc,0x2a0d,0x2a2f,0x29cc,0x2169,0x2189,0x21ac,0x222f,0x2250,0x2270,0x2271,0x2271,0x2250,0x2250,0x2250,0x2250,0x224f,0x220e,0x220d,0x21ed,0x19ed,0x21ed,0x220d,0x21ed,0x21ee,0x220e,0x1a0e,0x220e,0x222f,0x224f,0x19ee,0x63b2,0xffdf,0xf7df,0xffbf,0xdf7f,0xbede,0xb69e,0xae9e,0xae9f,0xa67f,0xa69e,0xb6be,0xa65e,0xa65e,0xb6be,0xc71e,0xbf1f,0xbf1f,0xdf7f,0xdf5e,0x8c72,0x2146,0x0883,0x1928,0x21cb,0x324d,0x328d,0x328c,0x220c,0x21ab,0x21ec,0x2a6d,0x2a0c,0x2a6d,0x2a4c,0x218a,0x194a,0x7413,
0x9d57,0x3ab0,0x4311,0x4b33,0x5bb6,0x6c39,0x747b,0x7c7b,0x84dc,0x955e,0x957e,0x951d,0xadde,0xcebf,0xd6ff,0xd6ff,0xd71f,0xdf5f,0xe79f,0xdf7f,0xefdf,0xe7bf,0xe77f,0xe79f,0xe7bf,0xe7bf,0xe7bf,0xdf9f,0xd73f,0xceff,0xc6df,0xd73f,0xd75f,0xd73f,0xc6dd,0x31c9,0x326e,0x2148,0x0862,0x1926,0x29cc,0x29cc,0x29ec,0x29cb,0x2969,0x1906,0x2127,0x2169,0x29cb,0x29ed,0x29cc,0x2a0d,0x2a0d,0x2a4f,0x29ab,0x2149,0x218a,0x29ed,0x2a70,0x2271,0x2270,0x2270,0x2271,0x2250,0x2a50,0x222f,0x2250,0x222e,0x220e,0x1a0e,0x19ec,0x21ed,0x1a0d,0x222e,0x21ee,0x220e,0x222f,0x21ed,0x222f,0x1a2e,0x222f,0x1a2f,0x222e,0xce9b,0xffff,0xf7df,0xe79f,0xb6be,0xc6ff,0xb6be,0xae9e,0xaebe,0xb6de,0xbf1f,0xaebe,0xae9e,0xa67e,0xae9e,0xc73f,0xc71f,0xdf9f,0xae5b,0x10c5,0x0883,0x1107,0x21aa,0x2a0c,0x2a4c,0x3aad,0x3ace,0x2a2c,0x218b,0x21cc,0x324d,0x324d,0x324d,0x324d,0x21ab,0x1129,0x7c13,0x9d57,0x328f,0x4311,0x4b33,0x5b96,0x63d7,0x745a,0x7cbb,0x84dc,0x955d,0x955d,0x953d,0xadbe,0xbe3e,0xd71f,0xdf3f,0xd73f,0xdf5f,0xdf7f,0xe7bf,0xe7bf,0xdf5f,0xe79f,0xe79f,0xe79f,0xefbf,0xe7bf,0xdf7f,0xcf1f,0xceff,0xcf1f,0xd73f,0xcf1f,0xd73f,0xdf9f,0x530e,0x29ec,0x1905,0x1082,0x2168,0x29cc,0x29cc,0x29aa,0x29aa,0x2148,0x1906,0x2148,0x29aa,0x29ec,0x29ed,0x29cc,0x29cb,0x21cb,0x2a0d,0x21aa,0x2168,0x21cb,0x2a2f,0x2250,0x2271,0x2270,0x2250,0x2270,0x2250,0x222f,0x222f,0x222f,0x222e,0x21ed,0x21ed,0x19ed,0x21cd,0x21ed,0x220d,0x220e,0x222f,0x222f,0x21ed,0x220e,0x1a2e,0x224f,0x2270,0x19cd,0x8494,0xffff,0xf7df,0xefbf,0xb69e,0xbefe,0xb6de,0xb69e,0xbede,0xbefe,0xbefe,0xb6df,0xb6de,0xb6ff,0xb6df,0xaebe,0xb6bf,0xcf5f,0xcf1e,0x21c9,0x08a3,0x1948,0x21ab,0x21ec,0x2a4c,0x3a8c,0x32cd,0x2a4c,0x21ab,0x21ab,0x2a2c,0x324d,0x322d,0x324d,0x21cb,0x1109,0x73f2,
0x9d57,0x328f,0x4312,0x5353,0x5b96,0x5b96,0x63d7,0x7439,0x84dc,0x955e,0x8d3d,0x9d7e,0xa59e,0xb61f,0xcedf,0xdf5f,0xdf7f,0xdf7f,0xe79f,0xe79f,0xdf5f,0xe79f,0xe79f,0xe79f,0xe7bf,0xe79f,0xdf5f,0xd73f,0xcf1f,0xceff,0xd71f,0xcf1f,0xd75f,0xd75f,0xdf9f,0x6bf2,0x29cc,0x10a3,0x10c4,0x29aa,0x29cc,0x29ab,0x2189,0x2989,0x2127,0x1927,0x2169,0x29cb,0x29ed,0x29ed,0x29ec,0x21ab,0x21cb,0x21cc,0x2189,0x298a,0x29ed,0x220e,0x2a70,0x2a70,0x2250,0x2270,0x2270,0x2270,0x224f,0x222f,0x222f,0x220e,0x21ed,0x21ed,0x21ed,0x220e,0x21ee,0x220e,0x19ee,0x220e,0x222f,0x21ed,0x220e,0x224f,0x224f,0x222f,0x1a2f,0x3a8f,0xef7e,0xf7df,0xf7df,0xcf3e,0xae9e,0x9e3d,0xa67e,0xb6be,0xc71f,0xbf1f,0xaebe,0xb6df,0xc6df,0xd75f,0xbeff,0xa65e,0xa69e,0xcf3f,0x3229,0x08c4,0x2189,0x21ec,0x2a0c,0x324d,0x328d,0x3aad,0x32ad,0x21ec,0x21ab,0x29ec,0x322c,0x324d,0x324d,0x29eb,0x1129,0x73f2,0x9d57,0x32b0,0x4311,0x4b53,0x5bb6,0x5bb7,0x63d7,0x6bf8,0x7c7a,0x8d1d,0x8d1d,0x9d7e,0x9d7e,0xb61e,0xceff,0xdf5f,0xdf7f,0xe79f,0xefdf,0xdf5f,0xdf7f,0xe7bf,0xe7bf,0xe7bf,0xe7bf,0xe79f,0xd73f,0xd73f,0xceff,0xcf1f,0xcf1f,0xd75f,0xdf7f,0xdf5f,0xe7bf,0x7453,0x2169,0x0883,0x1946,0x29cb,0x29cb,0x298a,0x2989,0x2968,0x2147,0x2148,0x298a,0x29ec,0x29ec,0x29ec,0x29cc,0x21ab,0x21cb,0x21ab,0x298a,0x29cb,0x29cc,0x224f,0x2270,0x2250,0x222f,0x224f,0x2250,0x2250,0x224f,0x222e,0x220e,0x220e,0x220e,0x21ed,0x21ed,0x21ed,0x19ed,0x220e,0x220e,0x220e,0x21ed,0x21ee,0x220f,0x1a2f,0x1a2f,0x224f,0x2270,0x19ed,0xadb8,0xffff,0xf7df,0xdf9f,0xb6be,0x9e3d,0xaebe,0xb6df,0xbedf,0xbedf,0xbefe,0xbf1e,0xc71f,0xc73f,0xbeff,0xbefe,0xb6df,0xcf5f,0x4acc,0x08e6,0x218a,0x220c,0x220c,0x2a4d,0x326d,0x328d,0x32ad,0x220c,0x218b,0x29ec,0x2a2c,0x324d,0x326d,0x2a2c,0x114a,0x73f3,
0x9d37,0x32b1,0x42f0,0x4b33,0x5395,0x5bd7,0x5bd7,0x63f8,0x7c7b,0x84bb,0x8cfc,0x8d1d,0x953d,0xb5ff,0xc6df,0xdf7f,0xdf5f,0xe79f,0xe77f,0xdf7f,0xe7bf,0xe7bf,0xe7bf,0xe7bf,0xe7bf,0xdf5f,0xd75f,0xcf1f,0xcedf,0xc6df,0xcedf,0xdf7f,0xdf9f,0xdf7f,0xdf9f,0x8cf7,0x1926,0x1083,0x2969,0x29cc,0x29cb,0x218a,0x2949,0x2147,0x2147,0x296a,0x29aa,0x29ec,0x29ec,0x29cb,0x29eb,0x29ab,0x29cb,0x21aa,0x298a,0x21cc,0x222e,0x2270,0x2a50,0x2270,0x2270,0x2270,0x2270,0x2250,0x224f,0x222f,0x220e,0x220e,0x21ed,0x21cc,0x21cd,0x21cd,0x21ed,0x220e,0x21ee,0x21ee,0x21ee,0x220e,0x222e,0x222f,0x1a2f,0x2250,0x224f,0x19ee,0x5b72,0xffdf,0xf7df,0xefbf,0xbede,0xa67e,0xb6bf,0xbeff,0xae7e,0xa67e,0xae9e,0xc71f,0xcf5f,0xc71e,0xb6be,0xb6df,0xb6bf,0xc73f,0x532d,0x1108,0x21cc,0x21ec,0x220c,0x2a4d,0x2a4d,0x326c,0x328d,0x2a2c,0x21ab,0x21cb,0x2a2d,0x324d,0x2a2c,0x29eb,0x196a,0x73f3,0x9d36,0x32b1,0x42f0,0x4b32,0x5375,0x5bb7,0x5bb6,0x63b7,0x7c5a,0x7c9b,0x8cfc,0x8cfc,0x8cdc,0xa5bf,0xcedf,0xdf5f,0xdf7f,0xdf5f,0xd73f,0xdf5f,0xdf7f,0xe79f,0xe79f,0xe7bf,0xe77f,0xdf5f,0xd73f,0xcedf,0xc6bf,0xc69f,0xceff,0xd75f,0xdf7f,0xdf7f,0xdf9f,0xa5d9,0x10e4,0x10c3,0x29aa,0x29cc,0x29ab,0x2969,0x2168,0x2147,0x2168,0x298a,0x29cc,0x29cb,0x29ab,0x29ab,0x29aa,0x298a,0x29ab,0x21cb,0x29aa,0x21cc,0x2a4f,0x224f,0x2270,0x2a70,0x2250,0x2250,0x224f,0x224f,0x222f,0x222f,0x21ed,0x21cd,0x21ed,0x21ec,0x21cc,0x21cd,0x220d,0x222e,0x220e,0x220f,0x222f,0x220e,0x19cd,0x220e,0x220e,0x1a2f,0x1a2e,0x220f,0x21ed,0xce9b,0xf7df,0xefbf,0xc73e,0xae7e,0xbedf,0xbede,0xae9e,0xa67e,0x9e3e,0xb69e,0xbeff,0xc6ff,0xc71f,0xbefe,0xb6bf,0xc71f,0x42ac,0x194a,0x21cc,0x220c,0x220d,0x2a0c,0x326d,0x2a6d,0x328d,0x2a4c,0x218b,0x218b,0x2a0c,0x326e,0x324d,0x29ec,0x198b,0x73d2,
0x9516,0x3290,0x42f1,0x4b32,0x5375,0x5b96,0x5374,0x63b7,0x7419,0x7c9b,0x8d1d,0x8cdc,0x8d1d,0xa59e,0xc6bf,0xd73f,0xdf7f,0xd73f,0xd73f,0xdf7f,0xdf7f,0xdf5f,0xdf7f,0xe77f,0xe77f,0xdf5f,0xcf1f,0xc6bf,0xbe7f,0xc6bf,0xcf1f,0xcf3f,0xdf5f,0xdf7f,0xe79f,0xb63a,0x10c4,0x1906,0x29cb,0x29cc,0x298a,0x2969,0x2148,0x2147,0x2989,0x29ab,0x29cc,0x29cb,0x29ab,0x298a,0x29aa,0x29ab,0x298b,0x29cb,0x29ab,0x29cc,0x2a2e,0x222f,0x224f,0x224f,0x224f,0x2270,0x224f,0x222f,0x220e,0x21ed,0x21cc,0x21cc,0x21cd,0x21ec,0x21cc,0x21ed,0x220d,0x220d,0x21cd,0x220e,0x1a0e,0x220e,0x19cd,0x19cd,0x21ed,0x220e,0x2250,0x1a2f,0x19ad,0x7c54,0xffff,0xf7bf,0xcf3f,0xb6de,0xbede,0xbede,0xbedf,0xa67d,0xb6bd,0xc6fe,0xae9e,0xa65e,0xbedf,0xc71f,0xbf1f,0xbebe,0x320b,0x216a,0x21ec,0x220c,0x220c,0x21ec,0x2a2c,0x2a6d,0x328e,0x32ae,0x21eb,0x218b,0x29ec,0x326d,0x324d,0x2a0c,0x19ab,0x73d2,0x9d37,0x2a8f,0x42f1,0x4b32,0x5395,0x5375,0x5354,0x5bb6,0x6c18,0x7c9b,0x84fc,0x84dc,0x955d,0xadff,0xbe7f,0xd71f,0xd71f,0xdf3f,0xdf3f,0xdf5f,0xdf5f,0xdf5f,0xe79f,0xdf7f,0xdf5f,0xd73f,0xcedf,0xc69f,0xbe7f,0xc6df,0xceff,0xcf1f,0xd73f,0xdf5f,0xe79f,0xbe5b,0x1905,0x2168,0x31cc,0x29cc,0x298a,0x2989,0x2148,0x2148,0x29ab,0x29ec,0x29ec,0x29ab,0x29cb,0x218a,0x298a,0x29ab,0x298a,0x29cc,0x29cb,0x29cc,0x220e,0x2a50,0x2a50,0x2250,0x2270,0x2a70,0x2a70,0x2270,0x220f,0x21ed,0x21cc,0x21cc,0x21ed,0x21cd,0x19ac,0x21cd,0x21ed,0x21ed,0x21cd,0x21ee,0x220e,0x21ed,0x21ed,0x21ee,0x19cd,0x19ed,0x2250,0x1a50,0x19ce,0x42af,0xef7e,0xf7bf,0xdf5f,0xcf5f,0xc71f,0xbedf,0xbebe,0xbedf,0xb6bf,0xc71f,0xc6ff,0xbebe,0xae5f,0xa67e,0xbf1f,0xae9d,0x2a0c,0x21ab,0x220d,0x21ec,0x220c,0x21cc,0x2a2d,0x2a2d,0x3a8d,0x328d,0x2a2c,0x218b,0x29cc,0x2a2c,0x326d,0x326d,0x19ab,0x73d2,
0x9d16,0x328f,0x42f1,0x4312,0x4b74,0x5374,0x4b34,0x5374,0x63d7,0x7c9b,0x7cbb,0x84dc,0x9d7e,0xadff,0xbe5f,0xcedf,0xcedf,0xcedf,0xd71f,0xdf3f,0xdf3f,0xdf7f,0xdf7f,0xdf7f,0xdf5f,0xcf1f,0xc6bf,0xbe7f,0xc69f,0xc6df,0xcedf,0xceff,0xcf1f,0xcf1f,0xdf5f,0xc69c,0x2146,0x2989,0x29aa,0x29cb,0x29aa,0x2168,0x2148,0x2969,0x29cb,0x29cb,0x29eb,0x29aa,0x29aa,0x29aa,0x29ca,0x29ab,0x29ab,0x29cc,0x21ab,0x29ed,0x2a0e,0x222e,0x2a4f,0x224f,0x2270,0x2290,0x2230,0x2250,0x222f,0x220d,0x21cc,0x21cc,0x21ed,0x21ed,0x21cc,0x19cd,0x21ee,0x220e,0x21cd,0x21ed,0x19cd,0x21cd,0x21cd,0x220e,0x19ed,0x1a0e,0x1a2f,0x2270,0x222f,0x19ac,0xb5b8,0xffff,0xdf7f,0xc71f,0xc71f,0xbeff,0xbede,0xbedf,0xbeff,0xc6ff,0xbede,0xc6ff,0xc71f,0xb6de,0xcf3f,0x9dfb,0x21cb,0x29ac,0x21ed,0x220d,0x220d,0x21ec,0x2a0d,0x2a2d,0x2a8d,0x2a6d,0x2a2d,0x218c,0x21ab,0x2a2c,0x2a2c,0x324d,0x21ab,0x73f2,0x94b3,0x2a6e,0x4311,0x4312,0x4b54,0x5354,0x4b54,0x5354,0x63d7,0x747a,0x7c9b,0x84bb,0x9d5e,0xa5bf,0xb61f,0xc69f,0xd71f,0xd71f,0xd71f,0xd71f,0xdf5f,0xe7bf,0xe79f,0xe77f,0xd73f,0xcf1f,0xc6bf,0xbe7f,0xc69f,0xc6bf,0xcedf,0xc6df,0xceff,0xcf1f,0xd75f,0xd6fe,0x31c9,0x2168,0x29aa,0x29ab,0x29aa,0x2189,0x2168,0x29a9,0x29cb,0x29ab,0x21ab,0x29aa,0x298a,0x29ca,0x29aa,0x29cb,0x29cc,0x29cb,0x21cb,0x29cc,0x2a0d,0x222e,0x220e,0x224f,0x2270,0x224f,0x222f,0x222f,0x21ed,0x21cd,0x21ac,0x19cc,0x21ed,0x21cd,0x21cc,0x21ed,0x19ed,0x220e,0x21ed,0x21cd,0x21cd,0x21cd,0x19ac,0x19ed,0x19ee,0x220e,0x220f,0x222f,0x222f,0x11ee,0x63b2,0xffdf,0xefbf,0xc6ff,0xb6bf,0xb69e,0xb6be,0xbedf,0xc71f,0xbede,0xb6bf,0xbeff,0xc6ff,0xc71f,0xc73f,0x9558,0x198a,0x21cc,0x21ec,0x220d,0x2a2d,0x21ec,0x2a0c,0x222d,0x32af,0x2a8d,0x2a6d,0x21cc,0x218a,0x2a0c,0x29ec,0x322d,0x21eb,0x73f3,
0x9493,0x21ca,0x4311,0x4311,0x4b33,0x4b33,0x4b53,0x5374,0x63d7,0x745a,0x747a,0x84dc,0x9d7e,0xa5df,0xb5ff,0xc67f,0xcebf,0xd6ff,0xe79f,0xdf7f,0xe79f,0xdf7f,0xe79f,0xe79f,0xd71f,0xcedf,0xc67f,0xc67f,0xbe7f,0xc6bf,0xc6bf,0xbe9f,0xc6bf,0xd75f,0xdf9f,0xdf9f,0x6bf2,0x2148,0x218a,0x29aa,0x29aa,0x29a9,0x29aa,0x29ab,0x29cb,0x29ab,0x29cb,0x298a,0x29aa,0x29aa,0x218a,0x29aa,0x29ab,0x29cb,0x29ec,0x29ed,0x21ec,0x222e,0x220f,0x222f,0x224f,0x222f,0x222f,0x222e,0x21ac,0x21ac,0x21cc,0x21cc,0x21cc,0x21ed,0x21cc,0x19ed,0x21cd,0x21ed,0x21ed,0x19cd,0x19ee,0x21cc,0x21cc,0x21cd,0x19ee,0x1a0e,0x21ce,0x19ee,0x1a0f,0x1a2f,0x2a0d,0xd6fc,0xf7df,0xcf1f,0xb69e,0xb69e,0x9e3e,0xae7e,0xb69e,0xbebe,0xc6fe,0xbeff,0xae9e,0xbf1f,0xbf1f,0x8d17,0x198b,0x21ed,0x220d,0x21ec,0x220c,0x2a0c,0x21ec,0x21cc,0x2a0c,0x328d,0x2aae,0x29ed,0x21ab,0x29ec,0x29ec,0x2a0c,0x19aa,0x73f2,0x8c93,0x2188,0x3aaf,0x4311,0x4af1,0x4311,0x4b32,0x5374,0x63b6,0x7459,0x747a,0x84dc,0x9d5e,0xa5de,0xadff,0xbe3f,0xbe3f,0xd6ff,0xe79f,0xe7bf,0xe7bf,0xe77f,0xdf5f,0xdf5f,0xd71f,0xcedf,0xc6bf,0xbe7f,0xc69f,0xc6bf,0xc69f,0xbe7f,0xc6df,0xdf5f,0xdf7f,0xe7bf,0x9557,0x2127,0x298a,0x29aa,0x29aa,0x21a9,0x29aa,0x29cb,0x29cb,0x21aa,0x29aa,0x298a,0x29aa,0x29aa,0x218a,0x298a,0x21ab,0x29cc,0x2a0d,0x21ec,0x29ed,0x2a2f,0x222f,0x222e,0x222f,0x222e,0x220e,0x2a0e,0x21ec,0x218b,0x21ac,0x21ac,0x21ac,0x19ec,0x21ed,0x220e,0x21cd,0x21ee,0x21ed,0x21ed,0x220e,0x19ac,0x19ac,0x19ac,0x19cd,0x19ed,0x21ac,0x21cd,0x19ee,0x224f,0x118c,0x94f6,0xffff,0xd71f,0xb69e,0xb69e,0xb6bf,0x9e3e,0x8ddd,0x9dfd,0xae9e,0xb69e,0xb6be,0xbeff,0xc71f,0x6c13,0x198b,0x21ec,0x220d,0x21ec,0x21cc,0x2a0c,0x2a0d,0x21ec,0x21ec,0x2a6d,0x328e,0x324e,0x21ab,0x29cb,0x21cb,0x2a2c,0x21cb,0x7c12,
0x8c93,0x2168,0x3a6d,0x4312,0x4311,0x4311,0x4332,0x4b53,0x5bb6,0x6c18,0x7c9b,0x84dc,0x955e,0xa5be,0xadff,0xbe3f,0xbe5f,0xd73f,0xdf7f,0xe79f,0xe7bf,0xe7bf,0xdf5f,0xdf3f,0xd6ff,0xcedf,0xc6df,0xbe9f,0xc6bf,0xc6bf,0xbe7f,0xb65f,0xc6df,0xcf1f,0xdf5f,0xe79f,0xb67c,0x2989,0x2168,0x2989,0x2989,0x29aa,0x29ab,0x29ab,0x29cb,0x29aa,0x29aa,0x29aa,0x29aa,0x298a,0x29aa,0x29aa,0x29cb,0x29ec,0x21ed,0x21ed,0x29ed,0x2a2f,0x220e,0x222e,0x222e,0x222e,0x21ed,0x29cd,0x21cc,0x21ac,0x21cc,0x21ec,0x21cc,0x21ec,0x220d,0x19ed,0x21ee,0x19ed,0x21cd,0x21ed,0x19ed,0x19ac,0x19ac,0x19cc,0x21ac,0x21ce,0x21cd,0x220e,0x1a0e,0x222f,0x19ef,0x4aef,0xf79f,0xef9f,0xb6be,0xa63d,0xa65d,0x9e1d,0x9e3e,0x9e3d,0xa67e,0x9e1d,0xb6bf,0xc71f,0xb65b,0x29cb,0x21cc,0x21cc,0x21ec,0x220c,0x21ec,0x21ec,0x29ec,0x21cc,0x21ed,0x2a4d,0x328e,0x2a4e,0x21ec,0x21ab,0x29ec,0x29eb,0x21eb,0x7c53,0x8c93,0x2169,0x324d,0x42f0,0x4b31,0x42f1,0x4b12,0x4b32,0x5b95,0x63f7,0x7c9a,0x84dc,0x953d,0xa5df,0xb5ff,0xaddf,0xc69f,0xd73f,0xdf7f,0xdf9f,0xdf5f,0xdf5f,0xdf7f,0xdf5f,0xcedf,0xcedf,0xbe7f,0xc69f,0xc6df,0xc69f,0xb65f,0xb65f,0xc6bf,0xcedf,0xd75f,0xdf7f,0xdf7f,0x4acd,0x2127,0x298a,0x298a,0x29ab,0x29ab,0x29cb,0x29cb,0x29cb,0x21aa,0x29ab,0x29ab,0x298a,0x29aa,0x29aa,0x29ab,0x29cc,0x29ed,0x2a2e,0x29ed,0x222e,0x220e,0x222e,0x222f,0x2a2f,0x21ed,0x21ab,0x218b,0x21ac,0x21ac,0x21ec,0x21ec,0x21ed,0x21ed,0x21ed,0x21ed,0x21cd,0x21ac,0x21ab,0x19cc,0x21cc,0x19ab,0x19ab,0x19cd,0x19cd,0x21cd,0x220f,0x1a4f,0x1a50,0x2271,0x11cc,0xb5d8,0xffff,0xcf1f,0xbebf,0xae5e,0x95dd,0x9e1d,0xae7e,0xb67e,0xa67e,0xbeff,0xcf5f,0x8d15,0x1169,0x220d,0x21ec,0x21ed,0x21cc,0x21ec,0x29ed,0x21cc,0x21cc,0x2a0d,0x2a2d,0x2a8e,0x2a6e,0x222d,0x21ac,0x21cc,0x29eb,0x19ab,0x7c54,
0x8c72,0x2168,0x324c,0x3af0,0x4311,0x4311,0x4312,0x4b32,0x5375,0x63b7,0x747a,0x84dc,0x955e,0xa5be,0xb5ff,0xb5ff,0xc67f,0xcf1f,0xdf9f,0xdf9f,0xdf7f,0xdf5f,0xdf7f,0xd71f,0xd6ff,0xceff,0xc69f,0xc6df,0xc6df,0xbe7f,0xb63f,0xb63f,0xbe7f,0xceff,0xd75f,0xdf7f,0xe7df,0x8494,0x18e6,0x298a,0x29cb,0x29cb,0x29ab,0x31cc,0x29cc,0x29ab,0x29aa,0x29ab,0x29cb,0x29ab,0x29ab,0x21cb,0x29cc,0x29cd,0x29ec,0x2a0e,0x21ed,0x220e,0x224f,0x2a4f,0x222f,0x222f,0x21cd,0x218a,0x196a,0x218b,0x21ac,0x21cd,0x21ed,0x19cd,0x21cc,0x21cd,0x21cd,0x21cd,0x21ab,0x21ac,0x19ac,0x19cd,0x198b,0x198b,0x19cd,0x19ee,0x21ee,0x1a0f,0x1a4f,0x1a2f,0x2271,0x19ce,0x5b50,0xf7bf,0xe79f,0xd75f,0xbedf,0xae7e,0x9e3d,0xa65e,0xa65d,0xb6be,0xbefe,0xd79f,0x8d16,0x1189,0x220d,0x21ec,0x21ec,0x21ac,0x21ec,0x29ed,0x21ec,0x21cc,0x220d,0x2a6e,0x2aaf,0x2a6e,0x220d,0x29ac,0x29ec,0x29eb,0x198a,0x7c54,0x8c72,0x2168,0x320c,0x3ad0,0x42f1,0x4311,0x4311,0x4b33,0x5374,0x63d7,0x747a,0x7c9b,0x955d,0xa5bf,0xaddf,0xb5ff,0xc69f,0xd73f,0xd75f,0xd73f,0xdf5f,0xdf7f,0xdf7f,0xcedf,0xd6ff,0xcebf,0xceff,0xceff,0xcedf,0xc69f,0xb63f,0xb63f,0xb65f,0xcf1f,0xd77f,0xd77f,0xdf9f,0xbe7c,0x3a6d,0x2168,0x2989,0x29cb,0x29cb,0x29cb,0x29ec,0x29ab,0x29ab,0x29cb,0x29ab,0x29ab,0x29cb,0x29ec,0x29ec,0x21cc,0x21cc,0x21ee,0x2a2f,0x21ed,0x222f,0x222e,0x220e,0x21ed,0x21cc,0x218b,0x2169,0x21ab,0x21cd,0x21cd,0x21cd,0x21cd,0x19cd,0x19cc,0x19cc,0x198b,0x218b,0x19ac,0x19ac,0x19cd,0x19cc,0x19ac,0x19ee,0x19ee,0x21ee,0x220e,0x1a0f,0x222f,0x224f,0x1a2f,0x21cc,0xce9b,0xf7df,0xd73f,0xc71e,0xc71f,0xc6ff,0xb69e,0xa65e,0xbedf,0xc6fe,0xe7df,0x7431,0x1149,0x220d,0x21ec,0x21ec,0x21cc,0x21cc,0x21cc,0x21ab,0x21cc,0x2a4e,0x2a6e,0x2a8e,0x2a4d,0x2a0d,0x21ac,0x21ac,0x21cb,0x196a,0x7c13,
0x8c93,0x2189,0x322c,0x42d0,0x42f1,0x4311,0x4311,0x4b33,0x5374,0x5bb5,0x7459,0x7c9b,0x8d1d,0x9d7e,0xaddf,0xb63f,0xbe5f,0xceff,0xd73f,0xdf5f,0xdf5f,0xdf5f,0xd71f,0xd71f,0xd6ff,0xcebf,0xcedf,0xceff,0xc6bf,0xc69f,0xbe5f,0xb63f,0xb65f,0xc6df,0xcf3f,0xd77f,0xdf9f,0xdf7f,0xae7f,0x84d8,0x3a6d,0x218a,0x29ec,0x29ec,0x29ec,0x29cb,0x29cb,0x29cb,0x29cb,0x29cb,0x29ab,0x29cb,0x29cb,0x29cb,0x29ec,0x2a0e,0x2a0e,0x29ed,0x222f,0x220e,0x21ed,0x21cd,0x29cd,0x218b,0x2169,0x21cc,0x21cd,0x21ed,0x21ed,0x21cd,0x21ac,0x21cb,0x19ab,0x19ac,0x19ac,0x21ac,0x21ac,0x21cc,0x21cc,0x19ac,0x19cd,0x19ce,0x19cd,0x19cd,0x1a0e,0x1a30,0x1a0e,0x1a2f,0x19ee,0x84b5,0xffff,0xdf3f,0xbede,0xbebe,0xc71f,0xb69e,0xb6be,0xb6bf,0xc73f,0xdf5f,0x3a09,0x1969,0x2a2d,0x220c,0x21ed,0x21ab,0x196b,0x29cc,0x42ad,0x324c,0x222d,0x226e,0x2a6e,0x2a4e,0x2a2d,0x21cc,0x218b,0x29eb,0x196a,0x73f3,0x8c93,0x2168,0x29eb,0x328e,0x4311,0x42f0,0x4b11,0x4b52,0x5373,0x5bb5,0x6c39,0x7c9b,0x84dc,0x955d,0xa5bf,0xb61f,0xbe7f,0xc69f,0xcedf,0xdf7f,0xdf7f,0xdf5f,0xd6ff,0xd71f,0xcedf,0xcedf,0xc6bf,0xcedf,0xc6df,0xbe7f,0xb65f,0xadff,0xb63f,0xbebf,0xc6ff,0xd77f,0xdf7f,0xdf9f,0xc6bf,0xb67f,0xb6be,0x7495,0x29ec,0x29ab,0x29cc,0x29ec,0x29cb,0x29cb,0x29ab,0x29ab,0x29ab,0x29cb,0x29ab,0x29cb,0x29ec,0x2a4e,0x2a2e,0x29ed,0x222e,0x222f,0x21ed,0x21ab,0x218a,0x216a,0x1949,0x218b,0x220e,0x21ed,0x21cc,0x19cc,0x21cd,0x21ac,0x21cd,0x220e,0x21cd,0x21ac,0x21ab,0x21cc,0x19ab,0x198b,0x21cd,0x19ad,0x19cd,0x19ee,0x1a0e,0x222f,0x222f,0x2250,0x1a0f,0x326e,0xe73d,0xef9f,0xcf1f,0xbebe,0xae7e,0xa65e,0xbebe,0xb67e,0xcf5f,0x7c52,0x0021,0x1969,0x222d,0x21ed,0x198b,0x7c33,0x7412,0x8473,0x6b91,0x6bd2,0x220d,0x2a6e,0x2a8e,0x2aaf,0x328e,0x2a0d,0x21cb,0x21cb,0x198b,0x73d2,
0x8c93,0x2188,0x320b,0x324c,0x4312,0x42f0,0x4af0,0x4b31,0x4b53,0x5bb5,0x6c18,0x7c9b,0x84dc,0x953d,0xa59e,0xaddf,0xbe7f,0xbe5f,0xcedf,0xdf5f,0xdf7f,0xdf5f,0xd71f,0xd71f,0xcedf,0xcebf,0xc6bf,0xcf1f,0xcedf,0xbe9f,0xae3f,0xadff,0xb63f,0xbe7f,0xcf1f,0xd77f,0xd75f,0xdf9f,0xd71f,0xa5fe,0xbe9f,0xcf3f,0xa5fb,0x42ae,0x218a,0x29cb,0x29cb,0x29cb,0x29cb,0x29cb,0x29cb,0x29ab,0x21ab,0x2a0e,0x2a2e,0x2a4f,0x29ed,0x21ab,0x21ee,0x2a2e,0x21ec,0x218a,0x216a,0x196a,0x21ab,0x21ad,0x21ee,0x21ed,0x21ab,0x218b,0x19ee,0x19ed,0x220e,0x1a0e,0x21cd,0x21ac,0x21cd,0x19cd,0x19ac,0x21ac,0x19ac,0x19cd,0x19cd,0x19ee,0x19cd,0x19cd,0x1a30,0x2250,0x1a30,0x11cd,0x9d57,0xf7ff,0xdf7f,0xc71f,0xb69e,0xae7e,0xae9e,0xb69f,0xcf3f,0x3a2a,0x0020,0x1147,0x222d,0x19cb,0x5b91,0xa557,0x7c32,0x4ace,0x198b,0x29ec,0x2a8f,0x2a6e,0x2aaf,0x224e,0x224e,0x222d,0x21cb,0x29cc,0x196a,0x7bf3,0x8c72,0x1968,0x320b,0x320a,0x42f1,0x4311,0x4b11,0x4b31,0x4b52,0x5394,0x63f7,0x84bc,0x84fc,0x953d,0xa59e,0xadff,0xbe5f,0xbe5f,0xc6bf,0xceff,0xdf7f,0xdf7f,0xdf5f,0xcf3f,0xcf1f,0xcedf,0xceff,0xceff,0xc6df,0xbe9f,0xae3f,0xadff,0xadff,0xb65f,0xceff,0xcf3f,0xd73f,0xdf7f,0xdfbf,0xa61e,0xae1f,0xbe9f,0xc6ff,0xbefe,0x5bf3,0x216a,0x29ab,0x29cb,0x29ec,0x29ec,0x29cb,0x29ab,0x29cb,0x21ed,0x2a2e,0x224f,0x222e,0x21ab,0x21cc,0x29ed,0x21ac,0x218b,0x218a,0x218b,0x21ac,0x198b,0x21ac,0x21ed,0x19ed,0x19ed,0x19ee,0x21ee,0x220e,0x1a0e,0x19ed,0x19cd,0x21cd,0x19cd,0x19cc,0x21ac,0x19cd,0x21cc,0x21ac,0x19ad,0x19cd,0x19ed,0x2210,0x220f,0x1a0f,0x1a0f,0x42f0,0xef7f,0xdf7f,0xc71e,0xb6bf,0xb6bf,0xae5e,0xcf3f,0xdf7f,0x31e8,0x0021,0x1127,0x220d,0x8494,0xce7a,0x532f,0x21ab,0x6390,0xa577,0x73f2,0x7c33,0x8d15,0x9d77,0x8cd5,0x8cf6,0x5391,0x73f2,0x8c74,0x29cb,0x73f2,
0x8c72,0x2147,0x31ea,0x29a8,0x3a6d,0x4311,0x4b10,0x4b31,0x5352,0x5374,0x63f7,0x7c9b,0x8cfd,0x953d,0x9d7e,0xadff,0xb63f,0xc67f,0xc69f,0xc6df,0xdf7f,0xdf7f,0xdf9f,0xdf7f,0xd73f,0xcf1f,0xd75f,0xcf1f,0xc6df,0xbe9f,0xb65f,0xaddf,0xa5df,0xb65f,0xc6ff,0xd75f,0xd75f,0xdf7f,0xefdf,0xbede,0xa5ff,0xbe9f,0xbe9f,0xc6ff,0xcf5f,0x6414,0x21ab,0x29cb,0x29cb,0x29cb,0x29cb,0x29cc,0x29cb,0x29cc,0x2a0e,0x2a2e,0x2a0d,0x218a,0x21ec,0x21ac,0x21cd,0x21cc,0x216a,0x218b,0x21ac,0x21cd,0x21cd,0x220e,0x19ed,0x19cd,0x21ee,0x19cd,0x21ee,0x21ee,0x19cd,0x21ac,0x19ac,0x198c,0x21ab,0x198b,0x21cd,0x19ac,0x19ac,0x19cd,0x19cd,0x19ed,0x1a2f,0x1a50,0x2250,0x220f,0x220d,0xce7b,0xf7df,0xbebe,0xae7f,0xb69e,0xcf1e,0xf7ff,0xc65a,0x10c3,0x0841,0x08c6,0x42f0,0x8cb4,0x6bb1,0x5b51,0x5330,0x7c73,0x7c52,0x7c53,0x9516,0x84b4,0x8cd5,0x9d77,0x6c13,0x8cb5,0x9d15,0x7c13,0x198b,0x73d2,0x8c92,0x2127,0x31ea,0x1926,0x29a9,0x4b11,0x4310,0x4b31,0x5332,0x5354,0x63d6,0x7c9a,0x84fd,0x8cfd,0x9d5e,0xadff,0xae1f,0xc69f,0xbe7f,0xd73f,0xd75e,0xdf7f,0xd75f,0xdf5f,0xd73f,0xd75f,0xd75f,0xd73f,0xc6ff,0xc6df,0xb65f,0xa5bf,0xa5bf,0xb63f,0xc6ff,0xd77f,0xdf7f,0xdf9f,0xefff,0xefdf,0xb69f,0xbe7f,0xbe9f,0xbebf,0xcf1f,0xd77f,0x74d6,0x21cb,0x29cb,0x29cc,0x29ec,0x21cc,0x29ab,0x29cb,0x2a0e,0x29cc,0x29cb,0x218b,0x21cc,0x218a,0x21cd,0x21cc,0x21ab,0x21ac,0x21ac,0x21ee,0x21ed,0x21ed,0x220e,0x21ac,0x19cd,0x19cd,0x21cd,0x19cd,0x19cc,0x19ac,0x21cd,0x21cd,0x21ac,0x21cc,0x19ac,0x19ac,0x19ac,0x19ad,0x19ed,0x1a0e,0x222f,0x2250,0x2270,0x1a2f,0x118c,0x7413,0xffff,0xd75f,0xa67e,0xbede,0xefff,0xe79f,0x52cc,0x0041,0x0841,0x10c6,0x21ed,0x21ec,0x19ab,0x29ed,0x6371,0x322d,0x198b,0x2a2d,0x2a8f,0x2a91,0x2290,0x226e,0x224e,0x324f,0x324e,0x19ab,0x196b,0x73f3,

};


